/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.internal;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.internal.Fraction;
import com.github.pemistahl.lingua.internal.JsonLanguageModel;
import com.github.pemistahl.lingua.internal.Ngram;
import com.github.pemistahl.lingua.internal.TrainingDataLanguageModel;
import com.github.pemistahl.lingua.internal.util.extension.MapExtensionsKt;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\b\u0018\u0000 #2\u00020\u0001:\u0001#BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u00c6\u0003JO\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u00052\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001J\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020!H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/github/pemistahl/lingua/internal/TrainingDataLanguageModel;", "", "language", "Lcom/github/pemistahl/lingua/api/Language;", "absoluteFrequencies", "", "Lcom/github/pemistahl/lingua/internal/Ngram;", "", "relativeFrequencies", "Lcom/github/pemistahl/lingua/internal/Fraction;", "jsonRelativeFrequencies", "Lit/unimi/dsi/fastutil/objects/Object2DoubleMap;", "(Lcom/github/pemistahl/lingua/api/Language;Ljava/util/Map;Ljava/util/Map;Lit/unimi/dsi/fastutil/objects/Object2DoubleMap;)V", "getAbsoluteFrequencies", "()Ljava/util/Map;", "getJsonRelativeFrequencies", "()Lit/unimi/dsi/fastutil/objects/Object2DoubleMap;", "getLanguage", "()Lcom/github/pemistahl/lingua/api/Language;", "getRelativeFrequencies", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getRelativeFrequency", "", "ngram", "hashCode", "toJson", "", "toString", "Companion", "lingua"})
public final class TrainingDataLanguageModel {
    @NotNull
    private final Language language;
    @NotNull
    private final Map<Ngram, Integer> absoluteFrequencies;
    @NotNull
    private final Map<Ngram, Fraction> relativeFrequencies;
    @NotNull
    private final Object2DoubleMap<Ngram> jsonRelativeFrequencies;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final double getRelativeFrequency(@NotNull Ngram ngram) {
        Intrinsics.checkNotNullParameter((Object)ngram, (String)"ngram");
        return this.jsonRelativeFrequencies.getDouble((Object)ngram);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toJson() {
        Map map2;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        boolean bl = false;
        Map ngrams = new LinkedHashMap();
        Object object = this.relativeFrequencies;
        boolean bl2 = false;
        Object object2 = object.entrySet().iterator();
        while (object2.hasNext()) {
            void ngram;
            Map.Entry<Ngram, Fraction> entry;
            Map.Entry<Ngram, Fraction> entry2 = entry = object2.next();
            boolean bl3 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            Fraction fraction = entry2.getValue();
            ((List)ngrams.computeIfAbsent(fraction, toJson.1.INSTANCE)).add(ngram);
        }
        object2 = ngrams;
        Language language = this.language;
        boolean $i$f$mapValues = false;
        void fraction = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl4 = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map2 = map3;
            boolean bl5 = false;
            String string = CollectionsKt.joinToString$default((Iterable)((Iterable)it.getValue()), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            map2.put(k2, string);
        }
        Map map4 = map2 = destination$iv$iv;
        Language language2 = language;
        JsonLanguageModel jsonLanguageModel = new JsonLanguageModel(language2, map4);
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonLanguageModel.class));
        boolean $i$f$cast = false;
        KSerializer kSerializer = $this$cast$iv$iv$iv;
        if (kSerializer == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
        }
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)kSerializer, (Object)jsonLanguageModel);
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final Map<Ngram, Integer> getAbsoluteFrequencies() {
        return this.absoluteFrequencies;
    }

    @NotNull
    public final Map<Ngram, Fraction> getRelativeFrequencies() {
        return this.relativeFrequencies;
    }

    @NotNull
    public final Object2DoubleMap<Ngram> getJsonRelativeFrequencies() {
        return this.jsonRelativeFrequencies;
    }

    public TrainingDataLanguageModel(@NotNull Language language, @NotNull Map<Ngram, Integer> absoluteFrequencies, @NotNull Map<Ngram, Fraction> relativeFrequencies, @NotNull Object2DoubleMap<Ngram> jsonRelativeFrequencies) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter(absoluteFrequencies, (String)"absoluteFrequencies");
        Intrinsics.checkNotNullParameter(relativeFrequencies, (String)"relativeFrequencies");
        Intrinsics.checkNotNullParameter(jsonRelativeFrequencies, (String)"jsonRelativeFrequencies");
        this.language = language;
        this.absoluteFrequencies = absoluteFrequencies;
        this.relativeFrequencies = relativeFrequencies;
        this.jsonRelativeFrequencies = jsonRelativeFrequencies;
    }

    @NotNull
    public final Language component1() {
        return this.language;
    }

    @NotNull
    public final Map<Ngram, Integer> component2() {
        return this.absoluteFrequencies;
    }

    @NotNull
    public final Map<Ngram, Fraction> component3() {
        return this.relativeFrequencies;
    }

    @NotNull
    public final Object2DoubleMap<Ngram> component4() {
        return this.jsonRelativeFrequencies;
    }

    @NotNull
    public final TrainingDataLanguageModel copy(@NotNull Language language, @NotNull Map<Ngram, Integer> absoluteFrequencies, @NotNull Map<Ngram, Fraction> relativeFrequencies, @NotNull Object2DoubleMap<Ngram> jsonRelativeFrequencies) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter(absoluteFrequencies, (String)"absoluteFrequencies");
        Intrinsics.checkNotNullParameter(relativeFrequencies, (String)"relativeFrequencies");
        Intrinsics.checkNotNullParameter(jsonRelativeFrequencies, (String)"jsonRelativeFrequencies");
        return new TrainingDataLanguageModel(language, absoluteFrequencies, relativeFrequencies, jsonRelativeFrequencies);
    }

    public static /* synthetic */ TrainingDataLanguageModel copy$default(TrainingDataLanguageModel trainingDataLanguageModel, Language language, Map map2, Map map3, Object2DoubleMap object2DoubleMap, int n, Object object) {
        if ((n & 1) != 0) {
            language = trainingDataLanguageModel.language;
        }
        if ((n & 2) != 0) {
            map2 = trainingDataLanguageModel.absoluteFrequencies;
        }
        if ((n & 4) != 0) {
            map3 = trainingDataLanguageModel.relativeFrequencies;
        }
        if ((n & 8) != 0) {
            object2DoubleMap = trainingDataLanguageModel.jsonRelativeFrequencies;
        }
        return trainingDataLanguageModel.copy(language, map2, map3, object2DoubleMap);
    }

    @NotNull
    public String toString() {
        return "TrainingDataLanguageModel(language=" + (Object)((Object)this.language) + ", absoluteFrequencies=" + this.absoluteFrequencies + ", relativeFrequencies=" + this.relativeFrequencies + ", jsonRelativeFrequencies=" + this.jsonRelativeFrequencies + ")";
    }

    public int hashCode() {
        Language language = this.language;
        Map<Ngram, Integer> map2 = this.absoluteFrequencies;
        Map<Ngram, Fraction> map3 = this.relativeFrequencies;
        Object2DoubleMap<Ngram> object2DoubleMap = this.jsonRelativeFrequencies;
        return (((language != null ? ((Object)((Object)language)).hashCode() : 0) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (map3 != null ? ((Object)map3).hashCode() : 0)) * 31 + (object2DoubleMap != null ? object2DoubleMap.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TrainingDataLanguageModel)) break block3;
                TrainingDataLanguageModel trainingDataLanguageModel = (TrainingDataLanguageModel)object;
                if (!Intrinsics.areEqual((Object)((Object)this.language), (Object)((Object)trainingDataLanguageModel.language)) || !Intrinsics.areEqual(this.absoluteFrequencies, trainingDataLanguageModel.absoluteFrequencies) || !Intrinsics.areEqual(this.relativeFrequencies, trainingDataLanguageModel.relativeFrequencies) || !Intrinsics.areEqual(this.jsonRelativeFrequencies, trainingDataLanguageModel.jsonRelativeFrequencies)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\tH\u0002JD\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\n\u001a\u00020\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ@\u0010\u0013\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a8\u0006\u0016"}, d2={"Lcom/github/pemistahl/lingua/internal/TrainingDataLanguageModel$Companion;", "", "()V", "computeAbsoluteFrequencies", "", "Lcom/github/pemistahl/lingua/internal/Ngram;", "", "text", "Lkotlin/sequences/Sequence;", "", "ngramLength", "charClass", "computeRelativeFrequencies", "Lcom/github/pemistahl/lingua/internal/Fraction;", "absoluteFrequencies", "lowerNgramAbsoluteFrequencies", "fromJson", "Lcom/github/pemistahl/lingua/internal/TrainingDataLanguageModel;", "json", "fromText", "language", "Lcom/github/pemistahl/lingua/api/Language;", "lingua"})
    public static final class Companion {
        @NotNull
        public final TrainingDataLanguageModel fromText(@NotNull Sequence<String> text, @NotNull Language language, int ngramLength, @NotNull String charClass, @NotNull Map<Ngram, Integer> lowerNgramAbsoluteFrequencies) {
            Intrinsics.checkNotNullParameter(text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            Intrinsics.checkNotNullParameter((Object)charClass, (String)"charClass");
            Intrinsics.checkNotNullParameter(lowerNgramAbsoluteFrequencies, (String)"lowerNgramAbsoluteFrequencies");
            int n = ngramLength;
            n = 1 <= n && 5 >= n ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            if (n == 0) {
                boolean bl3 = false;
                String string = "ngram length " + ngramLength + " is not in range 1..5";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Map<Ngram, Integer> absoluteFrequencies = this.computeAbsoluteFrequencies(text, ngramLength, charClass);
            Map<Ngram, Fraction> relativeFrequencies = this.computeRelativeFrequencies(ngramLength, absoluteFrequencies, lowerNgramAbsoluteFrequencies);
            return new TrainingDataLanguageModel(language, absoluteFrequencies, relativeFrequencies, (Object2DoubleMap<Ngram>)((Object2DoubleMap)new Object2DoubleOpenHashMap()));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TrainingDataLanguageModel fromJson(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            StringFormat $this$decodeFromString$iv = (StringFormat)Json.Default;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer22 = false;
            KSerializer $this$cast$iv$iv$iv22 = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonLanguageModel.class));
            boolean $i$f$cast2 = false;
            KSerializer kSerializer = $this$cast$iv$iv$iv22;
            if (kSerializer == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
            }
            JsonLanguageModel jsonLanguageModel = (JsonLanguageModel)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)kSerializer, json);
            Object2DoubleOpenHashMap jsonRelativeFrequencies = new Object2DoubleOpenHashMap();
            Object $i$f$serializer22 = jsonLanguageModel.getNgrams();
            boolean $this$cast$iv$iv$iv22 = false;
            Iterator<Map.Entry<Fraction, String>> iterator = $i$f$serializer22.entrySet().iterator();
            while (iterator.hasNext()) {
                void fraction;
                Map.Entry<Fraction, String> entry;
                Map.Entry<Fraction, String> $i$f$cast2 = entry = iterator.next();
                boolean bl = false;
                $i$f$serializer22 = $i$f$cast2.getKey();
                $i$f$cast2 = entry;
                bl = false;
                String ngrams = $i$f$cast2.getValue();
                double fractionAsDouble = fraction.doubleValue();
                for (String ngram : StringsKt.split$default((CharSequence)ngrams, (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null)) {
                    ((Map)jsonRelativeFrequencies).put(new Ngram(ngram), fractionAsDouble);
                }
            }
            return new TrainingDataLanguageModel(jsonLanguageModel.getLanguage(), MapsKt.emptyMap(), MapsKt.emptyMap(), (Object2DoubleMap<Ngram>)((Object2DoubleMap)jsonRelativeFrequencies));
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Ngram, Integer> computeAbsoluteFrequencies(Sequence<String> text, int ngramLength, String charClass) {
            boolean bl = false;
            HashMap absoluteFrequencies = new HashMap();
            Regex regex = new Regex('[' + charClass + "]+");
            Iterator iterator = text.iterator();
            block0: while (iterator.hasNext()) {
                String lowerCasedLine;
                String line;
                String string = line = (String)iterator.next();
                int n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                int n2 = 0;
                n = lowerCasedLine.length() - ngramLength;
                if (n2 > n) continue;
                while (true) {
                    void i;
                    String textSlice;
                    if (regex.matches((CharSequence)(textSlice = StringsKt.slice((String)lowerCasedLine, (IntRange)RangesKt.until((int)i, (int)(i + ngramLength)))))) {
                        Ngram ngram = new Ngram(textSlice);
                        MapExtensionsKt.incrementCounter(absoluteFrequencies, ngram);
                    }
                    if (i == n) continue block0;
                    ++i;
                }
            }
            return absoluteFrequencies;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Ngram, Fraction> computeRelativeFrequencies(int ngramLength, Map<Ngram, Integer> absoluteFrequencies, Map<Ngram, Integer> lowerNgramAbsoluteFrequencies) {
            boolean bl = false;
            HashMap ngramProbabilities = new HashMap();
            int totalNgramFrequency = CollectionsKt.sumOfInt((Iterable)absoluteFrequencies.values());
            Object object = absoluteFrequencies;
            boolean bl2 = false;
            Iterator<Map.Entry<Ngram, Integer>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void ngram;
                int n;
                Map.Entry<Ngram, Integer> entry;
                Map.Entry<Ngram, Integer> entry2 = entry = iterator.next();
                int n2 = 0;
                object = entry2.getKey();
                entry2 = entry;
                n2 = 0;
                int frequency = ((Number)entry2.getValue()).intValue();
                if (ngramLength == 1 || lowerNgramAbsoluteFrequencies.isEmpty()) {
                    n = totalNgramFrequency;
                } else {
                    n2 = 0;
                    n = ((Number)MapsKt.getValue(lowerNgramAbsoluteFrequencies, (Object)new Ngram(StringsKt.slice((String)ngram.getValue(), (IntRange)new IntRange(n2, ngramLength - 2))))).intValue();
                }
                int denominator = n;
                ((Map)ngramProbabilities).put(ngram, new Fraction(frequency, denominator));
            }
            return ngramProbabilities;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

