/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.internal;

import com.github.pemistahl.lingua.internal.Ngram;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/github/pemistahl/lingua/internal/TestDataLanguageModel;", "", "ngrams", "", "Lcom/github/pemistahl/lingua/internal/Ngram;", "(Ljava/util/Set;)V", "getNgrams", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "lingua"})
public final class TestDataLanguageModel {
    @NotNull
    private final Set<Ngram> ngrams;
    private static final Regex LETTER_REGEX;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Set<Ngram> getNgrams() {
        return this.ngrams;
    }

    public TestDataLanguageModel(@NotNull Set<Ngram> ngrams) {
        Intrinsics.checkNotNullParameter(ngrams, (String)"ngrams");
        this.ngrams = ngrams;
    }

    static {
        Companion = new Companion(null);
        LETTER_REGEX = new Regex("\\p{L}+");
    }

    @NotNull
    public final Set<Ngram> component1() {
        return this.ngrams;
    }

    @NotNull
    public final TestDataLanguageModel copy(@NotNull Set<Ngram> ngrams) {
        Intrinsics.checkNotNullParameter(ngrams, (String)"ngrams");
        return new TestDataLanguageModel(ngrams);
    }

    public static /* synthetic */ TestDataLanguageModel copy$default(TestDataLanguageModel testDataLanguageModel, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = testDataLanguageModel.ngrams;
        }
        return testDataLanguageModel.copy(set);
    }

    @NotNull
    public String toString() {
        return "TestDataLanguageModel(ngrams=" + this.ngrams + ")";
    }

    public int hashCode() {
        Set<Ngram> set = this.ngrams;
        return set != null ? ((Object)set).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TestDataLanguageModel)) break block3;
                TestDataLanguageModel testDataLanguageModel = (TestDataLanguageModel)object;
                if (!Intrinsics.areEqual(this.ngrams, testDataLanguageModel.ngrams)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/github/pemistahl/lingua/internal/TestDataLanguageModel$Companion;", "", "()V", "LETTER_REGEX", "Lkotlin/text/Regex;", "fromText", "Lcom/github/pemistahl/lingua/internal/TestDataLanguageModel;", "text", "", "ngramLength", "", "lingua"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TestDataLanguageModel fromText(@NotNull String text, int ngramLength) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int n = ngramLength;
            n = 1 <= n && 5 >= n ? 1 : 0;
            int n2 = 0;
            int n3 = 0;
            if (n == 0) {
                boolean bl = false;
                String string = "ngram length " + ngramLength + " is not in range 1..5";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            n2 = 0;
            HashSet<Ngram> ngrams = new HashSet<Ngram>();
            n2 = 0;
            n3 = text.length() - ngramLength;
            if (n2 <= n3) {
                while (true) {
                    void i;
                    String textSlice = StringsKt.slice((String)text, (IntRange)RangesKt.until((int)i, (int)(i + ngramLength)));
                    if (LETTER_REGEX.matches((CharSequence)textSlice)) {
                        Ngram ngram = new Ngram(textSlice);
                        ngrams.add(ngram);
                    }
                    if (i == n3) break;
                    ++i;
                }
            }
            return new TestDataLanguageModel((Set<Ngram>)ngrams);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

