/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.internal;

import com.github.pemistahl.lingua.api.Language;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntPredicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0080\u0001\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"\u00a8\u0006$"}, d2={"Lcom/github/pemistahl/lingua/internal/Alphabet;", "", "(Ljava/lang/String;I)V", "script", "Ljava/lang/Character$UnicodeScript;", "getScript", "()Ljava/lang/Character$UnicodeScript;", "matches", "", "chr", "", "input", "", "supportedLanguages", "", "Lcom/github/pemistahl/lingua/api/Language;", "ARABIC", "ARMENIAN", "BENGALI", "CYRILLIC", "DEVANAGARI", "GEORGIAN", "GREEK", "GUJARATI", "GURMUKHI", "HAN", "HANGUL", "HEBREW", "HIRAGANA", "KATAKANA", "LATIN", "TAMIL", "TELUGU", "THAI", "NONE", "Companion", "lingua"})
public final class Alphabet
extends Enum<Alphabet> {
    public static final /* enum */ Alphabet ARABIC;
    public static final /* enum */ Alphabet ARMENIAN;
    public static final /* enum */ Alphabet BENGALI;
    public static final /* enum */ Alphabet CYRILLIC;
    public static final /* enum */ Alphabet DEVANAGARI;
    public static final /* enum */ Alphabet GEORGIAN;
    public static final /* enum */ Alphabet GREEK;
    public static final /* enum */ Alphabet GUJARATI;
    public static final /* enum */ Alphabet GURMUKHI;
    public static final /* enum */ Alphabet HAN;
    public static final /* enum */ Alphabet HANGUL;
    public static final /* enum */ Alphabet HEBREW;
    public static final /* enum */ Alphabet HIRAGANA;
    public static final /* enum */ Alphabet KATAKANA;
    public static final /* enum */ Alphabet LATIN;
    public static final /* enum */ Alphabet TAMIL;
    public static final /* enum */ Alphabet TELUGU;
    public static final /* enum */ Alphabet THAI;
    public static final /* enum */ Alphabet NONE;
    private static final /* synthetic */ Alphabet[] $VALUES;
    @Nullable
    private final Character.UnicodeScript script;
    @NotNull
    public static final Companion Companion;

    static {
        Alphabet[] alphabetArray = new Alphabet[19];
        Alphabet[] alphabetArray2 = alphabetArray;
        alphabetArray[0] = ARABIC = new Alphabet();
        alphabetArray[1] = ARMENIAN = new Alphabet();
        alphabetArray[2] = BENGALI = new Alphabet();
        alphabetArray[3] = CYRILLIC = new Alphabet();
        alphabetArray[4] = DEVANAGARI = new Alphabet();
        alphabetArray[5] = GEORGIAN = new Alphabet();
        alphabetArray[6] = GREEK = new Alphabet();
        alphabetArray[7] = GUJARATI = new Alphabet();
        alphabetArray[8] = GURMUKHI = new Alphabet();
        alphabetArray[9] = HAN = new Alphabet();
        alphabetArray[10] = HANGUL = new Alphabet();
        alphabetArray[11] = HEBREW = new Alphabet();
        alphabetArray[12] = HIRAGANA = new Alphabet();
        alphabetArray[13] = KATAKANA = new Alphabet();
        alphabetArray[14] = LATIN = new Alphabet();
        alphabetArray[15] = TAMIL = new Alphabet();
        alphabetArray[16] = TELUGU = new Alphabet();
        alphabetArray[17] = THAI = new Alphabet();
        alphabetArray[18] = NONE = new Alphabet();
        $VALUES = alphabetArray;
        Companion = new Companion(null);
    }

    @Nullable
    public final Character.UnicodeScript getScript() {
        return this.script;
    }

    public final boolean matches(char chr) {
        return this.script != null ? Character.UnicodeScript.of(chr) == this.script : false;
    }

    public final boolean matches(@NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.script != null ? input.codePoints().allMatch(new IntPredicate(this){
            final /* synthetic */ Alphabet this$0;

            public final boolean test(int it) {
                return Character.UnicodeScript.of(it) == this.this$0.getScript();
            }
            {
                this.this$0 = alphabet;
            }
        }) : false;
    }

    private final Set<Language> supportedLanguages() {
        boolean bl = false;
        Set languages = new LinkedHashSet();
        for (Language language : Language.values()) {
            if (!language.getAlphabets$lingua().contains((Object)this)) continue;
            languages.add(language);
        }
        return languages;
    }

    private Alphabet() {
        Character.UnicodeScript unicodeScript;
        Alphabet alphabet;
        Alphabet alphabet2 = this;
        try {
            alphabet = alphabet2;
            unicodeScript = Character.UnicodeScript.forName(this.name());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            alphabet = alphabet2;
            unicodeScript = null;
        }
        alphabet.script = unicodeScript;
    }

    public static Alphabet[] values() {
        return (Alphabet[])$VALUES.clone();
    }

    public static Alphabet valueOf(String string) {
        return Enum.valueOf(Alphabet.class, string);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a8\u0006\u0007"}, d2={"Lcom/github/pemistahl/lingua/internal/Alphabet$Companion;", "", "()V", "allSupportingExactlyOneLanguage", "", "Lcom/github/pemistahl/lingua/internal/Alphabet;", "Lcom/github/pemistahl/lingua/api/Language;", "lingua"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<Alphabet, Language> allSupportingExactlyOneLanguage() {
            void $this$filterNotTo$iv$iv;
            boolean bl = false;
            Map alphabets = new LinkedHashMap();
            Alphabet[] $this$filterNot$iv = Alphabet.values();
            boolean $i$f$filterNot = false;
            Alphabet[] alphabetArray = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            void var9_9 = $this$filterNotTo$iv$iv;
            int n = ((void)var9_9).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var9_9[i];
                boolean bl2 = false;
                if (it == NONE) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Alphabet alphabet : (List)destination$iv$iv) {
                Set supportedLanguages = alphabet.supportedLanguages();
                if (supportedLanguages.size() != 1) continue;
                alphabets.put(alphabet, CollectionsKt.first((Iterable)supportedLanguages));
            }
            return alphabets;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

