/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.api.io;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.internal.Constant;
import com.github.pemistahl.lingua.internal.io.FilesWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J>\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J<\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0007J.\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/github/pemistahl/lingua/api/io/TestDataFilesWriter;", "Lcom/github/pemistahl/lingua/internal/io/FilesWriter;", "()V", "createAndWriteSentencesFile", "", "inputFilePath", "Ljava/nio/file/Path;", "inputFileCharset", "Ljava/nio/charset/Charset;", "outputDirectoryPath", "language", "Lcom/github/pemistahl/lingua/api/Language;", "maximumLines", "", "createAndWriteSingleWordsFile", "", "", "charClass", "createAndWriteTestDataFiles", "createAndWriteWordPairsFile", "words", "lingua"})
public final class TestDataFilesWriter
extends FilesWriter {
    @NotNull
    public static final TestDataFilesWriter INSTANCE;

    @JvmStatic
    public static final void createAndWriteTestDataFiles(@NotNull Path inputFilePath, @NotNull Charset inputFileCharset, @NotNull Path outputDirectoryPath, @NotNull Language language, @NotNull String charClass, int maximumLines) {
        Intrinsics.checkNotNullParameter((Object)inputFilePath, (String)"inputFilePath");
        Intrinsics.checkNotNullParameter((Object)inputFileCharset, (String)"inputFileCharset");
        Intrinsics.checkNotNullParameter((Object)outputDirectoryPath, (String)"outputDirectoryPath");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)charClass, (String)"charClass");
        INSTANCE.checkInputFilePath(inputFilePath);
        INSTANCE.checkOutputDirectoryPath(outputDirectoryPath);
        INSTANCE.createAndWriteSentencesFile(inputFilePath, inputFileCharset, outputDirectoryPath, language, maximumLines);
        List<String> singleWords = INSTANCE.createAndWriteSingleWordsFile(inputFilePath, inputFileCharset, outputDirectoryPath, language, charClass, maximumLines);
        INSTANCE.createAndWriteWordPairsFile(singleWords, outputDirectoryPath, language, maximumLines);
    }

    public static /* synthetic */ void createAndWriteTestDataFiles$default(Path path, Charset charset, Path path2, Language language, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 0x10) != 0) {
            string = "\\p{L}";
        }
        TestDataFilesWriter.createAndWriteTestDataFiles(path, charset, path2, language, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void createAndWriteSentencesFile(Path inputFilePath, Charset inputFileCharset, Path outputDirectoryPath, Language language, int maximumLines) {
        void $this$useLines$iv;
        String fileName = (Object)((Object)language.getIsoCode639_1()) + ".txt";
        Path sentencesDirectoryPath = outputDirectoryPath.resolve("sentences");
        Path sentencesFilePath = sentencesDirectoryPath.resolve(fileName);
        int lineCounter = 0;
        if (!Files.isDirectory(sentencesDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(sentencesDirectoryPath, new FileAttribute[0]);
        }
        if (Files.isRegularFile(sentencesFilePath, new LinkOption[0])) {
            Files.delete(sentencesFilePath);
        }
        File file = inputFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"inputFilePath.toFile()");
        Object object = file;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileInputStream((File)object3);
        bl3 = false;
        object2 = new InputStreamReader((InputStream)object3, inputFileCharset);
        bl2 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n2 = 8192;
        bl2 = false;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        n2 = 0;
        bl2 = false;
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl4 = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl5 = false;
            File file2 = sentencesFilePath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"sentencesFilePath.toFile()");
            Object object4 = file2;
            Charset charset = Charsets.UTF_8;
            int n3 = 8192;
            boolean bl6 = false;
            Object object5 = object4;
            boolean bl7 = false;
            Object object6 = object5;
            int n4 = 0;
            object6 = new FileOutputStream((File)object6);
            n4 = 0;
            object5 = new OutputStreamWriter((OutputStream)object6, charset);
            bl7 = false;
            object4 = object5 instanceof BufferedWriter ? (BufferedWriter)object5 : new BufferedWriter((Writer)object5, n3);
            boolean bl8 = false;
            n3 = 0;
            Throwable throwable2 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object4;
                boolean bl9 = false;
                for (String line : lines) {
                    if (lineCounter >= maximumLines) continue;
                    CharSequence charSequence = line;
                    Regex regex = Constant.INSTANCE.getMULTIPLE_WHITESPACE();
                    String string = " ";
                    boolean bl10 = false;
                    writer.write(StringsKt.replace$default((String)regex.replace(charSequence, string), (String)"\"", (String)"", (boolean)false, (int)4, null));
                    writer.newLine();
                    n4 = lineCounter;
                    lineCounter = n4 + 1;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable2);
            }
            object3 = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<String> createAndWriteSingleWordsFile(Path inputFilePath, Charset inputFileCharset, Path outputDirectoryPath, Language language, String charClass, int maximumLines) {
        void $this$useLines$iv;
        String fileName = (Object)((Object)language.getIsoCode639_1()) + ".txt";
        Path singleWordsDirectoryPath = outputDirectoryPath.resolve("single-words");
        Path singleWordsFilePath = singleWordsDirectoryPath.resolve(fileName);
        Regex wordRegex = new Regex('[' + charClass + "]{5,}");
        boolean bl = false;
        List words = new ArrayList();
        int lineCounter = 0;
        if (!Files.isDirectory(singleWordsDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(singleWordsDirectoryPath, new FileAttribute[0]);
        }
        if (Files.isRegularFile(singleWordsFilePath, new LinkOption[0])) {
            Files.delete(singleWordsFilePath);
        }
        File file = inputFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"inputFilePath.toFile()");
        Object object = file;
        int n = 8192;
        boolean bl2 = false;
        Object object2 = object;
        boolean bl3 = false;
        Object object3 = object2;
        boolean bl4 = false;
        object3 = new FileInputStream((File)object3);
        bl4 = false;
        object2 = new InputStreamReader((InputStream)object3, inputFileCharset);
        bl3 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n2 = 8192;
        bl3 = false;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        n2 = 0;
        bl3 = false;
        Object object4 = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl5 = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl6 = false;
            for (String line : lines) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                String it;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object object5 = line;
                Regex regex = Constant.INSTANCE.getPUNCTUATION();
                String string = "";
                boolean bl7 = false;
                object5 = regex.replace((CharSequence)object5, string);
                regex = Constant.INSTANCE.getNUMBERS();
                string = "";
                bl7 = false;
                object5 = regex.replace((CharSequence)object5, string);
                regex = Constant.INSTANCE.getMULTIPLE_WHITESPACE();
                string = " ";
                bl7 = false;
                object5 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)regex.replace((CharSequence)object5, string), (String)"\"", (String)"", (boolean)false, (int)4, null), (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                string = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string2;
                    String string3 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl8 = false;
                    String string4 = it;
                    boolean bl9 = false;
                    void v1 = string4;
                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                    bl9 = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string5.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                    collection.add(string2);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl10 = false;
                    if (!wordRegex.matches((CharSequence)it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List singleWords = (List)destination$iv$iv;
                words.addAll(singleWords);
            }
            object3 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object4 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object4);
        }
        File file2 = singleWordsFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"singleWordsFilePath.toFile()");
        object = file2;
        Charset charset = Charsets.UTF_8;
        int n3 = 8192;
        n2 = 0;
        object4 = object;
        boolean bl11 = false;
        Object bl5 = object4;
        int n4 = 0;
        bl5 = new FileOutputStream((File)bl5);
        n4 = 0;
        object4 = new OutputStreamWriter((OutputStream)bl5, charset);
        bl11 = false;
        object = object4 instanceof BufferedWriter ? (BufferedWriter)object4 : new BufferedWriter((Writer)object4, n3);
        boolean bl12 = false;
        n3 = 0;
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl13 = false;
            for (String word : words) {
                if (lineCounter >= maximumLines) break;
                writer.write(word);
                writer.newLine();
                n4 = lineCounter;
                lineCounter = n4 + 1;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void createAndWriteWordPairsFile(List<String> words, Path outputDirectoryPath, Language language, int maximumLines) {
        String fileName = (Object)((Object)language.getIsoCode639_1()) + ".txt";
        Path wordPairsDirectoryPath = outputDirectoryPath.resolve("word-pairs");
        Path wordPairsFilePath = wordPairsDirectoryPath.resolve(fileName);
        boolean bl = false;
        Set wordPairs = new LinkedHashSet();
        int lineCounter = 0;
        if (!Files.isDirectory(wordPairsDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(wordPairsDirectoryPath, new FileAttribute[0]);
        }
        if (Files.isRegularFile(wordPairsFilePath, new LinkOption[0])) {
            Files.delete(wordPairsFilePath);
        }
        int n = 0;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)new IntRange(n, words.size() - 2)), (int)2);
        int n2 = intProgression.getFirst();
        int n3 = intProgression.getLast();
        int n4 = intProgression.getStep();
        int n5 = n2;
        int n6 = n3;
        if (n4 >= 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i;
                n = i;
                wordPairs.add(CollectionsKt.joinToString$default((Iterable)CollectionsKt.slice(words, (IntRange)new IntRange(n, (int)(i + true))), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                if (i == n3) break;
                i += n4;
            }
        }
        File file = wordPairsFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"wordPairsFilePath.toFile()");
        Object object = file;
        Charset charset = Charsets.UTF_8;
        n4 = 8192;
        n = 0;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        int n7 = 0;
        object3 = new FileOutputStream((File)object3);
        n7 = 0;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl2 = false;
        object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n4);
        boolean bl3 = false;
        n4 = 0;
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl4 = false;
            for (String wordPair : wordPairs) {
                if (lineCounter >= maximumLines) break;
                writer.write(wordPair);
                writer.newLine();
                n7 = lineCounter;
                lineCounter = n7 + 1;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private TestDataFilesWriter() {
    }

    static {
        TestDataFilesWriter testDataFilesWriter;
        INSTANCE = testDataFilesWriter = new TestDataFilesWriter();
    }
}

