/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.api;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.api.LanguageDetector;
import com.github.pemistahl.lingua.internal.Alphabet;
import com.github.pemistahl.lingua.internal.Constant;
import com.github.pemistahl.lingua.internal.Ngram;
import com.github.pemistahl.lingua.internal.TestDataLanguageModel;
import com.github.pemistahl.lingua.internal.TrainingDataLanguageModel;
import com.github.pemistahl.lingua.internal.util.extension.CharExtensionsKt;
import com.github.pemistahl.lingua.internal.util.extension.MapExtensionsKt;
import com.github.pemistahl.lingua.internal.util.extension.StringExtensionsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 @2\u00020\u0001:\u0001@B/\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001aJ\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u0019\u001a\u00020\u0018J/\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0000\u00a2\u0006\u0002\b\"J#\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00042\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0!H\u0000\u00a2\u0006\u0002\b'J/\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010)\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0000\u00a2\u0006\u0002\b*J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0018J\u001b\u0010,\u001a\u00020\u00042\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00180.H\u0000\u00a2\u0006\u0002\b/J\u0013\u00100\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J!\u00102\u001a\b\u0012\u0004\u0012\u00020\u00040!2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00180.H\u0000\u00a2\u0006\u0002\b3J\b\u00104\u001a\u00020\nH\u0016J\u001d\u00105\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00042\u0006\u00106\u001a\u00020&H\u0000\u00a2\u0006\u0002\b7J\b\u00108\u001a\u000209H\u0002J\u001b\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00180.2\u0006\u0010\u0019\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b;JU\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\r2\u0018\u0010=\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\r0.2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0000\u00a2\u0006\u0002\b?R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006A"}, d2={"Lcom/github/pemistahl/lingua/api/LanguageDetector;", "", "languages", "", "Lcom/github/pemistahl/lingua/api/Language;", "minimumRelativeDistance", "", "isEveryLanguageModelPreloaded", "", "numberOfLoadedLanguages", "", "(Ljava/util/Set;DZI)V", "alphabetsSupportingExactlyOneLanguage", "", "Lcom/github/pemistahl/lingua/internal/Alphabet;", "getLanguages$lingua", "()Ljava/util/Set;", "languagesWithUniqueCharacters", "Lkotlin/sequences/Sequence;", "getMinimumRelativeDistance$lingua", "()D", "getNumberOfLoadedLanguages$lingua", "()I", "cleanUpInputText", "", "text", "cleanUpInputText$lingua", "computeLanguageConfidenceValues", "Ljava/util/SortedMap;", "computeLanguageProbabilities", "testDataModel", "Lcom/github/pemistahl/lingua/internal/TestDataLanguageModel;", "filteredLanguages", "", "computeLanguageProbabilities$lingua", "computeSumOfNgramProbabilities", "language", "ngrams", "Lcom/github/pemistahl/lingua/internal/Ngram;", "computeSumOfNgramProbabilities$lingua", "countUnigramsOfInputText", "unigramLanguageModel", "countUnigramsOfInputText$lingua", "detectLanguageOf", "detectLanguageWithRules", "words", "", "detectLanguageWithRules$lingua", "equals", "other", "filterLanguagesByRules", "filterLanguagesByRules$lingua", "hashCode", "lookUpNgramProbability", "ngram", "lookUpNgramProbability$lingua", "preloadLanguageModels", "", "splitTextIntoWords", "splitTextIntoWords$lingua", "sumUpProbabilities", "probabilities", "unigramCountsOfInputText", "sumUpProbabilities$lingua", "Companion", "lingua"})
public final class LanguageDetector {
    private final Sequence<Language> languagesWithUniqueCharacters;
    private final Map<Alphabet, Language> alphabetsSupportingExactlyOneLanguage;
    @NotNull
    private final Set<Language> languages;
    private final double minimumRelativeDistance;
    private final int numberOfLoadedLanguages;
    @NotNull
    private static Map<Language, ? extends Lazy<TrainingDataLanguageModel>> unigramLanguageModels;
    @NotNull
    private static Map<Language, ? extends Lazy<TrainingDataLanguageModel>> bigramLanguageModels;
    @NotNull
    private static Map<Language, ? extends Lazy<TrainingDataLanguageModel>> trigramLanguageModels;
    @NotNull
    private static Map<Language, ? extends Lazy<TrainingDataLanguageModel>> quadrigramLanguageModels;
    @NotNull
    private static Map<Language, ? extends Lazy<TrainingDataLanguageModel>> fivegramLanguageModels;
    @NotNull
    private static final List<Map<Language, Lazy<TrainingDataLanguageModel>>> languageModels;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Language detectLanguageOf(@NotNull String text) {
        Language language;
        Object v1;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SortedMap<Language, Double> confidenceValues = this.computeLanguageConfidenceValues(text);
        if (confidenceValues.isEmpty()) {
            return Language.UNKNOWN;
        }
        if (confidenceValues.size() == 1) {
            Language language2 = confidenceValues.firstKey();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)language2), (String)"confidenceValues.firstKey()");
            return language2;
        }
        Language mostLikelyLanguage = confidenceValues.firstKey();
        Double mostLikelyLanguageProbability = (Double)MapsKt.getValue((Map)confidenceValues, (Object)((Object)mostLikelyLanguage));
        Map $this$filterNot$iv = confidenceValues;
        boolean $i$f$filterNot = false;
        Object object = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Object t = $this$filterNotTo$iv$iv;
        boolean bl = false;
        Iterator iterator = t.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if ((Language)((Object)it.getKey()) == mostLikelyLanguage) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filterNot$iv = destination$iv$iv;
        boolean bl3 = false;
        object = $this$filterNot$iv.entrySet();
        boolean bl4 = false;
        Iterator iterator2 = object.iterator();
        if (!iterator2.hasNext()) {
            v1 = null;
        } else {
            t = iterator2.next();
            if (!iterator2.hasNext()) {
                v1 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl5 = false;
                Comparable comparable = (Double)it.getValue();
                do {
                    Object t2 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-LanguageDetector$detectLanguageOf$secondMostLikelyLanguage$2 = false;
                    Comparable comparable2 = (Double)it2.getValue();
                    if (comparable.compareTo(comparable2) >= 0) continue;
                    t = t2;
                    comparable = comparable2;
                } while (iterator2.hasNext());
                v1 = t;
            }
        }
        Map.Entry entry = v1;
        Intrinsics.checkNotNull((Object)entry);
        Language secondMostLikelyLanguage = (Language)((Object)entry.getKey());
        Double secondMostLikelyLanguageProbability = (Double)MapsKt.getValue((Map)confidenceValues, (Object)((Object)secondMostLikelyLanguage));
        if (Intrinsics.areEqual((Double)mostLikelyLanguageProbability, (Double)secondMostLikelyLanguageProbability)) {
            language = Language.UNKNOWN;
        } else {
            double d = mostLikelyLanguageProbability;
            Double d2 = secondMostLikelyLanguageProbability;
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"secondMostLikelyLanguageProbability");
            if (d - d2 < this.minimumRelativeDistance) {
                language = Language.UNKNOWN;
            } else {
                Language language3 = mostLikelyLanguage;
                language = language3;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)language3), (String)"mostLikelyLanguage");
            }
        }
        return language;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SortedMap<Language, Double> computeLanguageConfidenceValues(@NotNull String text) {
        Comparator sortedByConfidenceValue;
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map map2;
        Map<Language, Double> summedUpProbabilities;
        Map map3;
        Map probabilities;
        Object object2;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        void ngramSizeRange;
        IntRange intRange;
        int n;
        void filteredLanguages;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TreeMap values = new TreeMap();
        String cleanedUpText = this.cleanUpInputText$lingua(text);
        CharSequence charSequence = cleanedUpText;
        boolean bl = false;
        if (charSequence.length() == 0 || Constant.INSTANCE.getNO_LETTER().matches((CharSequence)cleanedUpText)) {
            return values;
        }
        List<String> words = this.splitTextIntoWords$lingua(cleanedUpText);
        Language languageDetectedByRules = this.detectLanguageWithRules$lingua(words);
        if (languageDetectedByRules != Language.UNKNOWN) {
            ((Map)values).put(languageDetectedByRules, 1.0);
            return values;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.filterLanguagesByRules$lingua(words);
        if (((Set)filteredLanguages.element).size() == 1) {
            Language filteredLanguage = (Language)((Object)((Set)filteredLanguages.element).iterator().next());
            ((Map)values).put(filteredLanguage, 1.0);
            return values;
        }
        Ref.ObjectRef filteredLanguage = new Ref.ObjectRef();
        if (cleanedUpText.length() >= 120) {
            n = 3;
            intRange = new IntRange(n, 3);
        } else {
            n = 1;
            intRange = new IntRange(n, 5);
        }
        filteredLanguage.element = intRange;
        List allProbabilitiesAndUnigramCounts2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Pair<? extends Map<Language, ? extends Double>, ? extends Map<Language, ? extends Integer>>>>, Object>(this, (Ref.ObjectRef)ngramSizeRange, cleanedUpText, (Ref.ObjectRef)filteredLanguages, null){
            private /* synthetic */ Object L$0;
            int label;
            final /* synthetic */ LanguageDetector this$0;
            final /* synthetic */ Ref.ObjectRef $ngramSizeRange;
            final /* synthetic */ String $cleanedUpText;
            final /* synthetic */ Ref.ObjectRef $filteredLanguages;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        int i;
                        Iterable $this$filterTo$iv$iv;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        Iterable $this$filter$iv = (Iterable)((IntRange)this.$ngramSizeRange.element);
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            i = ((Number)element$iv$iv).intValue();
                            boolean bl = false;
                            if (!Boxing.boxBoolean((this.$cleanedUpText.length() >= i ? 1 : 0) != 0).booleanValue()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            i = ((Number)item$iv$iv).intValue();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Deferred deferred = BuildersKt.async$default((CoroutineScope)$this$runBlocking, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends Map<Language, ? extends Double>, ? extends Map<Language, ? extends Integer>>>, Object>(i, null, this, $this$runBlocking){
                                int label;
                                final /* synthetic */ int $i;
                                final /* synthetic */ computeLanguageConfidenceValues.allProbabilitiesAndUnigramCounts.1 this$0;
                                final /* synthetic */ CoroutineScope $this_runBlocking$inlined;
                                {
                                    this.$i = n;
                                    this.this$0 = var3_3;
                                    this.$this_runBlocking$inlined = coroutineScope;
                                    super(2, continuation);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            TestDataLanguageModel testDataModel = TestDataLanguageModel.Companion.fromText(this.this$0.$cleanedUpText, this.$i);
                                            Map<Language, Double> probabilities = this.this$0.this$0.computeLanguageProbabilities$lingua(testDataModel, (Set)this.this$0.$filteredLanguages.element);
                                            Set<Language> languages = probabilities.keySet();
                                            Collection collection = languages;
                                            boolean bl = false;
                                            if (!collection.isEmpty()) {
                                                this.this$0.$filteredLanguages.element = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Set)this.this$0.$filteredLanguages.element)), (Function1)((Function1)new Function1<Language, Boolean>(languages){
                                                    final /* synthetic */ Set $languages;
                                                    {
                                                        this.$languages = set;
                                                        super(1);
                                                    }

                                                    public final boolean invoke(@NotNull Language it) {
                                                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                                        return this.$languages.contains((Object)((Object)it));
                                                    }
                                                })));
                                            }
                                            Map<Language, Integer> unigramCounts = this.$i == 1 ? this.this$0.this$0.countUnigramsOfInputText$lingua(testDataModel, (Set)this.this$0.$filteredLanguages.element) : null;
                                            return new Pair(probabilities, unigramCounts);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Pair<? extends Map<Language, ? extends Double>, ? extends Map<Language, ? extends Integer>>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            collection.add(deferred);
                        }
                        this.label = 1;
                        Object object3 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = languageDetector;
                this.$ngramSizeRange = objectRef;
                this.$cleanedUpText = string;
                this.$filteredLanguages = objectRef2;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super List<? extends Pair<? extends Map<Language, ? extends Double>, ? extends Map<Language, ? extends Integer>>>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Iterable $this$map$iv = allProbabilitiesAndUnigramCounts2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void $dstr$probabilities$_u24__u252;
            Pair pair = (Pair)item$iv$iv2;
            object2 = destination$iv$iv;
            boolean bl2 = false;
            map3 = probabilities = (Map)$dstr$probabilities$_u24__u252.component1();
            object2.add(map3);
        }
        List allProbabilities = (List)destination$iv$iv;
        Map map4 = (Map)((Pair)allProbabilitiesAndUnigramCounts2.get(0)).getSecond();
        if (map4 == null) {
            map4 = MapsKt.emptyMap();
        }
        Map unigramCounts = map4;
        Map<Language, Double> $i$f$mapTo22 = summedUpProbabilities = this.sumUpProbabilities$lingua(allProbabilities, unigramCounts, (Set)filteredLanguages.element);
        boolean bl3 = false;
        item$iv$iv2 = $i$f$mapTo22.entrySet();
        boolean $dstr$probabilities$_u24__u252 = false;
        Iterator bl2 = item$iv$iv2.iterator();
        if (!bl2.hasNext()) {
            map2 = null;
        } else {
            probabilities = bl2.next();
            if (!bl2.hasNext()) {
                map2 = probabilities;
            } else {
                Map.Entry it22 = (Map.Entry)((Object)probabilities);
                boolean bl42 = false;
                double it22 = ((Number)it22.getValue()).doubleValue();
                do {
                    Object bl42 = bl2.next();
                    Map.Entry it = (Map.Entry)bl42;
                    boolean $i$a$-maxByOrNull-LanguageDetector$computeLanguageConfidenceValues$highestProbability$2 = false;
                    double d = ((Number)it.getValue()).doubleValue();
                    if (Double.compare(it22, d) >= 0) continue;
                    probabilities = bl42;
                    it22 = d;
                } while (bl2.hasNext());
                map2 = probabilities;
            }
        }
        if ((object = (Map.Entry)((Object)map2)) == null || (object = (Double)object.getValue()) == null) {
            return MapsKt.sortedMapOf((Pair[])new Pair[0]);
        }
        double highestProbability = (Double)object;
        Map<Language, Double> $this$mapValues$iv = summedUpProbabilities;
        boolean $i$f$mapValues = false;
        Map<Language, Double> $dstr$probabilities$_u24__u252 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map5 = destination$iv$iv2;
            boolean bl5 = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            map3 = k;
            object2 = map5;
            boolean bl6 = false;
            Double d = highestProbability / ((Number)it.getValue()).doubleValue();
            object2.put(map3, d);
        }
        Map confidenceValues = destination$iv$iv2;
        $i$f$mapValues = false;
        Comparator comparator = sortedByConfidenceValue = (Comparator)new Comparator<T>(confidenceValues){
            final /* synthetic */ Map $confidenceValues$inlined;
            {
                this.$confidenceValues$inlined = map2;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                Language language = (Language)((Object)b);
                boolean bl2 = false;
                Comparable comparable = (Comparable)this.$confidenceValues$inlined.get((Object)((Object)language));
                language = (Language)((Object)a);
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = (Comparable)this.$confidenceValues$inlined.get((Object)((Object)language));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
        boolean bl7 = false;
        Comparator sortedByConfidenceValueThenByLanguage = new Comparator<T>(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    Language language = (Language)((Object)a);
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)language);
                    language = (Language)((Object)b);
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = (Comparable)((Object)language);
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
                return n;
            }
        };
        return MapsKt.toSortedMap((Map)confidenceValues, (Comparator)sortedByConfidenceValueThenByLanguage);
    }

    @NotNull
    public final String cleanUpInputText$lingua(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        boolean bl = false;
        charSequence = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        charSequence = string2;
        Regex regex = Constant.INSTANCE.getPUNCTUATION();
        String string3 = "";
        boolean bl2 = false;
        charSequence = regex.replace(charSequence, string3);
        regex = Constant.INSTANCE.getNUMBERS();
        string3 = "";
        bl2 = false;
        charSequence = regex.replace(charSequence, string3);
        regex = Constant.INSTANCE.getMULTIPLE_WHITESPACE();
        string3 = " ";
        bl2 = false;
        return regex.replace(charSequence, string3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> splitTextIntoWords$lingua(@NotNull String text) {
        List list;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        StringBuilder normalizedTextBuilder = new StringBuilder();
        String string = text;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char chr = string.charAt(i);
            normalizedTextBuilder.append(chr);
            if (!CharExtensionsKt.isLogogram(chr)) continue;
            normalizedTextBuilder.append(' ');
        }
        String string2 = normalizedTextBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalizedTextBuilder.toString()");
        String normalizedText = string2;
        if (StringsKt.contains$default((CharSequence)normalizedText, (char)' ', (boolean)false, (int)2, null)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)normalizedText, (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                boolean bl2 = false;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object)normalizedText);
        }
        return list;
    }

    @NotNull
    public final Map<Language, Integer> countUnigramsOfInputText$lingua(@NotNull TestDataLanguageModel unigramLanguageModel, @NotNull Set<? extends Language> filteredLanguages) {
        Intrinsics.checkNotNullParameter((Object)unigramLanguageModel, (String)"unigramLanguageModel");
        Intrinsics.checkNotNullParameter(filteredLanguages, (String)"filteredLanguages");
        boolean bl = false;
        Map unigramCounts = new LinkedHashMap();
        for (Language language : filteredLanguages) {
            for (Ngram unigram : unigramLanguageModel.getNgrams()) {
                double probability = this.lookUpNgramProbability$lingua(language, unigram);
                if (!(probability > 0.0)) continue;
                MapExtensionsKt.incrementCounter(unigramCounts, language);
            }
        }
        return unigramCounts;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Language, Double> sumUpProbabilities$lingua(@NotNull List<? extends Map<Language, Double>> probabilities, @NotNull Map<Language, Integer> unigramCountsOfInputText, @NotNull Set<? extends Language> filteredLanguages) {
        void $this$filterTo$iv$iv;
        Map $this$sumByDouble$iv;
        Intrinsics.checkNotNullParameter(probabilities, (String)"probabilities");
        Intrinsics.checkNotNullParameter(unigramCountsOfInputText, (String)"unigramCountsOfInputText");
        Intrinsics.checkNotNullParameter(filteredLanguages, (String)"filteredLanguages");
        boolean bl = false;
        HashMap summedUpProbabilities = new HashMap();
        for (Language language : filteredLanguages) {
            double d;
            Iterable iterable = probabilities;
            Language language2 = language;
            Map map2 = summedUpProbabilities;
            boolean $i$f$sumByDouble = false;
            double sum$iv = 0.0;
            Iterator iterator = $this$sumByDouble$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object element$iv = iterator.next();
                Map map3 = (Map)element$iv;
                d = sum$iv;
                boolean bl2 = false;
                Double d2 = (Double)it.get((Object)language);
                double d3 = d2 != null ? d2 : 0.0;
                sum$iv = d + d3;
            }
            d = sum$iv;
            map2.put(language2, d);
            if (!unigramCountsOfInputText.containsKey((Object)language)) continue;
            ((Map)summedUpProbabilities).put(language, ((Number)MapsKt.getValue((Map)summedUpProbabilities, (Object)((Object)language))).doubleValue() / ((Number)MapsKt.getValue(unigramCountsOfInputText, (Object)((Object)language))).doubleValue());
        }
        Map map2 = summedUpProbabilities;
        boolean $i$f$filter = false;
        $this$sumByDouble$iv = map2;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var10_25 = $this$filterTo$iv$iv;
        boolean bl3 = false;
        Iterator iterator = var10_25.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl4 = false;
            if (!(((Number)it.getValue()).doubleValue() != 0.0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Language detectLanguageWithRules$lingua(@NotNull List<String> words) {
        void mostFrequentLanguage;
        Map map2;
        int unknownLanguageCount;
        Map mostFrequentLanguage2;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(words, (String)"words");
        boolean bl = false;
        Map totalLanguageCounts = new LinkedHashMap();
        for (String word : words) {
            int secondCharCount;
            int n;
            Iterator $this$mapTo$iv$iv;
            boolean bl2 = false;
            Map wordLanguageCounts = new LinkedHashMap();
            CharSequence $this$map$iv = word;
            boolean $i$f$map2 = false;
            charSequence = $this$map$iv;
            Object destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            Map.Entry entry = $this$mapTo$iv$iv;
            for (n = 0; n < entry.length(); ++n) {
                void it;
                char item$iv$iv;
                char c = item$iv$iv = entry.charAt(n);
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                String string = String.valueOf((char)it);
                collection.add(string);
            }
            for (String character : (List)destination$iv$iv) {
                void $this$forEach$iv22;
                boolean isMatch = false;
                destination$iv$iv = this.alphabetsSupportingExactlyOneLanguage;
                $i$f$mapTo = false;
                $this$mapTo$iv$iv = destination$iv$iv.entrySet().iterator();
                while ($this$mapTo$iv$iv.hasNext()) {
                    void alphabet;
                    entry = $i$f$map2 = $this$mapTo$iv$iv.next();
                    n = 0;
                    destination$iv$iv = (Alphabet)((Object)entry.getKey());
                    entry = $i$f$map2;
                    n = 0;
                    Language language = (Language)((Object)entry.getValue());
                    if (!alphabet.matches(character)) continue;
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, language);
                    isMatch = true;
                }
                if (isMatch) continue;
                if (Alphabet.HAN.matches(character)) {
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, Language.CHINESE);
                    continue;
                }
                if (Constant.INSTANCE.getJAPANESE_CHARACTER_SET().matches((CharSequence)character)) {
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, Language.JAPANESE);
                    continue;
                }
                if (!Alphabet.LATIN.matches(character) && !Alphabet.CYRILLIC.matches(character) && !Alphabet.DEVANAGARI.matches(character)) continue;
                Sequence $i$f$map2 = SequencesKt.filter(this.languagesWithUniqueCharacters, (Function1)((Function1)new Function1<Language, Boolean>(character){
                    final /* synthetic */ String $character;

                    public final boolean invoke(@NotNull Language it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        String string = it.getUniqueCharacters$lingua();
                        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)this.$character, (boolean)false, (int)2, null) : false;
                    }
                    {
                        this.$character = string;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv22) {
                    Language it = (Language)((Object)element$iv);
                    boolean bl4 = false;
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, it);
                }
            }
            if (wordLanguageCounts.isEmpty()) {
                MapExtensionsKt.incrementCounter(totalLanguageCounts, Language.UNKNOWN);
                continue;
            }
            if (wordLanguageCounts.size() == 1) {
                Language language = (Language)((Object)((Pair)CollectionsKt.first((List)MapsKt.toList((Map)wordLanguageCounts))).getFirst());
                if (this.languages.contains((Object)language)) {
                    MapExtensionsKt.incrementCounter(totalLanguageCounts, language);
                    continue;
                }
                MapExtensionsKt.incrementCounter(totalLanguageCounts, Language.UNKNOWN);
                continue;
            }
            if (wordLanguageCounts.containsKey((Object)Language.CHINESE) && wordLanguageCounts.containsKey((Object)Language.JAPANESE)) {
                MapExtensionsKt.incrementCounter(totalLanguageCounts, Language.JAPANESE);
                continue;
            }
            Object $this$sortedByDescending$iv = MapsKt.toList((Map)wordLanguageCounts);
            boolean $i$f$sortedByDescending = false;
            boolean $this$forEach$iv22 = false;
            List sortedWordLanguageCounts = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Pair it = (Pair)b;
                    boolean bl2 = false;
                    Comparable comparable = (Integer)it.getSecond();
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = (Integer)it.getSecond();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            Pair $this$forEach$iv22 = (Pair)sortedWordLanguageCounts.get(0);
            $this$sortedByDescending$iv = (Language)((Object)$this$forEach$iv22.component1());
            int firstCharCount = ((Number)$this$forEach$iv22.component2()).intValue();
            if (firstCharCount > (secondCharCount = ((Number)(charSequence = (Pair)sortedWordLanguageCounts.get(1)).component2()).intValue()) && this.languages.contains(mostFrequentLanguage2)) {
                MapExtensionsKt.incrementCounter(totalLanguageCounts, mostFrequentLanguage2);
                continue;
            }
            MapExtensionsKt.incrementCounter(totalLanguageCounts, Language.UNKNOWN);
        }
        Integer n = (Integer)totalLanguageCounts.get((Object)Language.UNKNOWN);
        int n2 = unknownLanguageCount = n != null ? n : 0;
        if ((double)unknownLanguageCount >= 0.5 * (double)words.size()) {
            map2 = totalLanguageCounts;
        } else {
            void $this$filterNotTo$iv$iv;
            Map $this$filterNot$iv = totalLanguageCounts;
            boolean $i$f$filterNot = false;
            mostFrequentLanguage2 = $this$filterNot$iv;
            Map destination$iv$iv22 = new LinkedHashMap();
            boolean $i$f$filterNotTo = false;
            charSequence = $this$filterNotTo$iv$iv;
            boolean bl5 = false;
            Iterator iterator = charSequence.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl6 = false;
                if ((Language)((Object)it.getKey()) == Language.UNKNOWN) continue;
                destination$iv$iv22.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            map2 = destination$iv$iv22;
        }
        Map filteredLanguageCounts = map2;
        if (filteredLanguageCounts.isEmpty()) {
            return Language.UNKNOWN;
        }
        if (filteredLanguageCounts.size() == 1) {
            return (Language)((Object)((Pair)CollectionsKt.first((List)MapsKt.toList((Map)filteredLanguageCounts))).getFirst());
        }
        if (filteredLanguageCounts.size() == 2 && filteredLanguageCounts.containsKey((Object)Language.CHINESE) && filteredLanguageCounts.containsKey((Object)Language.JAPANESE)) {
            return Language.JAPANESE;
        }
        Object $this$sortedByDescending$iv = MapsKt.toList((Map)filteredLanguageCounts);
        boolean $i$f$sortedByDescending = false;
        boolean destination$iv$iv22 = false;
        List sortedTotalLanguageCounts = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)b;
                boolean bl2 = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = (Integer)it.getSecond();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        Pair destination$iv$iv22 = (Pair)sortedTotalLanguageCounts.get(0);
        $this$sortedByDescending$iv = (Language)((Object)destination$iv$iv22.component1());
        int firstCharCount = ((Number)destination$iv$iv22.component2()).intValue();
        Pair pair = (Pair)sortedTotalLanguageCounts.get(1);
        int secondCharCount = ((Number)pair.component2()).intValue();
        return firstCharCount == secondCharCount ? Language.UNKNOWN : mostFrequentLanguage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Language> filterLanguagesByRules$lingua(@NotNull List<String> words) {
        Set set;
        Map characters;
        Object it;
        Iterator<String> $this$filterTo$iv$iv;
        Object maxElem$iv;
        Object v0;
        Intrinsics.checkNotNullParameter(words, (String)"words");
        boolean bl = false;
        Map detectedAlphabets = new LinkedHashMap();
        block0: for (String word : words) {
            for (Alphabet alphabet : Alphabet.values()) {
                if (!alphabet.matches(word)) continue;
                MapExtensionsKt.incrementCounter(detectedAlphabets, alphabet);
                continue block0;
            }
        }
        if (detectedAlphabets.isEmpty()) {
            return this.languages;
        }
        Iterable $this$maxByOrNull$iv = detectedAlphabets.entrySet();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Map.Entry it2 = (Map.Entry)maxElem$iv;
                boolean bl2 = false;
                int maxValue$iv = ((Number)it2.getValue()).intValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Map.Entry it3 = (Map.Entry)e$iv;
                    $i$a$-maxByOrNull-LanguageDetector$filterLanguagesByRules$mostFrequentAlphabet$1 = false;
                    int v$iv = ((Number)it3.getValue()).intValue();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        Alphabet mostFrequentAlphabet = (Alphabet)((Object)((Map.Entry)v0).getKey());
        Iterable $this$filter$iv = this.languages;
        boolean $i$f$filter = false;
        maxElem$iv = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        Object v$iv = $this$filterTo$iv$iv.iterator();
        while (v$iv.hasNext()) {
            Object element$iv$iv = v$iv.next();
            it = (Language)((Object)element$iv$iv);
            boolean bl3 = false;
            if (!((Language)((Object)it)).getAlphabets$lingua().contains((Object)mostFrequentAlphabet)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredLanguages = (List)destination$iv$iv;
        $i$f$filter = false;
        Map languageCounts = new LinkedHashMap();
        block4: for (String word : words) {
            v$iv = Constant.INSTANCE.getCHARS_TO_LANGUAGES_MAPPING();
            boolean element$iv$iv = false;
            Iterator $i$f$filterTo2 = v$iv.entrySet().iterator();
            while ($i$f$filterTo2.hasNext()) {
                it = destination$iv$iv = $i$f$filterTo2.next();
                boolean bl3 = false;
                v$iv = (String)it.getKey();
                it = destination$iv$iv;
                bl3 = false;
                Set languages = (Set)it.getValue();
                if (!StringExtensionsKt.containsAnyOf(word, (String)((Object)characters))) continue;
                for (Language language : languages) {
                    MapExtensionsKt.incrementCounter(languageCounts, language);
                }
                continue block4;
            }
        }
        Object $this$filterValues$iv = languageCounts;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        characters = $this$filterValues$iv;
        boolean languages = false;
        for (Map.Entry entry$iv : characters.entrySet()) {
            int it4 = ((Number)entry$iv.getValue()).intValue();
            boolean bl4 = false;
            if (!((double)it4 >= (double)words.size() / 2.0)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set languagesSubset = ((Map)result$iv).keySet();
        $this$filterValues$iv = languagesSubset;
        $i$f$filterValues = false;
        if (!$this$filterValues$iv.isEmpty()) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = filteredLanguages;
            boolean $i$f$filter2 = false;
            result$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Map.Entry element$iv$iv : $this$filterTo$iv$iv2) {
                Language it5 = (Language)((Object)element$iv$iv);
                boolean bl5 = false;
                if (!languagesSubset.contains((Object)it5)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        } else {
            set = CollectionsKt.toSet((Iterable)filteredLanguages);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Language, Double> computeLanguageProbabilities$lingua(@NotNull TestDataLanguageModel testDataModel, @NotNull Set<? extends Language> filteredLanguages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)testDataModel, (String)"testDataModel");
        Intrinsics.checkNotNullParameter(filteredLanguages, (String)"filteredLanguages");
        boolean bl = false;
        HashMap probabilities = new HashMap();
        for (Language language : filteredLanguages) {
            ((Map)probabilities).put(language, this.computeSumOfNgramProbabilities$lingua(language, testDataModel.getNgrams()));
        }
        Map map2 = probabilities;
        boolean $i$f$filter = false;
        Map map22 = map2;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var9_12 = $this$filterTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = var9_12.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl3 = false;
            if (!(((Number)it.getValue()).doubleValue() < 0.0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final double computeSumOfNgramProbabilities$lingua(@NotNull Language language, @NotNull Set<Ngram> ngrams) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter(ngrams, (String)"ngrams");
        boolean bl = false;
        List probabilities = new ArrayList();
        block0: for (Ngram ngram : ngrams) {
            for (Ngram elem : ngram.rangeOfLowerOrderNgrams()) {
                double probability = this.lookUpNgramProbability$lingua(language, elem);
                if (!(probability > 0.0)) continue;
                probabilities.add(probability);
                continue block0;
            }
        }
        Iterable $this$sumByDouble$iv = probabilities;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        for (Object element$iv : $this$sumByDouble$iv) {
            void it;
            double d = ((Number)element$iv).doubleValue();
            double d2 = sum$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            double d3 = Math.log((double)it);
            sum$iv = d2 + d3;
        }
        return sum$iv;
    }

    public final double lookUpNgramProbability$lingua(@NotNull Language language, @NotNull Ngram ngram) {
        Map<Language, ? extends Lazy<TrainingDataLanguageModel>> map2;
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)ngram, (String)"ngram");
        switch (ngram.getValue().length()) {
            case 5: {
                map2 = fivegramLanguageModels;
                break;
            }
            case 4: {
                map2 = quadrigramLanguageModels;
                break;
            }
            case 3: {
                map2 = trigramLanguageModels;
                break;
            }
            case 2: {
                map2 = bigramLanguageModels;
                break;
            }
            case 1: {
                map2 = unigramLanguageModels;
                break;
            }
            case 0: {
                throw (Throwable)new IllegalArgumentException("Zerogram detected");
            }
            default: {
                throw (Throwable)new IllegalArgumentException("unsupported ngram length detected: " + ngram.getValue().length());
            }
        }
        Map<Language, ? extends Lazy<TrainingDataLanguageModel>> languageModels = map2;
        return ((TrainingDataLanguageModel)((Lazy)MapsKt.getValue(languageModels, (Object)((Object)language))).getValue()).getRelativeFrequency(ngram);
    }

    private final void preloadLanguageModels() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Deferred<? extends Unit>>>, Object>(this, null){
            private /* synthetic */ Object L$0;
            int label;
            final /* synthetic */ LanguageDetector this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        Iterable $this$map$iv = LanguageDetector.Companion.getLanguageModels$lingua();
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void models;
                            Map map2 = (Map)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Deferred deferred = BuildersKt.async$default((CoroutineScope)$this$runBlocking, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Map)models, null, this, $this$runBlocking){
                                int label;
                                final /* synthetic */ Map $models;
                                final /* synthetic */ preloadLanguageModels.1 this$0;
                                final /* synthetic */ CoroutineScope $this_runBlocking$inlined;
                                {
                                    this.$models = map2;
                                    this.this$0 = var3_3;
                                    this.$this_runBlocking$inlined = coroutineScope;
                                    super(2, continuation);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Iterable $this$forEach$iv = this.this$0.this$0.getLanguages$lingua();
                                            boolean $i$f$forEach = false;
                                            for (T element$iv : $this$forEach$iv) {
                                                Language language = (Language)((Object)element$iv);
                                                boolean bl = false;
                                                Lazy lazy = (Lazy)this.$models.get((Object)((Object)language));
                                                if (lazy == null) continue;
                                                TrainingDataLanguageModel cfr_ignored_0 = (TrainingDataLanguageModel)lazy.getValue();
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            collection.add(deferred);
                        }
                        return (List)destination$iv$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = languageDetector;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super List<? extends Deferred<? extends Unit>>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof LanguageDetector) ? false : (Intrinsics.areEqual(this.languages, ((LanguageDetector)other).languages) ^ true ? false : this.minimumRelativeDistance == ((LanguageDetector)other).minimumRelativeDistance));
    }

    public int hashCode() {
        return 31 * ((Object)this.languages).hashCode() + ((Object)this.minimumRelativeDistance).hashCode();
    }

    @NotNull
    public final Set<Language> getLanguages$lingua() {
        return this.languages;
    }

    public final double getMinimumRelativeDistance$lingua() {
        return this.minimumRelativeDistance;
    }

    public final int getNumberOfLoadedLanguages$lingua() {
        return this.numberOfLoadedLanguages;
    }

    /*
     * WARNING - void declaration
     */
    public LanguageDetector(@NotNull Set<Language> languages, double minimumRelativeDistance, boolean isEveryLanguageModelPreloaded, int numberOfLoadedLanguages) {
        void $this$filterValues$iv;
        Language it;
        void $this$filterNotTo$iv$iv;
        Map<Alphabet, Language> $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        this.languages = languages;
        this.minimumRelativeDistance = minimumRelativeDistance;
        this.numberOfLoadedLanguages = numberOfLoadedLanguages;
        Iterable iterable = this.languages;
        LanguageDetector languageDetector = this;
        boolean $i$f$filterNot = false;
        void var8_8 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object t : $this$filterNotTo$iv$iv) {
            it = (Language)((Object)t);
            boolean bl = false;
            CharSequence charSequence = it.getUniqueCharacters$lingua();
            boolean bl2 = false;
            boolean bl3 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            destination$iv$iv.add(t);
        }
        Object object = (List)destination$iv$iv;
        languageDetector.languagesWithUniqueCharacters = CollectionsKt.asSequence((Iterable)((Iterable)object));
        $this$filterNot$iv = Alphabet.Companion.allSupportingExactlyOneLanguage();
        languageDetector = this;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        void var9_9 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry : var9_9.entrySet()) {
            it = (Language)((Object)entry.getValue());
            boolean bl4 = false;
            if (!this.languages.contains((Object)it)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        languageDetector.alphabetsSupportingExactlyOneLanguage = object = (Map)result$iv;
        if (isEveryLanguageModelPreloaded) {
            this.preloadLanguageModels();
        }
    }

    public /* synthetic */ LanguageDetector(Set set, double d, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = set.size();
        }
        this(set, d, bl, n);
    }

    static {
        Companion = new Companion(null);
        unigramLanguageModels = LanguageDetector.Companion.loadLanguageModels(1);
        bigramLanguageModels = LanguageDetector.Companion.loadLanguageModels(2);
        trigramLanguageModels = LanguageDetector.Companion.loadLanguageModels(3);
        quadrigramLanguageModels = LanguageDetector.Companion.loadLanguageModels(4);
        fivegramLanguageModels = LanguageDetector.Companion.loadLanguageModels(5);
        languageModels = CollectionsKt.listOf((Object[])new Map[]{unigramLanguageModels, bigramLanguageModels, trigramLanguageModels, quadrigramLanguageModels, fivegramLanguageModels});
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R,\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR,\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR,\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00040\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R,\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\t\"\u0004\b\u0015\u0010\u000bR,\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\t\"\u0004\b\u0018\u0010\u000bR,\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\t\"\u0004\b\u001b\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/github/pemistahl/lingua/api/LanguageDetector$Companion;", "", "()V", "bigramLanguageModels", "", "Lcom/github/pemistahl/lingua/api/Language;", "Lkotlin/Lazy;", "Lcom/github/pemistahl/lingua/internal/TrainingDataLanguageModel;", "getBigramLanguageModels$lingua", "()Ljava/util/Map;", "setBigramLanguageModels$lingua", "(Ljava/util/Map;)V", "fivegramLanguageModels", "getFivegramLanguageModels$lingua", "setFivegramLanguageModels$lingua", "languageModels", "", "getLanguageModels$lingua", "()Ljava/util/List;", "quadrigramLanguageModels", "getQuadrigramLanguageModels$lingua", "setQuadrigramLanguageModels$lingua", "trigramLanguageModels", "getTrigramLanguageModels$lingua", "setTrigramLanguageModels$lingua", "unigramLanguageModels", "getUnigramLanguageModels$lingua", "setUnigramLanguageModels$lingua", "loadLanguageModel", "language", "ngramLength", "", "loadLanguageModels", "lingua"})
    public static final class Companion {
        @NotNull
        public final Map<Language, Lazy<TrainingDataLanguageModel>> getUnigramLanguageModels$lingua() {
            return unigramLanguageModels;
        }

        public final void setUnigramLanguageModels$lingua(@NotNull Map<Language, ? extends Lazy<TrainingDataLanguageModel>> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            unigramLanguageModels = map2;
        }

        @NotNull
        public final Map<Language, Lazy<TrainingDataLanguageModel>> getBigramLanguageModels$lingua() {
            return bigramLanguageModels;
        }

        public final void setBigramLanguageModels$lingua(@NotNull Map<Language, ? extends Lazy<TrainingDataLanguageModel>> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            bigramLanguageModels = map2;
        }

        @NotNull
        public final Map<Language, Lazy<TrainingDataLanguageModel>> getTrigramLanguageModels$lingua() {
            return trigramLanguageModels;
        }

        public final void setTrigramLanguageModels$lingua(@NotNull Map<Language, ? extends Lazy<TrainingDataLanguageModel>> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            trigramLanguageModels = map2;
        }

        @NotNull
        public final Map<Language, Lazy<TrainingDataLanguageModel>> getQuadrigramLanguageModels$lingua() {
            return quadrigramLanguageModels;
        }

        public final void setQuadrigramLanguageModels$lingua(@NotNull Map<Language, ? extends Lazy<TrainingDataLanguageModel>> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            quadrigramLanguageModels = map2;
        }

        @NotNull
        public final Map<Language, Lazy<TrainingDataLanguageModel>> getFivegramLanguageModels$lingua() {
            return fivegramLanguageModels;
        }

        public final void setFivegramLanguageModels$lingua(@NotNull Map<Language, ? extends Lazy<TrainingDataLanguageModel>> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            fivegramLanguageModels = map2;
        }

        @NotNull
        public final List<Map<Language, Lazy<TrainingDataLanguageModel>>> getLanguageModels$lingua() {
            return languageModels;
        }

        private final Map<Language, Lazy<TrainingDataLanguageModel>> loadLanguageModels(int ngramLength) {
            boolean bl = false;
            HashMap languageModels = new HashMap();
            for (Language language : Language.Companion.all()) {
                ((Map)languageModels).put(language, LazyKt.lazy((Function0)((Function0)new Function0<TrainingDataLanguageModel>(language, ngramLength){
                    final /* synthetic */ Language $language;
                    final /* synthetic */ int $ngramLength;

                    @NotNull
                    public final TrainingDataLanguageModel invoke() {
                        return com.github.pemistahl.lingua.api.LanguageDetector$Companion.access$loadLanguageModel(LanguageDetector.Companion, this.$language, this.$ngramLength);
                    }
                    {
                        this.$language = language;
                        this.$ngramLength = n;
                        super(0);
                    }
                })));
            }
            return languageModels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final TrainingDataLanguageModel loadLanguageModel(Language language, int ngramLength) {
            InputStream inputStream;
            String fileName = Ngram.Companion.getNgramNameByLength(ngramLength) + "s.json";
            String filePath = "/language-models/" + (Object)((Object)language.getIsoCode639_1()) + '/' + fileName;
            InputStream inputStream2 = inputStream = Language.class.getResourceAsStream(filePath);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"inputStream");
            Closeable closeable = inputStream2;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object = closeable;
            int n = 0;
            object = new InputStreamReader((InputStream)object, charset);
            n = 8192;
            boolean bl2 = false;
            closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
            boolean bl3 = false;
            bl = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl4 = false;
                object = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object jsonContent = object;
            return TrainingDataLanguageModel.Companion.fromJson((String)jsonContent);
        }

        private Companion() {
        }

        public static final /* synthetic */ TrainingDataLanguageModel access$loadLanguageModel(Companion $this, Language language, int ngramLength) {
            return $this.loadLanguageModel(language, ngramLength);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

