/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TransformationsUtil;
import lombok.javac.JavacAST;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.JavacResolution;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleConstructor {
    private void handle(JavacNode annotationNode, Class<? extends Annotation> annotationType, ConstructorData data) {
        boolean notAClass;
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, annotationType);
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
        JavacNode typeNode = (JavacNode)annotationNode.up();
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x2200L) != 0L;
        if (typeDecl == null || notAClass) {
            annotationNode.addError(String.format("%s is only supported on a class or an enum.", annotationType.getSimpleName()));
            return;
        }
        if (data.accessLevel == AccessLevel.NONE) {
            return;
        }
        this.generateConstructor(typeNode, (JCTree)annotationNode.get(), data);
    }

    public static boolean constructorOrConstructorAnnotationExists(JavacNode typeNode) {
        boolean constructorExists;
        boolean bl = constructorExists = JavacHandlerUtil.constructorExists(typeNode) == JavacHandlerUtil.MemberExistsResult.EXISTS_BY_USER;
        if (!constructorExists) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.ANNOTATION || !JavacHandlerUtil.annotationTypeMatches(NoArgsConstructor.class, child) && !JavacHandlerUtil.annotationTypeMatches(AllArgsConstructor.class, child) && !JavacHandlerUtil.annotationTypeMatches(RequiredArgsConstructor.class, child)) continue;
                constructorExists = true;
                break;
            }
        }
        return constructorExists;
    }

    public void generateConstructor(JavacNode typeNode, JCTree source, ConstructorData data) {
        List<SuperConstructor> superConstructors = data.callSuper ? this.getSuperConstructors(typeNode) : List.of(SuperConstructor.implicit());
        for (SuperConstructor superConstructor : superConstructors) {
            JCTree.JCMethodDecl constr = this.createConstructor(typeNode, source, data, superConstructor);
            JavacHandlerUtil.injectMethod(typeNode, constr);
            if (data.staticConstructorRequired()) {
                JCTree.JCMethodDecl staticConstr = this.createStaticConstructor(typeNode, source, data, superConstructor);
                JavacHandlerUtil.injectMethod(typeNode, staticConstr);
            }
            typeNode.rebuild();
        }
    }

    private void addConstructorProperties(JCTree.JCModifiers mods, JavacNode node, List<JCTree.JCVariableDecl> params) {
        if (params.isEmpty()) {
            return;
        }
        TreeMaker maker = node.getTreeMaker();
        JCTree.JCExpression constructorPropertiesType = JavacHandlerUtil.chainDotsString(node, "java.beans.ConstructorProperties");
        ListBuffer fieldNames = ListBuffer.lb();
        for (JCTree.JCVariableDecl param : params) {
            fieldNames.append(maker.Literal(param.name.toString()));
        }
        JCTree.JCNewArray fieldNamesArray = maker.NewArray(null, List.<JCTree.JCExpression>nil(), fieldNames.toList());
        JCTree.JCAnnotation annotation = maker.Annotation(constructorPropertiesType, List.of(fieldNamesArray));
        mods.annotations = mods.annotations.append(annotation);
    }

    private JCTree.JCMethodDecl createConstructor(JavacNode typeNode, JCTree source, ConstructorData data, SuperConstructor superConstructor) {
        TreeMaker maker = typeNode.getTreeMaker();
        boolean isEnum = (((JCTree.JCClassDecl)typeNode.get()).mods.flags & 0x4000L) != 0L;
        AccessLevel level = isEnum | data.staticConstructorRequired() ? AccessLevel.PRIVATE : data.accessLevel;
        ListBuffer statements = ListBuffer.lb();
        ListBuffer assigns = ListBuffer.lb();
        ListBuffer params = ListBuffer.lb();
        if (!superConstructor.isImplicit) {
            params.appendList(superConstructor.params);
            statements.append(maker.Exec(maker.Apply(List.<JCTree.JCExpression>nil(), maker.Ident(typeNode.toName("super")), superConstructor.getArgs(typeNode))));
        }
        List<JavacNode> fields = data.fieldProvider.findFields(typeNode);
        for (JavacNode fieldNode : fields) {
            JCTree.JCStatement nullCheck;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NULLABLE_PATTERN);
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(16L, nonNulls.appendList(nullables)), field.name, field.vartype, null);
            params.append(param);
            JCTree.JCFieldAccess thisX = maker.Select((JCTree.JCExpression)maker.Ident(fieldNode.toName("this")), field.name);
            JCTree.JCAssign assign = maker.Assign(thisX, maker.Ident(field.name));
            assigns.append(maker.Exec(assign));
            if (nonNulls.isEmpty() || (nullCheck = JavacHandlerUtil.generateNullCheck(maker, fieldNode)) == null) continue;
            statements.append(nullCheck);
        }
        JCTree.JCModifiers mods = maker.Modifiers(JavacHandlerUtil.toJavacModifier(level), List.<JCTree.JCAnnotation>nil());
        if (!data.suppressConstructorProperties && level != AccessLevel.PRIVATE && !this.isLocalType(typeNode)) {
            this.addConstructorProperties(mods, typeNode, params.toList());
        }
        JCTree.JCBlock body = maker.Block(0L, statements.appendList(assigns).toList());
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName("<init>"), null, List.<JCTree.JCTypeParameter>nil(), params.toList(), List.<JCTree.JCExpression>nil(), body, null), source);
    }

    private boolean isLocalType(JavacNode type) {
        JavacNode typeNode;
        for (typeNode = (JavacNode)type.up(); typeNode != null && !(typeNode.get() instanceof JCTree.JCClassDecl); typeNode = (JavacNode)typeNode.up()) {
        }
        return typeNode != null;
    }

    private JCTree.JCMethodDecl createStaticConstructor(JavacNode typeNode, JCTree source, ConstructorData data, SuperConstructor superConstructor) {
        JCTree.JCExpression constructorType;
        JCTree.JCExpression returnType;
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        JCTree.JCModifiers mods = maker.Modifiers(8 | JavacHandlerUtil.toJavacModifier(data.accessLevel));
        ListBuffer typeParams = ListBuffer.lb();
        ListBuffer params = ListBuffer.lb();
        ListBuffer typeArgs1 = ListBuffer.lb();
        ListBuffer typeArgs2 = ListBuffer.lb();
        ListBuffer args = ListBuffer.lb();
        if (!superConstructor.isImplicit) {
            params.appendList(superConstructor.params);
            args.appendList(superConstructor.getArgs(typeNode));
        }
        if (!type.typarams.isEmpty()) {
            for (JCTree.JCTypeParameter param : type.typarams) {
                typeArgs1.append(maker.Ident(param.name));
                typeArgs2.append(maker.Ident(param.name));
                typeParams.append(maker.TypeParameter(param.name, param.bounds));
            }
            returnType = maker.TypeApply(maker.Ident(type.name), typeArgs1.toList());
            constructorType = maker.TypeApply(maker.Ident(type.name), typeArgs2.toList());
        } else {
            returnType = maker.Ident(type.name);
            constructorType = maker.Ident(type.name);
        }
        List<JavacNode> fields = data.fieldProvider.findFields(typeNode);
        for (JavacNode fieldNode : fields) {
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            JCTree.JCExpression pType = JavacHandlerUtil.cloneType(maker, field.vartype, source);
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NULLABLE_PATTERN);
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(16L, nonNulls.appendList(nullables)), field.name, pType, null);
            params.append(param);
            args.append(maker.Ident(field.name));
        }
        JCTree.JCReturn returnStatement = maker.Return(maker.NewClass(null, List.<JCTree.JCExpression>nil(), constructorType, args.toList(), null));
        JCTree.JCBlock body = maker.Block(0L, List.of(returnStatement));
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName(data.staticName), returnType, typeParams.toList(), params.toList(), List.<JCTree.JCExpression>nil(), body, null), source);
    }

    public List<SuperConstructor> getSuperConstructors(JavacNode typeNode) {
        ListBuffer superConstructors = ListBuffer.lb();
        JCTree.JCClassDecl typeDecl = (JCTree.JCClassDecl)typeNode.get();
        if (typeDecl.extending != null) {
            Type type = typeDecl.extending.type;
            if (type == null) {
                try {
                    JCTree.JCExpression resolvedExpression = (JCTree.JCExpression)new JavacResolution(typeNode.getContext()).resolveMethodMember(typeNode).get(typeDecl.extending);
                    if (resolvedExpression != null) {
                        type = resolvedExpression.type;
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            TreeMaker maker = typeNode.getTreeMaker();
            Symbol.TypeSymbol typeSymbol = type.asElement();
            if (typeSymbol != null) {
                for (Symbol member : typeSymbol.getEnclosedElements()) {
                    if (member.getKind() != ElementKind.CONSTRUCTOR || !member.getModifiers().contains((Object)Modifier.PUBLIC) && !member.getModifiers().contains((Object)Modifier.PROTECTED)) continue;
                    try {
                        Symbol.MethodSymbol superConstructor = (Symbol.MethodSymbol)member;
                        Type.MethodType superConstructorType = superConstructor.type.asMethodType();
                        ListBuffer params = ListBuffer.lb();
                        int argCounter = 0;
                        if (superConstructorType.argtypes != null) {
                            for (Type argtype : superConstructorType.argtypes) {
                                JCTree.JCModifiers paramMods = maker.Modifiers(16L);
                                Name name = typeNode.toName("arg" + argCounter++);
                                JCTree.JCExpression varType = JavacResolution.typeToJCTree(argtype, (JavacAST)typeNode.getAst(), true);
                                JCTree.JCVariableDecl varDef = maker.VarDef(paramMods, name, varType, null);
                                params.append(varDef);
                            }
                        }
                        superConstructors.append(new SuperConstructor(params.toList()));
                    }
                    catch (JavacResolution.TypeNotConvertibleException e) {
                        typeNode.addError("Can't create super constructor call: " + e.getMessage());
                    }
                }
            }
        }
        if (superConstructors.isEmpty()) {
            superConstructors.append(SuperConstructor.implicit());
        }
        return superConstructors.toList();
    }

    public static enum FieldProvider {
        REQUIRED{

            @Override
            public List<JavacNode> findFields(JavacNode typeNode) {
                ListBuffer fields = ListBuffer.lb();
                for (JavacNode child : typeNode.down()) {
                    boolean isNonNull;
                    JCTree.JCVariableDecl fieldDecl;
                    if (child.getKind() != AST.Kind.FIELD || !JavacHandlerUtil.filterField(fieldDecl = (JCTree.JCVariableDecl)child.get())) continue;
                    boolean isFinal = (fieldDecl.mods.flags & 0x10L) != 0L;
                    boolean bl = isNonNull = !JavacHandlerUtil.findAnnotations(child, TransformationsUtil.NON_NULL_PATTERN).isEmpty();
                    if (!isFinal && !isNonNull || fieldDecl.init != null) continue;
                    fields.append(child);
                }
                return fields.toList();
            }
        }
        ,
        ALL{

            @Override
            public List<JavacNode> findFields(JavacNode typeNode) {
                ListBuffer fields = ListBuffer.lb();
                for (JavacNode child : typeNode.down()) {
                    boolean isFinal;
                    JCTree.JCVariableDecl fieldDecl;
                    if (child.getKind() != AST.Kind.FIELD || !JavacHandlerUtil.filterField(fieldDecl = (JCTree.JCVariableDecl)child.get())) continue;
                    boolean bl = isFinal = (fieldDecl.mods.flags & 0x10L) != 0L;
                    if (isFinal && fieldDecl.init != null) continue;
                    fields.append(child);
                }
                return fields.toList();
            }
        }
        ,
        NO{

            @Override
            public List<JavacNode> findFields(JavacNode typeNode) {
                return List.nil();
            }
        };


        public abstract List<JavacNode> findFields(JavacNode var1);
    }

    public static class SuperConstructor {
        final List<JCTree.JCVariableDecl> params;
        boolean isImplicit;

        static SuperConstructor implicit() {
            SuperConstructor superConstructor = new SuperConstructor(List.<JCTree.JCVariableDecl>nil());
            superConstructor.isImplicit = true;
            return superConstructor;
        }

        SuperConstructor(List<JCTree.JCVariableDecl> params) {
            this.params = params;
        }

        public List<JCTree.JCExpression> getArgs(JavacNode typeNode) {
            TreeMaker maker = typeNode.getTreeMaker();
            ListBuffer args = ListBuffer.lb();
            for (JCTree.JCVariableDecl param : this.params) {
                args.append(maker.Ident(param.name));
            }
            return args.toList();
        }
    }

    public static class ConstructorData {
        FieldProvider fieldProvider;
        AccessLevel accessLevel;
        String staticName;
        boolean callSuper;
        boolean suppressConstructorProperties;

        public ConstructorData fieldProvider(FieldProvider provider) {
            this.fieldProvider = provider;
            return this;
        }

        public ConstructorData accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public ConstructorData staticName(String name) {
            this.staticName = name;
            return this;
        }

        public ConstructorData callSuper(boolean b) {
            this.callSuper = b;
            return this;
        }

        public ConstructorData suppressConstructorProperties(boolean b) {
            this.suppressConstructorProperties = b;
            return this;
        }

        public boolean staticConstructorRequired() {
            return this.staticName != null && !this.staticName.equals("");
        }
    }

    public static class HandleAllArgsConstructor
    extends JavacAnnotationHandler<AllArgsConstructor> {
        @Override
        public void handle(AnnotationValues<AllArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            AllArgsConstructor instance = annotation.getInstance();
            ConstructorData data = new ConstructorData().fieldProvider(FieldProvider.ALL).accessLevel(instance.access()).staticName(instance.staticName()).callSuper(instance.callSuper()).suppressConstructorProperties(instance.suppressConstructorProperties());
            new HandleConstructor().handle(annotationNode, AllArgsConstructor.class, data);
        }
    }

    public static class HandleRequiredArgsConstructor
    extends JavacAnnotationHandler<RequiredArgsConstructor> {
        @Override
        public void handle(AnnotationValues<RequiredArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            RequiredArgsConstructor instance = annotation.getInstance();
            ConstructorData data = new ConstructorData().fieldProvider(FieldProvider.REQUIRED).accessLevel(instance.access()).staticName(instance.staticName()).callSuper(instance.callSuper()).suppressConstructorProperties(instance.suppressConstructorProperties());
            new HandleConstructor().handle(annotationNode, RequiredArgsConstructor.class, data);
        }
    }

    public static class HandleNoArgsConstructor
    extends JavacAnnotationHandler<NoArgsConstructor> {
        @Override
        public void handle(AnnotationValues<NoArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            NoArgsConstructor instance = annotation.getInstance();
            ConstructorData data = new ConstructorData().fieldProvider(FieldProvider.NO).accessLevel(instance.access()).staticName(instance.staticName()).callSuper(instance.callSuper());
            new HandleConstructor().handle(annotationNode, NoArgsConstructor.class, data);
        }
    }
}

