/*
 * Decompiled with CFR 0.152.
 */
package lombok.core.handlers;

import java.beans.ConstructorProperties;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.AccessLevel;
import lombok.BoundSetter;
import lombok.ast.AST;
import lombok.ast.Annotation;
import lombok.ast.Argument;
import lombok.ast.FieldDecl;
import lombok.ast.IField;
import lombok.ast.IType;
import lombok.ast.LocalDecl;
import lombok.ast.MethodDecl;
import lombok.ast.TypeRef;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.LombokNode;
import lombok.core.TransformationsUtil;
import lombok.core.util.As;
import lombok.core.util.ErrorMessages;
import lombok.core.util.Names;
import lombok.experimental.Accessors;

public abstract class BoundSetterHandler<TYPE_TYPE extends IType<?, FIELD_TYPE, ?, ?, ?, ?>, FIELD_TYPE extends IField<?, ?, ?>, LOMBOK_NODE_TYPE extends LombokNode<?, LOMBOK_NODE_TYPE, ?>, SOURCE_TYPE> {
    private static final String PROPERTY_CHANGE_SUPPORT_FIELD_NAME = "$propertyChangeSupport";
    private static final String VETOABLE_CHANGE_SUPPORT_FIELD_NAME = "$vetoableChangeSupport";
    private static final String PROPERTY_CHANGE_SUPPORT_METHOD_NAME = "getPropertyChangeSupport";
    private static final String VETOABLE_CHANGE_SUPPORT_METHOD_NAME = "getVetoableChangeSupport";
    private static final String LISTENER_ARG_NAME = "listener";
    private static final String PROPERTY_NAME_ARG_NAME = "propertyName";
    private static final String OLD_VALUE_ARG_NAME = "oldValue";
    private static final String NEW_VALUE_ARG_NAME = "newValue";
    private static final String[] PROPERTY_CHANGE_METHOD_NAMES = As.array("addPropertyChangeListener", "removePropertyChangeListener");
    private static final String[] VETOABLE_CHANGE_METHOD_NAMES = As.array("addVetoableChangeListener", "removeVetoableChangeListener");
    private static final String FIRE_PROPERTY_CHANGE_METHOD_NAME = "firePropertyChange";
    private static final String FIRE_VETOABLE_CHANGE_METHOD_NAME = "fireVetoableChange";
    private static final String OLD_VALUE_VARIABLE_NAME = "$old";
    private static final String E_VALUE_VARIABLE_NAME = "$e";
    private static final Pattern SETTER_PATTERN = Pattern.compile("^(?:setter|fluentsetter|boundsetter)$", 2);
    private final LOMBOK_NODE_TYPE annotationNode;
    private final SOURCE_TYPE ast;

    public void handle(AccessLevel level, boolean vetoable, boolean throwVetoException) {
        Object mayBeField = ((LombokNode)this.annotationNode).up();
        if (mayBeField == null) {
            return;
        }
        TYPE_TYPE type = this.typeOf(this.annotationNode, this.ast);
        ArrayList<Object> fields = new ArrayList<Object>();
        if (((LombokNode)mayBeField).getKind() == AST.Kind.FIELD) {
            for (LombokNode node : ((LombokNode)this.annotationNode).upFromAnnotationToFields()) {
                fields.add(this.fieldOf(node, this.ast));
            }
        } else if (((LombokNode)mayBeField).getKind() == AST.Kind.TYPE) {
            for (IField field : type.fields()) {
                if (!field.annotations(SETTER_PATTERN).isEmpty() || field.name().startsWith("$") || field.isFinal() || field.isStatic()) continue;
                fields.add(field);
            }
        } else {
            this.annotationNode.addError(ErrorMessages.canBeUsedOnClassAndFieldOnly(BoundSetter.class));
            return;
        }
        this.generateSetter(type, fields, level, vetoable | throwVetoException, throwVetoException);
    }

    protected abstract TYPE_TYPE typeOf(LOMBOK_NODE_TYPE var1, SOURCE_TYPE var2);

    protected abstract FIELD_TYPE fieldOf(LOMBOK_NODE_TYPE var1, SOURCE_TYPE var2);

    private void generateSetter(TYPE_TYPE type, List<FIELD_TYPE> fields, AccessLevel level, boolean vetoable, boolean throwVetoException) {
        if (!fields.isEmpty()) {
            if (!this.hasAllPropertyChangeMethods(type)) {
                this.generatePropertyChangeSupportFields(type);
                this.generateGetPropertySupportMethod(type);
                this.generatePropertyChangeListenerMethods(type);
                this.generateFirePropertyChangeMethod(type);
            }
            if (vetoable && !this.hasAllVetoableChangeMethods(type)) {
                this.generateVetoableChangeSupportFields(type);
                this.generateGetVetoableSupportMethod(type);
                this.generateVetoableChangeListenerMethods(type);
                this.generateFireVetoableChangeMethod(type);
            }
        }
        for (IField field : fields) {
            String propertyNameFieldName = "PROP_" + Names.camelCaseToConstant(field.name());
            this.generatePropertyNameConstant(type, field, propertyNameFieldName);
            this.generateSetter(type, field, level, vetoable, throwVetoException, propertyNameFieldName);
        }
    }

    private boolean hasAllPropertyChangeMethods(TYPE_TYPE type) {
        for (String methodName : PROPERTY_CHANGE_METHOD_NAMES) {
            if (type.hasMethodIncludingSupertypes(methodName, AST.Type(PropertyChangeListener.class))) continue;
            return false;
        }
        return type.hasMethodIncludingSupertypes(FIRE_PROPERTY_CHANGE_METHOD_NAME, AST.Type(String.class), AST.Type(Object.class), AST.Type(Object.class));
    }

    private boolean hasAllVetoableChangeMethods(TYPE_TYPE type) {
        for (String methodName : VETOABLE_CHANGE_METHOD_NAMES) {
            if (type.hasMethodIncludingSupertypes(methodName, AST.Type(VetoableChangeListener.class))) continue;
            return false;
        }
        return type.hasMethodIncludingSupertypes(FIRE_VETOABLE_CHANGE_METHOD_NAME, AST.Type(String.class), AST.Type(Object.class), AST.Type(Object.class));
    }

    private void generatePropertyNameConstant(TYPE_TYPE type, FIELD_TYPE field, String propertyNameFieldName) {
        String propertyName = field.name();
        if (type.hasField(propertyNameFieldName)) {
            return;
        }
        type.editor().injectField(((FieldDecl)AST.FieldDecl(AST.Type(String.class), propertyNameFieldName).makePublic().makeStatic().makeFinal()).withInitialization(AST.String(propertyName)));
    }

    private void generateSetter(TYPE_TYPE type, FIELD_TYPE field, AccessLevel level, boolean vetoable, boolean throwVetoException, String propertyNameFieldName) {
        String fieldName = field.name();
        boolean isBoolean = field.isOfType("boolean");
        AnnotationValues<Accessors> accessors = AnnotationValues.of(Accessors.class, field.node());
        String setterName = TransformationsUtil.toSetterName(accessors, fieldName, isBoolean);
        if (type.hasMethod(setterName, field.type())) {
            return;
        }
        String oldValueName = OLD_VALUE_VARIABLE_NAME;
        List<Annotation> nonNulls = field.annotations(TransformationsUtil.NON_NULL_PATTERN);
        MethodDecl methodDecl = (MethodDecl)((MethodDecl)AST.MethodDecl(AST.Type("void"), setterName).withAccessLevel(level)).withArgument((Argument)AST.Arg(field.type(), fieldName).withAnnotations(nonNulls));
        if (!nonNulls.isEmpty() && !field.isPrimitive()) {
            methodDecl.withStatement(AST.If(AST.Equal(AST.Name(fieldName), AST.Null())).Then(AST.Throw(AST.New(AST.Type(NullPointerException.class)).withArgument(AST.String(fieldName)))));
        }
        methodDecl.withStatement(((LocalDecl)AST.LocalDecl(field.type(), oldValueName).makeFinal()).withInitialization(AST.Field(fieldName)));
        if (vetoable) {
            if (throwVetoException) {
                methodDecl.withThrownException(AST.Type(PropertyVetoException.class));
                methodDecl.withStatement(AST.Call(FIRE_VETOABLE_CHANGE_METHOD_NAME).withArgument(AST.Name(propertyNameFieldName)).withArgument(AST.Name(oldValueName)).withArgument(AST.Name(fieldName)));
            } else {
                methodDecl.withStatement(AST.Try(AST.Block().withStatement(AST.Call(FIRE_VETOABLE_CHANGE_METHOD_NAME).withArgument(AST.Name(propertyNameFieldName)).withArgument(AST.Name(oldValueName)).withArgument(AST.Name(fieldName)))).Catch(AST.Arg(AST.Type(PropertyVetoException.class), E_VALUE_VARIABLE_NAME), AST.Block().withStatement(AST.Return())));
            }
        }
        ((MethodDecl)methodDecl.withStatement(AST.Assign(AST.Field(fieldName), AST.Name(fieldName)))).withStatement(AST.Call(FIRE_PROPERTY_CHANGE_METHOD_NAME).withArgument(AST.Name(propertyNameFieldName)).withArgument(AST.Name(oldValueName)).withArgument(AST.Name(fieldName)));
        type.editor().injectMethod(methodDecl);
    }

    private void generatePropertyChangeSupportFields(TYPE_TYPE type) {
        if (!type.hasField(PROPERTY_CHANGE_SUPPORT_FIELD_NAME)) {
            type.editor().injectField(AST.FieldDecl(AST.Type(PropertyChangeSupport.class), PROPERTY_CHANGE_SUPPORT_FIELD_NAME).makePrivate().makeTransient().makeVolatile());
        }
        if (!type.hasField("$propertyChangeSupportLock")) {
            type.editor().injectField(((FieldDecl)AST.FieldDecl(AST.Type(Object.class).withDimensions(1), "$propertyChangeSupportLock").makePrivate().makeFinal()).withInitialization(AST.NewArray(AST.Type(Object.class)).withDimensionExpression(AST.Number(0))));
        }
    }

    private void generateGetPropertySupportMethod(TYPE_TYPE type) {
        if (type.hasMethod(PROPERTY_CHANGE_SUPPORT_METHOD_NAME, new TypeRef[0])) {
            return;
        }
        type.editor().injectMethod((MethodDecl)((MethodDecl)((MethodDecl)AST.MethodDecl(AST.Type(PropertyChangeSupport.class), PROPERTY_CHANGE_SUPPORT_METHOD_NAME).makePrivate()).withStatement(AST.If(AST.Equal(AST.Field(PROPERTY_CHANGE_SUPPORT_FIELD_NAME), AST.Null())).Then(AST.Block().withStatement(AST.Synchronized(AST.Field("$propertyChangeSupportLock")).withStatement(AST.If(AST.Equal(AST.Field(PROPERTY_CHANGE_SUPPORT_FIELD_NAME), AST.Null())).Then(AST.Block().withStatement(AST.Assign(AST.Field(PROPERTY_CHANGE_SUPPORT_FIELD_NAME), AST.New(AST.Type(PropertyChangeSupport.class)).withArgument(AST.This()))))))))).withStatement(AST.Return(AST.Field(PROPERTY_CHANGE_SUPPORT_FIELD_NAME))));
    }

    private void generatePropertyChangeListenerMethods(TYPE_TYPE type) {
        for (String methodName : PROPERTY_CHANGE_METHOD_NAMES) {
            this.generatePropertyChangeListenerMethod(methodName, type);
        }
    }

    private void generatePropertyChangeListenerMethod(String methodName, TYPE_TYPE type) {
        if (type.hasMethod(methodName, AST.Type(PropertyChangeListener.class))) {
            return;
        }
        type.editor().injectMethod((MethodDecl)((MethodDecl)((MethodDecl)AST.MethodDecl(AST.Type("void"), methodName).makePublic()).withArgument(AST.Arg(AST.Type(PropertyChangeListener.class), LISTENER_ARG_NAME))).withStatement(AST.Call(AST.Call(PROPERTY_CHANGE_SUPPORT_METHOD_NAME), methodName).withArgument(AST.Name(LISTENER_ARG_NAME))));
    }

    private void generateFirePropertyChangeMethod(TYPE_TYPE type) {
        if (type.hasMethod(FIRE_PROPERTY_CHANGE_METHOD_NAME, AST.Type(String.class), AST.Type(Object.class), AST.Type(Object.class))) {
            return;
        }
        type.editor().injectMethod((MethodDecl)((MethodDecl)((MethodDecl)((MethodDecl)((MethodDecl)AST.MethodDecl(AST.Type("void"), FIRE_PROPERTY_CHANGE_METHOD_NAME).makePublic()).withArgument(AST.Arg(AST.Type(String.class), PROPERTY_NAME_ARG_NAME))).withArgument(AST.Arg(AST.Type(Object.class), OLD_VALUE_ARG_NAME))).withArgument(AST.Arg(AST.Type(Object.class), NEW_VALUE_ARG_NAME))).withStatement(AST.Call(AST.Call(PROPERTY_CHANGE_SUPPORT_METHOD_NAME), FIRE_PROPERTY_CHANGE_METHOD_NAME).withArgument(AST.Name(PROPERTY_NAME_ARG_NAME)).withArgument(AST.Name(OLD_VALUE_ARG_NAME)).withArgument(AST.Name(NEW_VALUE_ARG_NAME))));
    }

    private void generateVetoableChangeSupportFields(TYPE_TYPE type) {
        if (!type.hasField(VETOABLE_CHANGE_SUPPORT_FIELD_NAME)) {
            type.editor().injectField(AST.FieldDecl(AST.Type(VetoableChangeSupport.class), VETOABLE_CHANGE_SUPPORT_FIELD_NAME).makePrivate().makeTransient().makeVolatile());
        }
        if (!type.hasField("$vetoableChangeSupportLock")) {
            type.editor().injectField(((FieldDecl)AST.FieldDecl(AST.Type(Object.class).withDimensions(1), "$vetoableChangeSupportLock").makePrivate().makeFinal()).withInitialization(AST.NewArray(AST.Type(Object.class)).withDimensionExpression(AST.Number(0))));
        }
    }

    private void generateGetVetoableSupportMethod(TYPE_TYPE type) {
        if (type.hasMethod(VETOABLE_CHANGE_SUPPORT_METHOD_NAME, new TypeRef[0])) {
            return;
        }
        type.editor().injectMethod((MethodDecl)((MethodDecl)((MethodDecl)AST.MethodDecl(AST.Type(VetoableChangeSupport.class), VETOABLE_CHANGE_SUPPORT_METHOD_NAME).makePrivate()).withStatement(AST.If(AST.Equal(AST.Field(VETOABLE_CHANGE_SUPPORT_FIELD_NAME), AST.Null())).Then(AST.Block().withStatement(AST.Synchronized(AST.Field("$vetoableChangeSupportLock")).withStatement(AST.If(AST.Equal(AST.Field(VETOABLE_CHANGE_SUPPORT_FIELD_NAME), AST.Null())).Then(AST.Block().withStatement(AST.Assign(AST.Field(VETOABLE_CHANGE_SUPPORT_FIELD_NAME), AST.New(AST.Type(VetoableChangeSupport.class)).withArgument(AST.This()))))))))).withStatement(AST.Return(AST.Field(VETOABLE_CHANGE_SUPPORT_FIELD_NAME))));
    }

    private void generateVetoableChangeListenerMethods(TYPE_TYPE type) {
        for (String methodName : VETOABLE_CHANGE_METHOD_NAMES) {
            this.generateVetoableChangeListenerMethod(methodName, type);
        }
    }

    private void generateVetoableChangeListenerMethod(String methodName, TYPE_TYPE type) {
        if (type.hasMethod(methodName, AST.Type(VetoableChangeListener.class))) {
            return;
        }
        type.editor().injectMethod((MethodDecl)((MethodDecl)((MethodDecl)AST.MethodDecl(AST.Type("void"), methodName).makePublic()).withArgument(AST.Arg(AST.Type(VetoableChangeListener.class), LISTENER_ARG_NAME))).withStatement(AST.Call(AST.Call(VETOABLE_CHANGE_SUPPORT_METHOD_NAME), methodName).withArgument(AST.Name(LISTENER_ARG_NAME))));
    }

    private void generateFireVetoableChangeMethod(TYPE_TYPE type) {
        if (type.hasMethod(FIRE_VETOABLE_CHANGE_METHOD_NAME, AST.Type(String.class), AST.Type(Object.class), AST.Type(Object.class))) {
            return;
        }
        type.editor().injectMethod((MethodDecl)((MethodDecl)((MethodDecl)((MethodDecl)((MethodDecl)((MethodDecl)AST.MethodDecl(AST.Type("void"), FIRE_VETOABLE_CHANGE_METHOD_NAME).makePublic()).withThrownException(AST.Type(PropertyVetoException.class))).withArgument(AST.Arg(AST.Type(String.class), PROPERTY_NAME_ARG_NAME))).withArgument(AST.Arg(AST.Type(Object.class), OLD_VALUE_ARG_NAME))).withArgument(AST.Arg(AST.Type(Object.class), NEW_VALUE_ARG_NAME))).withStatement(AST.Call(AST.Call(VETOABLE_CHANGE_SUPPORT_METHOD_NAME), FIRE_VETOABLE_CHANGE_METHOD_NAME).withArgument(AST.Name(PROPERTY_NAME_ARG_NAME)).withArgument(AST.Name(OLD_VALUE_ARG_NAME)).withArgument(AST.Name(NEW_VALUE_ARG_NAME))));
    }

    @ConstructorProperties(value={"annotationNode", "ast"})
    public BoundSetterHandler(LOMBOK_NODE_TYPE annotationNode, SOURCE_TYPE ast) {
        this.annotationNode = annotationNode;
        this.ast = ast;
    }
}

