/*
 * Copyright © 2010-2012 Philipp Eichhorn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package lombok;

import java.lang.instrument.Instrumentation;

/**
 * Generates a {@code public static void agentmain} and {@code public static void premain} method that constructs a new
 * object of your type and then calls the {@code runAgent(boolean, String, Instrumentation)} method on it.
 */
public interface JvmAgent {
	/**
	 * Entry point of your JVM agent
	 * 
	 * @param injected
	 *            {@code true} if live-injected otherwise {@code false}
	 * @param params
	 *            parameters passed in to the agent
	 * @param instrumentation
	 *            the instrumentation class
	 */
	public void runAgent(boolean injected, String params, Instrumentation instrumentation) throws Throwable;
}
