/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import java.io.IOException;
import java.util.concurrent.Semaphore;

public abstract class BaseRtpSocket
implements Runnable {
    protected final String TAG = "RtpSocket";
    protected byte[][] mBuffers = new byte[this.mBufferCount][];
    protected long[] mTimestamps;
    protected Semaphore mBufferRequested;
    protected Semaphore mBufferCommitted;
    protected Thread mThread;
    protected int mBufferOut;
    protected long mClock = 0L;
    protected int mSeq = 0;
    protected int mBufferCount = 300;
    protected int mBufferIn;
    protected int mCount = 0;

    public BaseRtpSocket() {
        this.resetFifo();
        for (int i = 0; i < this.mBufferCount; ++i) {
            this.mBuffers[i] = new byte[1300];
            this.mBuffers[i][0] = (byte)Integer.parseInt("10000000", 2);
            this.mBuffers[i][1] = 96;
        }
    }

    protected void resetFifo() {
        this.mCount = 0;
        this.mBufferIn = 0;
        this.mBufferOut = 0;
        this.mTimestamps = new long[this.mBufferCount];
        this.mBufferRequested = new Semaphore(this.mBufferCount);
        this.mBufferCommitted = new Semaphore(0);
    }

    public abstract void setSSRC(int var1);

    public void setClockFrequency(long clock) {
        this.mClock = clock;
    }

    public byte[] requestBuffer() throws InterruptedException {
        this.mBufferRequested.acquire();
        byte[] byArray = this.mBuffers[this.mBufferIn];
        byArray[1] = (byte)(byArray[1] & 0x7F);
        return this.mBuffers[this.mBufferIn];
    }

    protected void updateSequence() {
        this.setLong(this.mBuffers[this.mBufferIn], ++this.mSeq, 2, 4);
    }

    public void updateTimestamp(long timestamp) {
        this.mTimestamps[this.mBufferIn] = timestamp;
        this.setLong(this.mBuffers[this.mBufferIn], timestamp / 100L * (this.mClock / 1000L) / 10000L, 4, 8);
    }

    public abstract void commitBuffer(int var1) throws IOException;

    public void markNextPacket() {
        byte[] byArray = this.mBuffers[this.mBufferIn];
        byArray[1] = (byte)(byArray[1] | 0x80);
    }

    protected void setLong(byte[] buffer, long n, int begin, int end) {
        --end;
        while (end >= begin) {
            buffer[end] = (byte)(n % 256L);
            n >>= 8;
            --end;
        }
    }
}

