/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.os.SystemClock;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import java.io.OutputStream;

public class SenderReportTcp
extends BaseSenderReport {
    private final byte[] mTcpHeader = new byte[]{36, 0, 0, 28};
    private OutputStream mOutputStream = null;

    public void update(int length, long rtpts) {
        ++this.mPacketCount;
        this.mOctetCount += length;
        this.setLong(this.mPacketCount, 20, 24);
        this.setLong(this.mOctetCount, 24, 28);
        this.now = SystemClock.elapsedRealtime();
        this.delta += this.old != 0L ? this.now - this.old : 0L;
        this.old = this.now;
        if (this.interval > 0L && this.delta >= this.interval) {
            this.send(System.nanoTime(), rtpts);
            this.delta = 0L;
        }
    }

    private void send(final long ntpts, final long rtpts) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long hb = ntpts / 1000000000L;
                long lb = (ntpts - hb * 1000000000L) * 0x100000000L / 1000000000L;
                SenderReportTcp.this.setLong(hb, 8, 12);
                SenderReportTcp.this.setLong(lb, 12, 16);
                SenderReportTcp.this.setLong(rtpts, 16, 20);
                OutputStream outputStream = SenderReportTcp.this.mOutputStream;
                synchronized (outputStream) {
                    try {
                        SenderReportTcp.this.mOutputStream.write(SenderReportTcp.this.mTcpHeader);
                        SenderReportTcp.this.mOutputStream.write(SenderReportTcp.this.mBuffer, 0, 28);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }).start();
    }

    public void setOutputStream(OutputStream os, byte channelIdentifier) {
        this.mOutputStream = os;
        this.mTcpHeader[1] = channelIdentifier;
    }
}

