/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import com.pedro.common.ExtensionsKt;
import com.pedro.common.frame.MediaFrame;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072(\u0010\b\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\tH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0005H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/pedro/rtsp/rtp/packets/H265Packet;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "<init>", "()V", "createAndSendPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reset", "rtsp_release"})
public final class H265Packet
extends BasePacket {
    public H265Packet() {
        super(90000L, 96 + RtpConstants.INSTANCE.getTrackVideo());
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackVideo());
    }

    @Override
    @Nullable
    public Object createAndSendPacket(@NotNull MediaFrame mediaFrame, @NotNull Function2<? super List<RtpFrame>, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
        byte[] header = new byte[com.pedro.rtsp.utils.ExtensionsKt.getVideoStartCodeSize(fixedBuffer) + 2];
        if (header.length == 2) {
            return Unit.INSTANCE;
        }
        fixedBuffer.get(header, 0, header.length);
        long ts = mediaFrame.getInfo().getTimestamp() * 1000L;
        int naluLength = fixedBuffer.remaining();
        int type = header[header.length - 2] >> 1;
        List frames = new ArrayList();
        if (naluLength <= this.getMaxPacketSize() - 12 - 2) {
            byte[] buffer = this.getBuffer(naluLength + 12 + 2);
            buffer[12] = header[header.length - 2];
            buffer[13] = header[header.length - 1];
            fixedBuffer.get(buffer, 14, naluLength);
            long rtpTs = this.updateTimeStamp(buffer, ts);
            this.markPacket(buffer);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, buffer.length, this.getChannelIdentifier());
            Boxing.boxBoolean((boolean)frames.add(rtpFrame));
        } else {
            header[0] = 98;
            header[1] = 1;
            header[2] = (byte)type;
            header[2] = (byte)(header[2] + 128);
            int sum = 0;
            while (sum < naluLength) {
                int length = naluLength - sum > this.getMaxPacketSize() - 12 - 3 ? this.getMaxPacketSize() - 12 - 3 : fixedBuffer.remaining();
                byte[] buffer = this.getBuffer(length + 12 + 3);
                buffer[12] = header[0];
                buffer[13] = header[1];
                buffer[14] = header[2];
                long rtpTs = this.updateTimeStamp(buffer, ts);
                fixedBuffer.get(buffer, 15, length);
                if ((sum += length) >= naluLength) {
                    buffer[14] = (byte)(buffer[14] + 64);
                    this.markPacket(buffer);
                }
                this.updateSeq(buffer);
                RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, buffer.length, this.getChannelIdentifier());
                frames.add(rtpFrame);
                header[2] = (byte)(header[2] & 0x7F);
            }
        }
        if (!((Collection)frames).isEmpty()) {
            Object object = callback.invoke((Object)frames, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void reset() {
        super.reset();
    }
}

