/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import com.pedro.common.frame.MediaFrame;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JC\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062(\u0010\u0007\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/pedro/rtsp/rtp/packets/OpusPacket;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "()V", "createAndSendPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setAudioInfo", "sampleRate", "", "rtsp_release"})
public final class OpusPacket
extends BasePacket {
    public OpusPacket() {
        super(0L, 96 + RtpConstants.INSTANCE.getTrackAudio());
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackAudio());
    }

    public final void setAudioInfo(int sampleRate) {
        this.setClock(sampleRate);
    }

    @Override
    @Nullable
    public Object createAndSendPacket(@NotNull MediaFrame mediaFrame2, @NotNull Function2<? super List<RtpFrame>, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        int size;
        int length = mediaFrame2.getInfo().getSize() - mediaFrame2.getData().position();
        int maxPayload = this.getMaxPacketSize() - 12;
        long ts = mediaFrame2.getInfo().getTimestamp() * (long)1000;
        List frames = new ArrayList();
        for (int sum = 0; sum < length; sum += size) {
            size = length - sum < maxPayload ? length - sum : maxPayload;
            byte[] buffer = this.getBuffer(size + 12);
            mediaFrame2.getData().get(buffer, 12, size);
            this.markPacket(buffer);
            long rtpTs = this.updateTimeStamp(buffer, ts);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, 12 + size, this.getChannelIdentifier());
            frames.add(rtpFrame);
        }
        if (!((Collection)frames).isEmpty()) {
            Object object = callback.invoke((Object)frames, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

