/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/pedro/rtsp/rtp/sockets/RtpSocketTcp;", "Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket;", "()V", "outputStream", "Ljava/io/OutputStream;", "tcpHeader", "", "close", "", "sendFrame", "rtpFrame", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "isEnableLogs", "", "sendFrameTCP", "setDataStream", "host", "", "rtsp_release"})
public class RtpSocketTcp
extends BaseRtpSocket {
    @Nullable
    private OutputStream outputStream;
    @NotNull
    private final byte[] tcpHeader;

    public RtpSocketTcp() {
        byte[] byArray = new byte[]{(byte)36, 0, 0, 0};
        this.tcpHeader = byArray;
    }

    @Override
    public void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.outputStream = outputStream;
    }

    @Override
    public void sendFrame(@NotNull RtpFrame rtpFrame, boolean isEnableLogs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)rtpFrame, (String)"rtpFrame");
        this.sendFrameTCP(rtpFrame, isEnableLogs);
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendFrameTCP(RtpFrame rtpFrame, boolean isEnableLogs) throws IOException {
        Object object = RtpConstants.lock;
        synchronized (object) {
            boolean bl = false;
            int len = rtpFrame.getLength();
            this.tcpHeader[1] = (byte)(2 * rtpFrame.getChannelIdentifier());
            this.tcpHeader[2] = (byte)(len >> 8);
            this.tcpHeader[3] = (byte)(len & 0xFF);
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                outputStream.write(this.tcpHeader);
            }
            OutputStream outputStream2 = this.outputStream;
            if (outputStream2 != null) {
                outputStream2.write(rtpFrame.getBuffer(), 0, len);
            }
            OutputStream outputStream3 = this.outputStream;
            if (outputStream3 != null) {
                outputStream3.flush();
            }
            if (isEnableLogs) {
                Log.i((String)this.getTAG(), (String)("wrote packet: " + (rtpFrame.isVideoFrame() ? "Video" : "Audio") + ", size: " + (len + this.tcpHeader.length)));
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

