/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtp.packets.AacPacket;
import com.pedro.rtsp.rtp.packets.AudioPacketCallback;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.packets.H264Packet;
import com.pedro.rtsp.rtp.packets.H265Packet;
import com.pedro.rtsp.rtp.packets.VideoPacketCallback;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtp.sockets.RtpSocketTcp;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.BitrateManager;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0016\u0018\u0000 T2\u00020\u00012\u00020\u0002:\u0001TB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010%\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020\tJ\u0006\u0010'\u001a\u00020\tJ\u0006\u0010(\u001a\u00020\u0019J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0010\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0006\u0010-\u001a\u00020*J\u0006\u0010.\u001a\u00020*J\u0006\u0010/\u001a\u00020*J\u0006\u00100\u001a\u00020*J\u000e\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020\u000fJ\u0016\u00103\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207J\u0016\u00108\u001a\u00020*2\u0006\u00109\u001a\u0002052\u0006\u00106\u001a\u000207J\u000e\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020\u000fJ\u0016\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000fJ\u0016\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020*2\u0006\u0010E\u001a\u00020\u0019J\u001e\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020JJ \u0010L\u001a\u00020*2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020N2\b\u0010P\u001a\u0004\u0018\u00010NJ\u0016\u0010Q\u001a\u00020*2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000fJ\u0006\u0010R\u001a\u00020*J\u0006\u0010S\u001a\u00020*R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/pedro/rtsp/rtsp/RtspSender;", "Lcom/pedro/rtsp/rtp/packets/VideoPacketCallback;", "Lcom/pedro/rtsp/rtp/packets/AudioPacketCallback;", "connectCheckerRtsp", "Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;", "(Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;)V", "aacPacket", "Lcom/pedro/rtsp/rtp/packets/AacPacket;", "audioFramesSent", "", "baseSenderReport", "Lcom/pedro/rtsp/rtcp/BaseSenderReport;", "bitrateManager", "Lcom/pedro/rtsp/utils/BitrateManager;", "defaultCacheSize", "", "getDefaultCacheSize", "()I", "<set-?>", "droppedAudioFrames", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "isEnableLogs", "", "rtpFrameBlockingQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "rtpSocket", "Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket;", "running", "thread", "Landroid/os/HandlerThread;", "videoFramesSent", "videoPacket", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "getCacheSize", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "onAudioFrameCreated", "", "rtpFrame", "onVideoFrameCreated", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudioFrame", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideoFrame", "h264Buffer", "setAudioInfo", "sampleRate", "setAudioPorts", "rtpPort", "rtcpPort", "setDataStream", "outputStream", "Ljava/io/OutputStream;", "host", "", "setLogs", "enable", "setSocketsInfo", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "videoSourcePorts", "", "audioSourcePorts", "setVideoInfo", "sps", "", "pps", "vps", "setVideoPorts", "start", "stop", "Companion", "rtsp_release"})
public class RtspSender
implements VideoPacketCallback,
AudioPacketCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectCheckerRtsp connectCheckerRtsp;
    @Nullable
    private BasePacket videoPacket;
    @Nullable
    private AacPacket aacPacket;
    @Nullable
    private BaseRtpSocket rtpSocket;
    @Nullable
    private BaseSenderReport baseSenderReport;
    private boolean running;
    @NotNull
    private volatile BlockingQueue<RtpFrame> rtpFrameBlockingQueue;
    @Nullable
    private HandlerThread thread;
    private long audioFramesSent;
    private long videoFramesSent;
    private long droppedAudioFrames;
    private long droppedVideoFrames;
    @NotNull
    private final BitrateManager bitrateManager;
    private boolean isEnableLogs;
    @NotNull
    private static final String TAG = "RtspSender";

    public RtspSender(@NotNull ConnectCheckerRtsp connectCheckerRtsp) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtsp, (String)"connectCheckerRtsp");
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.rtpFrameBlockingQueue = new LinkedBlockingQueue(this.getDefaultCacheSize());
        this.bitrateManager = new BitrateManager(this.connectCheckerRtsp);
        this.isEnableLogs = true;
    }

    public final long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    public final long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    public final void setSocketsInfo(@NotNull Protocol protocol, @NotNull int[] videoSourcePorts, @NotNull int[] audioSourcePorts) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)videoSourcePorts, (String)"videoSourcePorts");
        Intrinsics.checkNotNullParameter((Object)audioSourcePorts, (String)"audioSourcePorts");
        this.rtpSocket = BaseRtpSocket.Companion.getInstance(protocol, videoSourcePorts[0], audioSourcePorts[0]);
        this.baseSenderReport = BaseSenderReport.Companion.getInstance(protocol, videoSourcePorts[1], audioSourcePorts[1]);
    }

    public final void setVideoInfo(@NotNull byte[] sps, @NotNull byte[] pps, @Nullable byte[] vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.videoPacket = vps == null ? (BasePacket)new H264Packet(sps, pps, this) : (BasePacket)new H265Packet(sps, pps, vps, this);
    }

    public final void setAudioInfo(int sampleRate) {
        this.aacPacket = new AacPacket(sampleRate, this);
    }

    private final int getDefaultCacheSize() {
        return 6990;
    }

    public final void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Object object = this.rtpSocket;
        if (object != null) {
            ((BaseRtpSocket)object).setDataStream(outputStream, host);
        }
        object = this.baseSenderReport;
        if (object != null) {
            ((BaseSenderReport)object).setDataStream(outputStream, host);
        }
    }

    public final void setVideoPorts(int rtpPort, int rtcpPort) {
        BasePacket basePacket = this.videoPacket;
        if (basePacket != null) {
            basePacket.setPorts(rtpPort, rtcpPort);
        }
    }

    public final void setAudioPorts(int rtpPort, int rtcpPort) {
        AacPacket aacPacket = this.aacPacket;
        if (aacPacket != null) {
            aacPacket.setPorts(rtpPort, rtcpPort);
        }
    }

    public final void sendVideoFrame(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        BasePacket basePacket;
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running && (basePacket = this.videoPacket) != null) {
            basePacket.createAndSendPacket(h264Buffer, info);
        }
    }

    public final void sendAudioFrame(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        AacPacket aacPacket;
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running && (aacPacket = this.aacPacket) != null) {
            aacPacket.createAndSendPacket(aacBuffer, info);
        }
    }

    @Override
    public void onVideoFrameCreated(@NotNull RtpFrame rtpFrame) {
        Intrinsics.checkNotNullParameter((Object)rtpFrame, (String)"rtpFrame");
        try {
            this.rtpFrameBlockingQueue.add(rtpFrame);
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)"Video frame discarded");
            RtspSender rtspSender = this;
            long l = rtspSender.droppedVideoFrames;
            rtspSender.droppedVideoFrames = l + 1L;
        }
    }

    @Override
    public void onAudioFrameCreated(@NotNull RtpFrame rtpFrame) {
        Intrinsics.checkNotNullParameter((Object)rtpFrame, (String)"rtpFrame");
        try {
            this.rtpFrameBlockingQueue.add(rtpFrame);
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)"Audio frame discarded");
            RtspSender rtspSender = this;
            long l = rtspSender.droppedAudioFrames;
            rtspSender.droppedAudioFrames = l + 1L;
        }
    }

    public final void start() {
        this.thread = new HandlerThread(TAG);
        HandlerThread handlerThread = this.thread;
        if (handlerThread != null) {
            handlerThread.start();
        }
        handlerThread = this.thread;
        if (handlerThread != null) {
            HandlerThread handlerThread2 = handlerThread;
            boolean bl = false;
            boolean bl2 = false;
            HandlerThread it = handlerThread2;
            boolean bl3 = false;
            Handler h = new Handler(it.getLooper());
            this.running = true;
            h.post(() -> RtspSender.start$lambda-1$lambda-0(this));
        }
    }

    public final void stop() {
        Object object;
        this.running = false;
        Object object2 = this.thread;
        Object object3 = object = object2 == null ? null : object2.getLooper();
        if (object != null && (object2 = object.getThread()) != null) {
            ((Thread)object2).interrupt();
        }
        if ((object = this.thread) != null && (object2 = object.getLooper()) != null) {
            object2.quit();
        }
        if ((object = this.thread) != null) {
            object.quit();
        }
        try {
            object = this.thread;
            if (object != null) {
                object.join(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thread = null;
        this.rtpFrameBlockingQueue.clear();
        object = this.baseSenderReport;
        if (object != null) {
            ((BaseSenderReport)object).reset();
        }
        object = this.baseSenderReport;
        if (object != null) {
            ((BaseSenderReport)object).close();
        }
        object = this.rtpSocket;
        if (object != null) {
            ((BaseRtpSocket)object).close();
        }
        object = this.aacPacket;
        if (object != null) {
            ((BasePacket)object).reset();
        }
        object = this.videoPacket;
        if (object != null) {
            ((BasePacket)object).reset();
        }
        this.resetSentAudioFrames();
        this.resetSentVideoFrames();
        this.resetDroppedAudioFrames();
        this.resetDroppedVideoFrames();
    }

    public final boolean hasCongestion() {
        float remaining;
        float capacity;
        float size = this.rtpFrameBlockingQueue.size();
        return size >= (capacity = size + (remaining = (float)this.rtpFrameBlockingQueue.remainingCapacity())) * 0.2f;
    }

    public final void resizeCache(int newSize) {
        if (newSize < this.rtpFrameBlockingQueue.size() - this.rtpFrameBlockingQueue.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        BlockingQueue tempQueue = new LinkedBlockingQueue(newSize);
        this.rtpFrameBlockingQueue.drainTo(tempQueue);
        this.rtpFrameBlockingQueue = tempQueue;
    }

    public final int getCacheSize() {
        return this.rtpFrameBlockingQueue.size();
    }

    public final long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public final long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public final void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public final void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public final void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public final void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }

    public final void setLogs(boolean enable) {
        this.isEnableLogs = enable;
    }

    private static final void start$lambda-1$lambda-0(RtspSender this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        long ssrcVideo = new Random().nextInt();
        long ssrcAudio = new Random().nextInt();
        Object object = this$0.baseSenderReport;
        if (object != null) {
            ((BaseSenderReport)object).setSSRC(ssrcVideo, ssrcAudio);
        }
        object = this$0.videoPacket;
        if (object != null) {
            ((BasePacket)object).setSSRC(ssrcVideo);
        }
        object = this$0.aacPacket;
        if (object != null) {
            ((BasePacket)object).setSSRC(ssrcAudio);
        }
        boolean isTcp = this$0.rtpSocket instanceof RtpSocketTcp;
        while (!Thread.interrupted()) {
            try {
                int n;
                BaseSenderReport baseSenderReport;
                long l;
                Object object2;
                RtpFrame rtpFrame = this$0.rtpFrameBlockingQueue.poll(1L, TimeUnit.SECONDS);
                if (rtpFrame == null) {
                    Log.i((String)TAG, (String)"Skipping iteration, frame null");
                    continue;
                }
                BaseRtpSocket baseRtpSocket = this$0.rtpSocket;
                if (baseRtpSocket != null) {
                    baseRtpSocket.sendFrame(rtpFrame, this$0.isEnableLogs);
                }
                int packetSize = isTcp ? rtpFrame.getLength() + 4 : rtpFrame.getLength();
                this$0.bitrateManager.calculateBitrate((long)packetSize * 8L);
                if (rtpFrame.isVideoFrame()) {
                    object2 = this$0;
                    l = ((RtspSender)object2).videoFramesSent;
                    ((RtspSender)object2).videoFramesSent = l + 1L;
                } else {
                    object2 = this$0;
                    l = ((RtspSender)object2).audioFramesSent;
                    ((RtspSender)object2).audioFramesSent = l + 1L;
                }
                if (!Intrinsics.areEqual((object2 = this$0.baseSenderReport) == null ? null : Boolean.valueOf(((BaseSenderReport)object2).update(rtpFrame, this$0.isEnableLogs)), (Object)true)) continue;
                int reportSize = isTcp ? ((baseSenderReport = this$0.baseSenderReport) == null ? 4 : (n = baseSenderReport.getPACKET_LENGTH())) : ((baseSenderReport = this$0.baseSenderReport) == null ? 0 : (n = baseSenderReport.getPACKET_LENGTH()));
                this$0.bitrateManager.calculateBitrate((long)reportSize * 8L);
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedException)) {
                    this$0.connectCheckerRtsp.onConnectionFailedRtsp(Intrinsics.stringPlus((String)"Error send packet, ", (Object)e.getMessage()));
                    Log.e((String)TAG, (String)"send error: ", (Throwable)e);
                }
                return;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pedro/rtsp/rtsp/RtspSender$Companion;", "", "()V", "TAG", "", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

