/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.packets.VideoPacketCallback;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/pedro/rtsp/rtp/packets/H264Packet;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "sps", "", "pps", "videoPacketCallback", "Lcom/pedro/rtsp/rtp/packets/VideoPacketCallback;", "([B[BLcom/pedro/rtsp/rtp/packets/VideoPacketCallback;)V", "header", "sendKeyFrame", "", "stapA", "createAndSendPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "reset", "setSpsPps", "rtsp_release"})
public class H264Packet
extends BasePacket {
    private final byte[] header;
    private byte[] stapA;
    private boolean sendKeyFrame;
    private final VideoPacketCallback videoPacketCallback;

    @Override
    public void createAndSendPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        if (bufferInfo.size < 5) {
            return;
        }
        byteBuffer.rewind();
        byteBuffer.get(this.header, 0, 5);
        long ts = bufferInfo.presentationTimeUs * 1000L;
        int naluLength = bufferInfo.size - byteBuffer.position() + 1;
        byte by = this.header[4];
        int n = 31;
        boolean bl = false;
        byte type = (byte)(by & n);
        if (type == 5 || bufferInfo.flags == 1) {
            if (type != 5) {
                this.header[4] = (byte)5;
            }
            if (this.stapA != null) {
                byte[] byArray = this.stapA;
                n = 0;
                bl = false;
                byte[] it = byArray;
                boolean bl2 = false;
                byte[] buffer = this.getBuffer(it.length + 12);
                long rtpTs = this.updateTimeStamp(buffer, ts);
                this.markPacket(buffer);
                System.arraycopy(it, 0, buffer, 12, it.length);
                this.updateSeq(buffer);
                RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, it.length + 12, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
                this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
                this.sendKeyFrame = true;
            } else {
                H264Packet h264Packet = this;
                n = 0;
                bl = false;
                H264Packet $this$run = h264Packet;
                boolean bl3 = false;
                Log.i((String)$this$run.getTAG(), (String)"can't create key frame because setSpsPps was not called");
            }
        }
        if (this.sendKeyFrame) {
            int length;
            int cont;
            if (naluLength <= this.getMaxPacketSize() - 12 - 2) {
                cont = naluLength - 1;
                length = cont < bufferInfo.size - byteBuffer.position() ? cont : bufferInfo.size - byteBuffer.position();
                byte[] buffer = this.getBuffer(length + 12 + 1);
                buffer[12] = this.header[4];
                byteBuffer.get(buffer, 13, length);
                long rtpTs = this.updateTimeStamp(buffer, ts);
                this.markPacket(buffer);
                this.updateSeq(buffer);
                RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, naluLength + 12, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
                this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
            } else {
                cont = this.header[4];
                length = 31;
                boolean buffer = false;
                this.header[1] = (byte)(cont & length);
                this.header[1] = (byte)(this.header[1] + 128);
                cont = this.header[4];
                length = 96;
                buffer = false;
                cont = (byte)(cont & length);
                length = (byte)255;
                buffer = false;
                this.header[0] = (byte)(cont & length);
                this.header[0] = (byte)(this.header[0] + 28);
                int sum = 1;
                while (sum < naluLength) {
                    int cont2 = naluLength - sum > this.getMaxPacketSize() - 12 - 2 ? this.getMaxPacketSize() - 12 - 2 : naluLength - sum;
                    int length2 = cont2 < bufferInfo.size - byteBuffer.position() ? cont2 : bufferInfo.size - byteBuffer.position();
                    byte[] buffer2 = this.getBuffer(length2 + 12 + 2);
                    buffer2[12] = this.header[0];
                    buffer2[13] = this.header[1];
                    long rtpTs = this.updateTimeStamp(buffer2, ts);
                    byteBuffer.get(buffer2, 14, length2);
                    if ((sum += length2) >= naluLength) {
                        buffer2[13] = (byte)(buffer2[13] + 64);
                        this.markPacket(buffer2);
                    }
                    this.updateSeq(buffer2);
                    RtpFrame rtpFrame = new RtpFrame(buffer2, rtpTs, length2 + 12 + 2, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
                    this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
                    byte by2 = this.header[1];
                    int n2 = 127;
                    boolean bl4 = false;
                    this.header[1] = (byte)(by2 & n2);
                }
            }
        }
    }

    private final void setSpsPps(byte[] sps, byte[] pps) {
        block0: {
            if (this.stapA == null) break block0;
            byte[] byArray = this.stapA = new byte[sps.length + pps.length + 5];
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            it[0] = 24;
            it[1] = (byte)(sps.length >> 8);
            it[2] = (byte)(sps.length & 0xFF);
            it[sps.length + 3] = (byte)(pps.length >> 8);
            it[sps.length + 4] = (byte)(pps.length & 0xFF);
            System.arraycopy(sps, 0, it, 3, sps.length);
            System.arraycopy(pps, 0, it, 5 + sps.length, pps.length);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.sendKeyFrame = false;
    }

    public H264Packet(@NotNull byte[] sps, @NotNull byte[] pps, @NotNull VideoPacketCallback videoPacketCallback) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Intrinsics.checkNotNullParameter((Object)videoPacketCallback, (String)"videoPacketCallback");
        super(90000L, 96 + RtpConstants.INSTANCE.getTrackVideo());
        this.videoPacketCallback = videoPacketCallback;
        this.header = new byte[5];
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackVideo());
        this.setSpsPps(sps, pps);
    }
}

