/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J8\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J8\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/pedro/rtsp/rtcp/SenderReportUdp;", "Lcom/pedro/rtsp/rtcp/BaseSenderReport;", "videoSourcePort", "", "audioSourcePort", "(II)V", "datagramPacket", "Ljava/net/DatagramPacket;", "multicastSocketAudio", "Ljava/net/MulticastSocket;", "multicastSocketVideo", "close", "", "sendReport", "buffer", "", "rtpFrame", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "type", "", "packetCount", "octetCount", "isEnableLogs", "", "sendReportUDP", "port", "packet", "octet", "setDataStream", "outputStream", "Ljava/io/OutputStream;", "host", "rtsp_release"})
public class SenderReportUdp
extends BaseSenderReport {
    private MulticastSocket multicastSocketVideo;
    private MulticastSocket multicastSocketAudio;
    private final DatagramPacket datagramPacket = new DatagramPacket(new byte[]{0}, 1);

    @Override
    public void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        try {
            this.datagramPacket.setAddress(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            Log.e((String)this.getTAG(), (String)"Error", (Throwable)e);
        }
    }

    @Override
    public void sendReport(@NotNull byte[] buffer, @NotNull RtpFrame rtpFrame, @NotNull String type, int packetCount, int octetCount, boolean isEnableLogs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)rtpFrame, (String)"rtpFrame");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.sendReportUDP(buffer, rtpFrame.getRtcpPort(), type, packetCount, octetCount, isEnableLogs);
    }

    @Override
    public void close() {
        block1: {
            MulticastSocket multicastSocket = this.multicastSocketVideo;
            if (multicastSocket != null) {
                multicastSocket.close();
            }
            MulticastSocket multicastSocket2 = this.multicastSocketAudio;
            if (multicastSocket2 == null) break block1;
            multicastSocket2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendReportUDP(byte[] buffer, int port, String type, int packet, int octet, boolean isEnableLogs) throws IOException {
        Object object = RtpConstants.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.datagramPacket.setData(buffer);
            this.datagramPacket.setPort(port);
            this.datagramPacket.setLength(this.getPACKET_LENGTH());
            if (Intrinsics.areEqual((Object)type, (Object)"Video")) {
                MulticastSocket multicastSocket = this.multicastSocketVideo;
                if (multicastSocket != null) {
                    multicastSocket.send(this.datagramPacket);
                }
            } else {
                MulticastSocket multicastSocket = this.multicastSocketAudio;
                if (multicastSocket != null) {
                    multicastSocket.send(this.datagramPacket);
                }
            }
            if (isEnableLogs) {
                Log.i((String)this.getTAG(), (String)("wrote report: " + type + ", port: " + port + ", packets: " + packet + ", octet: " + octet));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public SenderReportUdp(int videoSourcePort, int audioSourcePort) {
        try {
            MulticastSocket multicastSocket = this.multicastSocketVideo = new MulticastSocket(videoSourcePort);
            if (multicastSocket != null) {
                multicastSocket.setTimeToLive(64);
            }
            MulticastSocket multicastSocket2 = this.multicastSocketAudio = new MulticastSocket(audioSourcePort);
            if (multicastSocket2 != null) {
                multicastSocket2.setTimeToLive(64);
            }
        }
        catch (Exception e) {
            Log.e((String)this.getTAG(), (String)"Error", (Throwable)e);
        }
    }
}

