/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.RtpFrame;
import java.io.IOException;
import java.io.OutputStream;

public class RtpSocketTcp
extends BaseRtpSocket {
    private OutputStream outputStream;
    private byte[] tcpHeader = new byte[]{36, 0, 0, 0};

    @Override
    public void setDataStream(OutputStream outputStream, String host) {
        this.outputStream = outputStream;
    }

    @Override
    public void sendFrame(RtpFrame rtpFrame) throws IOException {
        this.sendFrameTCP(rtpFrame);
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFrameTCP(RtpFrame rtpFrame) throws IOException {
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            int len = rtpFrame.getLength();
            this.tcpHeader[1] = rtpFrame.getChannelIdentifier();
            this.tcpHeader[2] = (byte)(len >> 8);
            this.tcpHeader[3] = (byte)(len & 0xFF);
            this.outputStream.write(this.tcpHeader);
            this.outputStream.write(rtpFrame.getBuffer(), 0, len);
            this.outputStream.flush();
            Log.i((String)"BaseRtpSocket", (String)("wrote packet: " + (rtpFrame.getChannelIdentifier() == 2 ? "Video" : "Audio") + ", size: " + rtpFrame.getLength()));
        }
    }
}

