/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtp.packets.AacPacket;
import com.pedro.rtsp.rtp.packets.AudioPacketCallback;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.packets.H264Packet;
import com.pedro.rtsp.rtp.packets.H265Packet;
import com.pedro.rtsp.rtp.packets.VideoPacketCallback;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class RtspSender
implements VideoPacketCallback,
AudioPacketCallback {
    private static final String TAG = "RtspSender";
    private BasePacket videoPacket;
    private AacPacket aacPacket;
    private BaseRtpSocket rtpSocket;
    private BaseSenderReport baseSenderReport;
    private volatile BlockingQueue<RtpFrame> rtpFrameBlockingQueue = new LinkedBlockingQueue<RtpFrame>(this.getDefaultCacheSize());
    private Thread thread;
    private ConnectCheckerRtsp connectCheckerRtsp;
    private long audioFramesSent = 0L;
    private long videoFramesSent = 0L;
    private long droppedAudioFrames = 0L;
    private long droppedVideoFrames = 0L;

    public RtspSender(ConnectCheckerRtsp connectCheckerRtsp) {
        this.connectCheckerRtsp = connectCheckerRtsp;
    }

    public void setInfo(Protocol protocol, byte[] sps, byte[] pps, byte[] vps, int sampleRate) {
        this.videoPacket = vps == null ? new H264Packet(sps, pps, this) : new H265Packet(sps, pps, vps, this);
        this.aacPacket = new AacPacket(sampleRate, this);
        this.rtpSocket = BaseRtpSocket.getInstance(protocol);
        this.baseSenderReport = BaseSenderReport.getInstance(protocol);
    }

    private int getDefaultCacheSize() {
        return 8065;
    }

    public void setDataStream(OutputStream outputStream, String host) {
        this.rtpSocket.setDataStream(outputStream, host);
        this.baseSenderReport.setDataStream(outputStream, host);
    }

    public void setVideoPorts(int rtpPort, int rtcpPort) {
        this.videoPacket.setPorts(rtpPort, rtcpPort);
    }

    public void setAudioPorts(int rtpPort, int rtcpPort) {
        this.aacPacket.setPorts(rtpPort, rtcpPort);
    }

    public void sendVideoFrame(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.videoPacket.createAndSendPacket(h264Buffer, info);
    }

    public void sendAudioFrame(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.aacPacket.createAndSendPacket(aacBuffer, info);
    }

    @Override
    public void onVideoFrameCreated(RtpFrame rtpFrame) {
        try {
            this.rtpFrameBlockingQueue.add(rtpFrame);
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)"Video frame discarded");
            ++this.droppedVideoFrames;
        }
    }

    @Override
    public void onAudioFrameCreated(RtpFrame rtpFrame) {
        try {
            this.rtpFrameBlockingQueue.add(rtpFrame);
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)"Audio frame discarded");
            ++this.droppedAudioFrames;
        }
    }

    public void start() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        RtpFrame rtpFrame = (RtpFrame)RtspSender.this.rtpFrameBlockingQueue.poll(1L, TimeUnit.SECONDS);
                        if (rtpFrame == null) {
                            Log.i((String)RtspSender.TAG, (String)"Skipping iteration, frame null");
                            continue;
                        }
                        RtspSender.this.rtpSocket.sendFrame(rtpFrame);
                        if (rtpFrame.isVideoFrame()) {
                            RtspSender.this.videoFramesSent++;
                        } else {
                            RtspSender.this.audioFramesSent++;
                        }
                        RtspSender.this.baseSenderReport.update(rtpFrame);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (IOException e) {
                        Log.e((String)RtspSender.TAG, (String)"send error: ", (Throwable)e);
                        RtspSender.this.connectCheckerRtsp.onConnectionFailedRtsp("Error send packet, " + e.getMessage());
                    }
                }
            }
        });
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        this.rtpFrameBlockingQueue.clear();
        this.baseSenderReport.reset();
        this.baseSenderReport.close();
        this.rtpSocket.close();
        this.aacPacket.reset();
        this.videoPacket.reset();
        this.resetSentAudioFrames();
        this.resetSentVideoFrames();
        this.resetDroppedAudioFrames();
        this.resetDroppedVideoFrames();
    }

    public void resizeCache(int newSize) {
        if (newSize < this.rtpFrameBlockingQueue.size() - this.rtpFrameBlockingQueue.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        LinkedBlockingQueue<RtpFrame> tempQueue = new LinkedBlockingQueue<RtpFrame>(newSize);
        this.rtpFrameBlockingQueue.drainTo(tempQueue);
        this.rtpFrameBlockingQueue = tempQueue;
    }

    public int getCacheSize() {
        return this.rtpFrameBlockingQueue.size();
    }

    public long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    public long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    public void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }
}

