/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtp.packets.AacPacket;
import com.pedro.rtsp.rtp.packets.AudioPacketCallback;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.packets.H264Packet;
import com.pedro.rtsp.rtp.packets.H265Packet;
import com.pedro.rtsp.rtp.packets.VideoPacketCallback;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class RtspSender
implements VideoPacketCallback,
AudioPacketCallback {
    private static final String TAG = "RtspSender";
    private final BasePacket videoPacket;
    private final AacPacket aacPacket;
    private final BaseRtpSocket rtpSocket;
    private final BaseSenderReport baseSenderReport;
    private BlockingQueue<RtpFrame> rtpFrameBlockingQueue = new LinkedBlockingQueue<RtpFrame>(this.getCacheSize(10));
    private Thread thread;

    public RtspSender(ConnectCheckerRtsp connectCheckerRtsp, Protocol protocol, byte[] sps, byte[] pps, byte[] vps, int sampleRate) {
        this.videoPacket = vps == null ? new H264Packet(sps, pps, this) : new H265Packet(sps, pps, vps, this);
        this.aacPacket = new AacPacket(sampleRate, this);
        this.rtpSocket = BaseRtpSocket.getInstance(connectCheckerRtsp, protocol);
        this.baseSenderReport = BaseSenderReport.getInstance(protocol);
    }

    private int getCacheSize(int size) {
        return size * 1024 * 1024 / 1300;
    }

    public void setDataStream(OutputStream outputStream, String host) {
        this.rtpSocket.setDataStream(outputStream, host);
        this.baseSenderReport.setDataStream(outputStream, host);
    }

    public void setVideoPorts(int rtpPort, int rtcpPort) {
        this.videoPacket.setPorts(rtpPort, rtcpPort);
    }

    public void setAudioPorts(int rtpPort, int rtcpPort) {
        this.aacPacket.setPorts(rtpPort, rtcpPort);
    }

    public void sendVideoFrame(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.videoPacket.createAndSendPacket(h264Buffer, info);
    }

    public void sendAudioFrame(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.aacPacket.createAndSendPacket(aacBuffer, info);
    }

    @Override
    public void onVideoFrameCreated(RtpFrame rtpFrame) {
        try {
            this.rtpFrameBlockingQueue.add(rtpFrame);
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)"Video frame discarded");
        }
    }

    @Override
    public void onAudioFrameCreated(RtpFrame rtpFrame) {
        try {
            this.rtpFrameBlockingQueue.add(rtpFrame);
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)"Audio frame discarded");
        }
    }

    public void start() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        RtpFrame rtpFrame = (RtpFrame)RtspSender.this.rtpFrameBlockingQueue.take();
                        RtspSender.this.rtpSocket.sendFrame(rtpFrame);
                        RtspSender.this.baseSenderReport.update(rtpFrame);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        this.rtpFrameBlockingQueue.clear();
        this.baseSenderReport.reset();
        this.baseSenderReport.close();
        this.rtpSocket.close();
        this.aacPacket.reset();
        this.videoPacket.reset();
    }
}

