/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

public class Body {
    private static final int[] AUDIO_SAMPLING_RATES = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350, -1, -1, -1};

    public static String createAacBody(int trackAudio, int sampleRate, boolean isStereo) {
        int sampleRateNum = -1;
        for (int i = 0; i < AUDIO_SAMPLING_RATES.length; ++i) {
            if (AUDIO_SAMPLING_RATES[i] != sampleRate) continue;
            sampleRateNum = i;
            break;
        }
        int channel = isStereo ? 2 : 1;
        int config = 0x1000 | (sampleRateNum & 0xF) << 7 | (channel & 0xF) << 3;
        return "m=audio 0 RTP/AVP 96\r\na=rtpmap:96 MPEG4-GENERIC/" + sampleRate + "/" + channel + "\r\na=fmtp:" + 96 + " streamtype=5; profile-level-id=15; mode=AAC-hbr; config=" + Integer.toHexString(config) + "; SizeLength=13; IndexLength=3; IndexDeltaLength=3;\r\na=control:trackID=" + trackAudio + "\r\n";
    }

    public static String createH264Body(int trackVideo, String sps, String pps) {
        return "m=video 0 RTP/AVP 96\r\na=rtpmap:96 H264/90000\r\na=fmtp:96 packetization-mode=1;sprop-parameter-sets=" + sps + "," + pps + ";\r\na=control:trackID=" + trackVideo + "\r\n";
    }

    public static String createH265Body(int trackVideo, String sps, String pps, String vps) {
        return "m=video 0 RTP/AVP 96\r\na=rtpmap:96 H265/90000\r\na=fmtp:96 sprop-sps=" + sps + "; sprop-pps=" + pps + "; sprop-vps=" + vps + ";\r\na=control:trackID=" + trackVideo + "\r\n";
    }
}

