/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.util.Log;
import com.pedro.rtsp.rtcp.SenderReportTcp;
import com.pedro.rtsp.rtcp.SenderReportUdp;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtpFrame;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;

public abstract class BaseSenderReport {
    protected static final String TAG = "BaseSenderReport";
    protected static final int PACKET_LENGTH = 28;
    private static final int MTU = 1500;
    private final long interval = 3000L;
    private final byte[] videoBuffer = new byte[1500];
    private final byte[] audioBuffer = new byte[1500];
    private long videoTime;
    private long audioTime;
    private int videoPacketCount;
    private int videoOctetCount;
    private int audioPacketCount;
    private int audioOctetCount;

    BaseSenderReport() {
        this.videoBuffer[0] = (byte)Integer.parseInt("10000000", 2);
        this.audioBuffer[0] = (byte)Integer.parseInt("10000000", 2);
        this.videoBuffer[1] = -56;
        this.audioBuffer[1] = -56;
        this.setLong(this.videoBuffer, 6L, 2, 4);
        this.setLong(this.audioBuffer, 6L, 2, 4);
        this.setLong(this.videoBuffer, new Random().nextInt(), 4, 8);
        this.setLong(this.audioBuffer, new Random().nextInt(), 4, 8);
    }

    public static BaseSenderReport getInstance(Protocol protocol) {
        return protocol == Protocol.TCP ? new SenderReportTcp() : new SenderReportUdp();
    }

    public abstract void setDataStream(OutputStream var1, String var2);

    public void update(RtpFrame rtpFrame) {
        if (rtpFrame.getChannelIdentifier() == 2) {
            this.updateVideo(rtpFrame);
        } else {
            this.updateAudio(rtpFrame);
        }
    }

    public abstract void sendReport(byte[] var1, RtpFrame var2, String var3, int var4, int var5) throws IOException;

    private void updateVideo(RtpFrame rtpFrame) {
        ++this.videoPacketCount;
        this.videoOctetCount += rtpFrame.getLength();
        this.setLong(this.videoBuffer, this.videoPacketCount, 20, 24);
        this.setLong(this.videoBuffer, this.videoOctetCount, 24, 28);
        if (System.currentTimeMillis() - this.videoTime >= 3000L) {
            this.videoTime = System.currentTimeMillis();
            this.setData(this.videoBuffer, System.nanoTime(), rtpFrame.getTimeStamp());
            try {
                this.sendReport(this.videoBuffer, rtpFrame, "Video", this.videoPacketCount, this.videoOctetCount);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error", (Throwable)e);
            }
        }
    }

    private void updateAudio(RtpFrame rtpFrame) {
        ++this.audioPacketCount;
        this.audioOctetCount += rtpFrame.getLength();
        this.setLong(this.audioBuffer, this.audioPacketCount, 20, 24);
        this.setLong(this.audioBuffer, this.audioOctetCount, 24, 28);
        if (System.currentTimeMillis() - this.audioTime >= 3000L) {
            this.audioTime = System.currentTimeMillis();
            this.setData(this.audioBuffer, System.nanoTime(), rtpFrame.getTimeStamp());
            try {
                this.sendReport(this.audioBuffer, rtpFrame, "Audio", this.audioPacketCount, this.audioOctetCount);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error", (Throwable)e);
            }
        }
    }

    public void reset() {
        this.videoOctetCount = 0;
        this.videoPacketCount = 0;
        this.audioOctetCount = 0;
        this.audioPacketCount = 0;
        this.audioTime = 0L;
        this.videoTime = 0L;
        this.setLong(this.videoBuffer, this.videoPacketCount, 20, 24);
        this.setLong(this.videoBuffer, this.videoOctetCount, 24, 28);
        this.setLong(this.audioBuffer, this.audioPacketCount, 20, 24);
        this.setLong(this.audioBuffer, this.audioOctetCount, 24, 28);
    }

    public abstract void close();

    private void setLong(byte[] buffer, long n, int begin, int end) {
        --end;
        while (end >= begin) {
            buffer[end] = (byte)(n % 256L);
            n >>= 8;
            --end;
        }
    }

    private void setData(byte[] buffer, long ntpts, long rtpts) {
        long hb = ntpts / 1000000000L;
        long lb = (ntpts - hb * 1000000000L) * 0x100000000L / 1000000000L;
        this.setLong(buffer, hb, 8, 12);
        this.setLong(buffer, lb, 12, 16);
        this.setLong(buffer, rtpts, 16, 20);
    }
}

