/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.util.sources;

import android.media.AudioPlaybackCaptureConfiguration;
import android.media.projection.MediaProjection;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.rtplibrary.util.sources.NoSource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0007J\u0006\u0010\u0017\u001a\u00020\u0015J&\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0019\u001a\u00020\u000bJ\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000bJ\u0006\u0010\u001f\u001a\u00020\u0015J\u0006\u0010 \u001a\u00020\u0015J\u0006\u0010!\u001a\u00020\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/pedro/rtplibrary/util/sources/AudioManager;", "", "getMicrophoneData", "Lcom/pedro/encoder/input/audio/GetMicrophoneData;", "source", "Lcom/pedro/rtplibrary/util/sources/AudioManager$Source;", "(Lcom/pedro/encoder/input/audio/GetMicrophoneData;Lcom/pedro/rtplibrary/util/sources/AudioManager$Source;)V", "echoCanceler", "", "isStereo", "maxInputSize", "", "mediaProjection", "Landroid/media/projection/MediaProjection;", "microphone", "Lcom/pedro/encoder/input/audio/MicrophoneManager;", "noSource", "Lcom/pedro/rtplibrary/util/sources/NoSource;", "noiseSuppressor", "sampleRate", "changeAudioSourceDisabled", "", "changeSourceInternal", "changeSourceMicrophone", "createAudioManager", "getMaxInputSize", "isMuted", "isRunning", "mute", "setMaxInputSize", "size", "start", "stop", "unMute", "Source", "rtplibrary_release"})
@RequiresApi(value=21)
public final class AudioManager {
    @NotNull
    private Source source;
    @NotNull
    private final MicrophoneManager microphone;
    @NotNull
    private final NoSource noSource;
    @Nullable
    private MediaProjection mediaProjection;
    private int sampleRate;
    private boolean isStereo;
    private boolean echoCanceler;
    private boolean noiseSuppressor;
    private int maxInputSize;

    public AudioManager(@NotNull GetMicrophoneData getMicrophoneData, @NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)getMicrophoneData, (String)"getMicrophoneData");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        this.source = source;
        this.microphone = new MicrophoneManager(getMicrophoneData);
        this.noSource = new NoSource();
        this.isStereo = true;
        this.maxInputSize = 4096;
    }

    public final boolean createAudioManager(int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.sampleRate = sampleRate;
        this.isStereo = isStereo;
        this.echoCanceler = echoCanceler;
        this.noiseSuppressor = noiseSuppressor;
        boolean result = this.microphone.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        this.maxInputSize = this.microphone.getMaxInputSize();
        return result;
    }

    public final void start() {
        if (!this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    this.microphone.setMaxInputSize(this.maxInputSize);
                    boolean result = this.microphone.createMicrophone(this.sampleRate, this.isStereo, this.echoCanceler, this.noiseSuppressor);
                    if (!result) {
                        throw new IllegalArgumentException("Failed to create microphone audio source");
                    }
                    this.microphone.start();
                    break;
                }
                case 2: {
                    if (Build.VERSION.SDK_INT >= 29) {
                        MediaProjection mediaProjection = this.mediaProjection;
                        if (mediaProjection != null) {
                            MediaProjection it = mediaProjection;
                            boolean bl = false;
                            AudioPlaybackCaptureConfiguration audioPlaybackCaptureConfiguration = new AudioPlaybackCaptureConfiguration.Builder(it).addMatchingUsage(1).addMatchingUsage(14).addMatchingUsage(0).build();
                            Intrinsics.checkNotNullExpressionValue((Object)audioPlaybackCaptureConfiguration, (String)"Builder(it)\n            \u2026es.USAGE_UNKNOWN).build()");
                            AudioPlaybackCaptureConfiguration config = audioPlaybackCaptureConfiguration;
                            this.microphone.setMaxInputSize(this.maxInputSize);
                            boolean result = this.microphone.createInternalMicrophone(config, this.sampleRate, this.isStereo, this.echoCanceler, this.noiseSuppressor);
                            if (!result) {
                                throw new IllegalArgumentException("Failed to create internal audio source");
                            }
                        }
                    } else {
                        throw new IllegalStateException("Using internal audio in a invalid Android version. Android 10+ is necessary");
                    }
                    this.microphone.start();
                    break;
                }
                case 3: {
                    this.noSource.start();
                }
            }
        }
    }

    public final void stop() {
        if (this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: 
                case 2: {
                    this.microphone.stop();
                    break;
                }
                case 3: {
                    this.noSource.stop();
                }
            }
        }
    }

    @RequiresApi(value=29)
    public final void changeSourceInternal(@NotNull MediaProjection mediaProjection) {
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        if (this.source != Source.INTERNAL || this.mediaProjection == null) {
            this.mediaProjection = mediaProjection;
            boolean wasRunning = this.isRunning();
            this.stop();
            this.source = Source.INTERNAL;
            if (wasRunning) {
                this.start();
            }
        }
    }

    public final void changeSourceMicrophone() {
        if (this.source != Source.MICROPHONE) {
            boolean wasRunning = this.isRunning();
            this.stop();
            this.source = Source.MICROPHONE;
            MediaProjection mediaProjection = this.mediaProjection;
            if (mediaProjection != null) {
                mediaProjection.stop();
            }
            this.mediaProjection = null;
            if (wasRunning) {
                this.start();
            }
        }
    }

    public final void changeAudioSourceDisabled() {
        if (this.source != Source.DISABLED) {
            boolean wasRunning = this.isRunning();
            this.stop();
            this.source = Source.DISABLED;
            MediaProjection mediaProjection = this.mediaProjection;
            if (mediaProjection != null) {
                mediaProjection.stop();
            }
            this.mediaProjection = null;
            if (wasRunning) {
                this.start();
            }
        }
    }

    public final void mute() {
        if (this.source == Source.DISABLED) {
            return;
        }
        this.microphone.mute();
    }

    public final void unMute() {
        if (this.source == Source.DISABLED) {
            return;
        }
        this.microphone.unMute();
    }

    public final boolean isMuted() {
        return this.source == Source.DISABLED ? false : this.microphone.isMuted();
    }

    public final boolean isRunning() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
            case 1, 2 -> this.microphone.isRunning();
            case 3 -> this.noSource.isRunning();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final int getMaxInputSize() {
        return this.microphone.getMaxInputSize();
    }

    public final void setMaxInputSize(int size) {
        this.microphone.setMaxInputSize(size);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/pedro/rtplibrary/util/sources/AudioManager$Source;", "", "(Ljava/lang/String;I)V", "MICROPHONE", "DISABLED", "INTERNAL", "rtplibrary_release"})
    public static final class Source
    extends Enum<Source> {
        public static final /* enum */ Source MICROPHONE = new Source();
        public static final /* enum */ Source DISABLED = new Source();
        @RequiresApi(value=29)
        public static final /* enum */ Source INTERNAL = new Source();
        private static final /* synthetic */ Source[] $VALUES;

        public static Source[] values() {
            return (Source[])$VALUES.clone();
        }

        public static Source valueOf(String value) {
            return Enum.valueOf(Source.class, value);
        }

        static {
            $VALUES = sourceArray = new Source[]{Source.MICROPHONE, Source.DISABLED, Source.INTERNAL};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Source.values().length];
            try {
                nArray[Source.MICROPHONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Source.INTERNAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Source.DISABLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

