/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtmp;

import android.media.MediaCodec;
import androidx.annotation.Nullable;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtplibrary.base.OnlyAudioBase;
import java.nio.ByteBuffer;

public class RtmpOnlyAudio
extends OnlyAudioBase {
    private final RtmpClient rtmpClient;

    public RtmpOnlyAudio(ConnectCheckerRtmp connectChecker) {
        this.rtmpClient = new RtmpClient(connectChecker);
        this.rtmpClient.setOnlyAudio(true);
    }

    @Override
    public void resizeCache(int newSize) throws RuntimeException {
        this.rtmpClient.resizeCache(newSize);
    }

    @Override
    public int getCacheSize() {
        return this.rtmpClient.getCacheSize();
    }

    @Override
    public long getSentAudioFrames() {
        return this.rtmpClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.rtmpClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.rtmpClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.rtmpClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtmpClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtmpClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtmpClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtmpClient.resetDroppedVideoFrames();
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.rtmpClient.setAuthorization(user, password);
    }

    public void forceAkamaiTs(boolean enabled) {
        this.rtmpClient.forceAkamaiTs(enabled);
    }

    public void setWriteChunkSize(int chunkSize) {
        if (!this.isStreaming()) {
            this.rtmpClient.setWriteChunkSize(chunkSize);
        }
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtmpClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtmpClient.disconnect();
    }

    @Override
    public void setReTries(int reTries) {
        this.rtmpClient.setReTries(reTries);
    }

    @Override
    protected boolean shouldRetry(String reason) {
        return this.rtmpClient.shouldRetry(reason);
    }

    @Override
    public void reConnect(long delay, @Nullable String backupUrl) {
        this.rtmpClient.reConnect(delay, backupUrl);
    }

    @Override
    public boolean hasCongestion() {
        return this.rtmpClient.hasCongestion();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendAudio(aacBuffer, info);
    }

    @Override
    public void setLogs(boolean enable) {
        this.rtmpClient.setLogs(enable);
    }

    @Override
    public void setCheckServerAlive(boolean enable) {
        this.rtmpClient.setCheckServerAlive(enable);
    }
}

