/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.render.ManagerRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.rtplibrary.R;
import com.pedro.rtplibrary.util.Filter;
import com.pedro.rtplibrary.view.AspectRatioMode;
import com.pedro.rtplibrary.view.OpenGlViewBase;

@RequiresApi(api=18)
public class OpenGlView
extends OpenGlViewBase {
    private ManagerRender managerRender = null;
    private boolean loadAA = false;
    private boolean AAEnabled = false;
    private boolean keepAspectRatio = false;
    private AspectRatioMode aspectRatioMode = AspectRatioMode.Adjust;
    private boolean isFlipHorizontal = false;
    private boolean isFlipVertical = false;

    public OpenGlView(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenGlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.OpenGlView);
        try {
            this.keepAspectRatio = typedArray.getBoolean(R.styleable.OpenGlView_keepAspectRatio, false);
            this.aspectRatioMode = AspectRatioMode.fromId(typedArray.getInt(R.styleable.OpenGlView_aspectRatioMode, 0));
            this.AAEnabled = typedArray.getBoolean(R.styleable.OpenGlView_AAEnabled, false);
            ManagerRender.numFilters = typedArray.getInt(R.styleable.OpenGlView_numFilters, 0);
            this.isFlipHorizontal = typedArray.getBoolean(R.styleable.OpenGlView_isFlipHorizontal, false);
            this.isFlipVertical = typedArray.getBoolean(R.styleable.OpenGlView_isFlipVertical, false);
        }
        finally {
            typedArray.recycle();
        }
    }

    @Override
    public void init() {
        if (!this.initialized) {
            this.managerRender = new ManagerRender();
        }
        this.managerRender.setCameraFlip(this.isFlipHorizontal, this.isFlipVertical);
        this.initialized = true;
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.managerRender.getSurfaceTexture();
    }

    @Override
    public Surface getSurface() {
        return this.managerRender.getSurface();
    }

    @Override
    public void setFilter(int filterPosition, BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.SET_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void addFilter(BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.ADD, 0, baseFilterRender));
    }

    @Override
    public void addFilter(int filterPosition, BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.ADD_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void clearFilters() {
        this.filterQueue.add(new Filter(FilterAction.CLEAR, 0, null));
    }

    @Override
    public void removeFilter(int filterPosition) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE_INDEX, filterPosition, null));
    }

    @Override
    public void removeFilter(BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE, 0, baseFilterRender));
    }

    @Override
    public int filtersCount() {
        return this.managerRender.filtersCount();
    }

    @Override
    public void setFilter(BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(FilterAction.SET, 0, baseFilterRender));
    }

    @Override
    public void enableAA(boolean AAEnabled) {
        this.AAEnabled = AAEnabled;
        this.loadAA = true;
    }

    @Override
    public void setRotation(int rotation) {
        this.managerRender.setCameraRotation(rotation);
    }

    public boolean isKeepAspectRatio() {
        return this.keepAspectRatio;
    }

    public void setAspectRatioMode(AspectRatioMode aspectRatioMode) {
        this.aspectRatioMode = aspectRatioMode;
    }

    public void setKeepAspectRatio(boolean keepAspectRatio) {
        this.keepAspectRatio = keepAspectRatio;
    }

    public void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.managerRender.setCameraFlip(isFlipHorizontal, isFlipVertical);
    }

    @Override
    public boolean isAAEnabled() {
        return this.managerRender != null && this.managerRender.isAAEnabled();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.i((String)"OpenGlViewBase", (String)("size: " + width + "x" + height));
        this.previewWidth = width;
        this.previewHeight = height;
        if (this.managerRender != null) {
            this.managerRender.setPreviewSize(this.previewWidth, this.previewHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.surfaceManager.release();
        this.surfaceManager.eglSetup(this.getHolder().getSurface());
        this.surfaceManager.makeCurrent();
        this.managerRender.initGl(this.getContext(), this.encoderWidth, this.encoderHeight, this.previewWidth, this.previewHeight);
        this.managerRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.surfaceManagerPhoto.release();
        this.surfaceManagerPhoto.eglSetup(this.encoderWidth, this.encoderHeight, this.surfaceManager);
        this.semaphore.release();
        try {
            while (this.running) {
                Object filter;
                if (!this.frameAvailable && !this.forceRender) continue;
                this.frameAvailable = false;
                this.surfaceManager.makeCurrent();
                this.managerRender.updateFrame();
                this.managerRender.drawOffScreen();
                this.managerRender.drawScreen(this.previewWidth, this.previewHeight, this.keepAspectRatio, this.aspectRatioMode.id, 0, true, this.isPreviewVerticalFlip, this.isPreviewHorizontalFlip);
                this.surfaceManager.swapBuffer();
                if (!this.filterQueue.isEmpty()) {
                    filter = (Filter)this.filterQueue.take();
                    this.managerRender.setFilterAction(((Filter)filter).getFilterAction(), ((Filter)filter).getPosition(), ((Filter)filter).getBaseFilterRender());
                } else if (this.loadAA) {
                    this.managerRender.enableAA(this.AAEnabled);
                    this.loadAA = false;
                }
                filter = this.sync;
                synchronized (filter) {
                    if (this.surfaceManagerEncoder.isReady() && !this.fpsLimiter.limitFPS()) {
                        int w = this.muteVideo ? 0 : this.encoderWidth;
                        int h = this.muteVideo ? 0 : this.encoderHeight;
                        this.surfaceManagerEncoder.makeCurrent();
                        this.managerRender.drawScreen(w, h, false, this.aspectRatioMode.id, this.streamRotation, false, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
                        this.surfaceManagerEncoder.swapBuffer();
                    }
                    if (this.takePhotoCallback != null && this.surfaceManagerPhoto.isReady()) {
                        this.surfaceManagerPhoto.makeCurrent();
                        this.managerRender.drawScreen(this.encoderWidth, this.encoderHeight, false, this.aspectRatioMode.id, this.streamRotation, false, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
                        this.takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight));
                        this.takePhotoCallback = null;
                        this.surfaceManagerPhoto.swapBuffer();
                    }
                }
            }
            return;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            this.managerRender.release();
            this.surfaceManagerPhoto.release();
            this.surfaceManagerEncoder.release();
            this.surfaceManager.release();
        }
    }
}

