/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.audio.MicrophoneManagerManual;
import com.pedro.encoder.input.audio.MicrophoneMode;
import com.pedro.encoder.input.video.Camera1ApiManager;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.GetCameraData;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.util.FpsListener;
import com.pedro.rtplibrary.util.RecordController;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OffScreenGlThread;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class Camera1Base
implements GetAacData,
GetCameraData,
GetVideoData,
GetMicrophoneData {
    private static final String TAG = "Camera1Base";
    private final Context context;
    private final Camera1ApiManager cameraManager;
    protected VideoEncoder videoEncoder;
    private MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private GlInterface glInterface;
    private boolean streaming = false;
    private boolean audioInitialized = false;
    private boolean onPreview = false;
    protected RecordController recordController;
    private int previewWidth;
    private int previewHeight;
    private final FpsListener fpsListener = new FpsListener();

    public Camera1Base(SurfaceView surfaceView) {
        this.context = surfaceView.getContext();
        this.cameraManager = new Camera1ApiManager(surfaceView, (GetCameraData)this);
        this.init();
    }

    public Camera1Base(TextureView textureView) {
        this.context = textureView.getContext();
        this.cameraManager = new Camera1ApiManager(textureView, (GetCameraData)this);
        this.init();
    }

    @RequiresApi(api=18)
    public Camera1Base(OpenGlView openGlView) {
        this.context = openGlView.getContext();
        this.glInterface = openGlView;
        this.glInterface.init();
        this.cameraManager = new Camera1ApiManager(this.glInterface.getSurfaceTexture(), this.context);
        this.init();
    }

    @RequiresApi(api=18)
    public Camera1Base(LightOpenGlView lightOpenGlView) {
        this.context = lightOpenGlView.getContext();
        this.glInterface = lightOpenGlView;
        this.glInterface.init();
        this.cameraManager = new Camera1ApiManager(this.glInterface.getSurfaceTexture(), this.context);
        this.init();
    }

    @RequiresApi(api=18)
    public Camera1Base(Context context) {
        this.context = context;
        this.glInterface = new OffScreenGlThread(context);
        this.glInterface.init();
        this.cameraManager = new Camera1ApiManager(this.glInterface.getSurfaceTexture(), context);
        this.init();
    }

    private void init() {
        this.videoEncoder = new VideoEncoder((GetVideoData)this);
        this.setMicrophoneMode(MicrophoneMode.ASYNC);
        this.recordController = new RecordController();
    }

    public void setMicrophoneMode(MicrophoneMode microphoneMode) {
        switch (microphoneMode) {
            case SYNC: {
                this.microphoneManager = new MicrophoneManagerManual();
                this.audioEncoder = new AudioEncoder((GetAacData)this);
                this.audioEncoder.setGetFrame(((MicrophoneManagerManual)this.microphoneManager).getGetFrame());
                this.audioEncoder.setTsModeBuffer(false);
                break;
            }
            case ASYNC: {
                this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
                this.audioEncoder = new AudioEncoder((GetAacData)this);
                this.audioEncoder.setTsModeBuffer(false);
                break;
            }
            case BUFFER: {
                this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
                this.audioEncoder = new AudioEncoder((GetAacData)this);
                this.audioEncoder.setTsModeBuffer(true);
            }
        }
    }

    public void setCameraCallbacks(CameraCallbacks callbacks) {
        this.cameraManager.setCameraCallbacks(callbacks);
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.microphoneManager.setCustomAudioEffect(customAudioEffect);
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public boolean enableFaceDetection(Camera1ApiManager.FaceDetectorCallback faceDetectorCallback) {
        return this.cameraManager.enableFaceDetection(faceDetectorCallback);
    }

    public void disableFaceDetection() {
        this.cameraManager.disableFaceDetection();
    }

    public boolean isFaceDetectionEnabled() {
        return this.cameraManager.isFaceDetectionEnabled();
    }

    public boolean enableVideoStabilization() {
        return this.cameraManager.enableVideoStabilization();
    }

    public void disableVideoStabilization() {
        this.cameraManager.disableVideoStabilization();
    }

    public boolean isVideoStabilizationEnabled() {
        return this.cameraManager.isVideoStabilizationEnabled();
    }

    @Deprecated
    public boolean isFrontCamera() {
        return this.cameraManager.getCameraFacing() == CameraHelper.Facing.FRONT;
    }

    public CameraHelper.Facing getCameraFacing() {
        return this.cameraManager.getCameraFacing();
    }

    public void enableLantern() throws Exception {
        this.cameraManager.enableLantern();
    }

    public void disableLantern() {
        this.cameraManager.disableLantern();
    }

    public boolean isLanternEnabled() {
        return this.cameraManager.isLanternEnabled();
    }

    public void enableAutoFocus() {
        this.cameraManager.enableAutoFocus();
    }

    public void disableAutoFocus() {
        this.cameraManager.disableAutoFocus();
    }

    public boolean isAutoFocusEnabled() {
        return this.cameraManager.isAutoFocusEnabled();
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation, int avcProfile, int avcProfileLevel) {
        if (this.onPreview && width != this.previewWidth || height != this.previewHeight || fps != this.videoEncoder.getFps()) {
            this.stopPreview();
            this.onPreview = true;
        }
        FormatVideoEncoder formatVideoEncoder = this.glInterface == null ? FormatVideoEncoder.YUV420Dynamical : FormatVideoEncoder.SURFACE;
        return this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, formatVideoEncoder, avcProfile, avcProfileLevel);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, iFrameInterval, rotation, -1, -1);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, 2, rotation);
    }

    public boolean prepareVideo(int width, int height, int bitrate) {
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(width, height, 30, bitrate, 2, rotation);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int audioSource, int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        if (!this.microphoneManager.createMicrophone(audioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor)) {
            return false;
        }
        this.prepareAudioRtp(isStereo, sampleRate);
        this.audioInitialized = this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo, this.microphoneManager.getMaxInputSize());
        return this.audioInitialized;
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        return this.prepareAudio(0, bitrate, sampleRate, isStereo, echoCanceler, noiseSuppressor);
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo) {
        return this.prepareAudio(bitrate, sampleRate, isStereo, false, false);
    }

    public boolean prepareVideo() {
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(640, 480, 30, 1228800, rotation);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    @RequiresApi(api=18)
    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=18)
    public void startRecord(@NonNull String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(fd, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    @RequiresApi(api=18)
    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    @RequiresApi(api=18)
    public void replaceView(Context context) {
        if (Build.VERSION.SDK_INT >= 18) {
            this.replaceGlInterface(new OffScreenGlThread(context));
        }
    }

    @RequiresApi(api=18)
    public void replaceView(OpenGlView openGlView) {
        this.replaceGlInterface(openGlView);
    }

    @RequiresApi(api=18)
    public void replaceView(LightOpenGlView lightOpenGlView) {
        this.replaceGlInterface(lightOpenGlView);
    }

    @RequiresApi(api=18)
    private void replaceGlInterface(GlInterface glInterface) {
        if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
            if (this.isStreaming() || this.isRecording() || this.isOnPreview()) {
                Point size = this.glInterface.getEncoderSize();
                this.cameraManager.stop();
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
                this.glInterface = glInterface;
                this.glInterface.init();
                this.glInterface.setEncoderSize(size.x, size.y);
                this.glInterface.setRotation(0);
                this.glInterface.start();
                if (this.isStreaming() || this.isRecording()) {
                    this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
                }
                this.cameraManager.setSurfaceTexture(glInterface.getSurfaceTexture());
                this.cameraManager.setRotation(this.videoEncoder.getRotation());
                this.cameraManager.start(this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getFps());
            } else {
                this.glInterface = glInterface;
                this.glInterface.init();
            }
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height, int fps, int rotation) {
        if (!(this.isStreaming() || this.onPreview || this.glInterface instanceof OffScreenGlThread)) {
            this.previewWidth = width;
            this.previewHeight = height;
            this.videoEncoder.setFps(fps);
            if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                boolean isPortrait = CameraHelper.isPortrait((Context)this.context);
                if (isPortrait) {
                    this.glInterface.setEncoderSize(height, width);
                } else {
                    this.glInterface.setEncoderSize(width, height);
                }
                this.glInterface.setRotation(0);
                this.glInterface.setFps(fps);
                this.glInterface.start();
                this.cameraManager.setSurfaceTexture(this.glInterface.getSurfaceTexture());
            }
            this.cameraManager.setRotation(rotation);
            this.cameraManager.start(cameraFacing, width, height, this.videoEncoder.getFps());
            this.onPreview = true;
        } else if (!this.isStreaming() && !this.onPreview && this.glInterface instanceof OffScreenGlThread) {
            this.cameraManager.setCameraFacing(cameraFacing);
        } else {
            Log.e((String)TAG, (String)"Streaming or preview started, ignored");
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height, int rotation) {
        this.startPreview(cameraFacing, width, height, this.videoEncoder.getFps(), rotation);
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height) {
        this.startPreview(cameraFacing, width, height, CameraHelper.getCameraOrientation((Context)this.context));
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int rotation) {
        this.startPreview(cameraFacing, this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), rotation);
    }

    public void startPreview(CameraHelper.Facing cameraFacing) {
        this.startPreview(cameraFacing, this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
    }

    public void startPreview(int width, int height) {
        this.startPreview(this.getCameraFacing(), width, height);
    }

    public void startPreview() {
        this.startPreview(this.getCameraFacing());
    }

    public void stopPreview() {
        if (!this.isStreaming() && !this.isRecording() && this.onPreview && !(this.glInterface instanceof OffScreenGlThread)) {
            if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                this.glInterface.stop();
            }
            this.cameraManager.stop();
            this.onPreview = false;
            this.previewWidth = 0;
            this.previewHeight = 0;
        } else {
            Log.e((String)TAG, (String)"Streaming or preview stopped, ignored");
        }
    }

    public void setPreviewOrientation(int orientation) {
        this.cameraManager.setPreviewOrientation(orientation);
    }

    public void setZoom(MotionEvent event) {
        this.cameraManager.setZoom(event);
    }

    public void setZoom(int level) {
        this.cameraManager.setZoom(level);
    }

    public float getZoom() {
        return this.cameraManager.getZoom();
    }

    public int getMaxZoom() {
        return this.cameraManager.getMaxZoom();
    }

    public int getMinZoom() {
        return this.cameraManager.getMinZoom();
    }

    @RequiresApi(api=18)
    public void startStreamAndRecord(String url, String path, RecordController.Listener listener) throws IOException {
        this.startStream(url);
        this.recordController.startRecord(path, listener);
    }

    @RequiresApi(api=18)
    public void startStreamAndRecord(String url, String path) throws IOException {
        this.startStreamAndRecord(url, path, null);
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else {
            this.requestKeyFrame();
        }
        this.startStreamRtp(url);
        this.onPreview = true;
    }

    private void startEncoders() {
        this.videoEncoder.start();
        if (this.audioInitialized) {
            this.audioEncoder.start();
        }
        this.prepareGlView();
        if (this.audioInitialized) {
            this.microphoneManager.start();
        }
        this.cameraManager.setRotation(this.videoEncoder.getRotation());
        if (!this.cameraManager.isRunning() && this.videoEncoder.getWidth() != this.previewWidth || this.videoEncoder.getHeight() != this.previewHeight) {
            this.cameraManager.start(this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getFps());
        }
        this.onPreview = true;
    }

    public void requestKeyFrame() {
        if (this.videoEncoder.isRunning()) {
            if (Build.VERSION.SDK_INT >= 19) {
                this.videoEncoder.requestKeyframe();
            } else {
                if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                    this.glInterface.removeMediaCodecSurface();
                }
                this.videoEncoder.reset();
                if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                    this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
                }
            }
        }
    }

    private void prepareGlView() {
        if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
            this.glInterface.setFps(this.videoEncoder.getFps());
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.glInterface.setRotation(0);
            if (!this.cameraManager.isRunning() && this.videoEncoder.getWidth() != this.previewWidth || this.videoEncoder.getHeight() != this.previewHeight) {
                this.glInterface.start();
            }
            if (this.videoEncoder.getInputSurface() != null) {
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
            this.cameraManager.setSurfaceTexture(this.glInterface.getSurfaceTexture());
        }
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recordController.isRecording()) {
            if (this.audioInitialized) {
                this.microphoneManager.stop();
            }
            if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                this.glInterface.removeMediaCodecSurface();
                if (this.glInterface instanceof OffScreenGlThread) {
                    this.glInterface.stop();
                    this.cameraManager.stop();
                    this.onPreview = false;
                }
            }
            this.videoEncoder.stop();
            if (this.audioInitialized) {
                this.audioEncoder.stop();
            }
            this.recordController.resetFormats();
        }
    }

    public boolean reTry(long delay, String reason, @Nullable String backupUrl) {
        boolean result = this.shouldRetry(reason);
        if (result) {
            this.requestKeyFrame();
            this.reConnect(delay, backupUrl);
        }
        return result;
    }

    public boolean reTry(long delay, String reason) {
        return this.reTry(delay, reason, null);
    }

    protected abstract boolean shouldRetry(String var1);

    public abstract void setReTries(int var1);

    protected abstract void reConnect(long var1, @Nullable String var3);

    public abstract boolean hasCongestion();

    public abstract void resizeCache(int var1) throws RuntimeException;

    public abstract int getCacheSize();

    public abstract long getSentAudioFrames();

    public abstract long getSentVideoFrames();

    public abstract long getDroppedAudioFrames();

    public abstract long getDroppedVideoFrames();

    public abstract void resetSentAudioFrames();

    public abstract void resetSentVideoFrames();

    public abstract void resetDroppedAudioFrames();

    public abstract void resetDroppedVideoFrames();

    public List<Camera.Size> getResolutionsBack() {
        return this.cameraManager.getPreviewSizeBack();
    }

    public List<Camera.Size> getResolutionsFront() {
        return this.cameraManager.getPreviewSizeFront();
    }

    public List<int[]> getSupportedFps() {
        return this.cameraManager.getSupportedFps();
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    public void switchCamera() throws CameraOpenException {
        if (this.isStreaming() || this.onPreview) {
            this.cameraManager.switchCamera();
        } else {
            this.cameraManager.setCameraFacing(this.getCameraFacing() == CameraHelper.Facing.FRONT ? CameraHelper.Facing.BACK : CameraHelper.Facing.FRONT);
        }
    }

    public void setExposure(int value) {
        this.cameraManager.setExposure(value);
    }

    public int getExposure() {
        return this.cameraManager.getExposure();
    }

    public int getMaxExposure() {
        return this.cameraManager.getMaxExposure();
    }

    public int getMinExposure() {
        return this.cameraManager.getMinExposure();
    }

    public void tapToFocus(View view, MotionEvent event) {
        this.cameraManager.tapToFocus(view, event);
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void setLimitFPSOnFly(int fps) {
        this.videoEncoder.setFps(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isOnPreview() {
        return this.onPreview;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        if (Build.VERSION.SDK_INT >= 18) {
            this.recordController.recordAudio(aacBuffer, info);
        }
        if (this.streaming) {
            this.getAacDataRtp(aacBuffer, info);
        }
    }

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    public void onSpsPpsVps(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.onSpsPpsVpsRtp(sps.duplicate(), pps.duplicate(), vps != null ? vps.duplicate() : null);
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getVideoData(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.fpsListener.calculateFps();
        if (Build.VERSION.SDK_INT >= 18) {
            this.recordController.recordVideo(h264Buffer, info);
        }
        if (this.streaming) {
            this.getH264DataRtp(h264Buffer, info);
        }
    }

    public void inputPCMData(Frame frame) {
        this.audioEncoder.inputPCMData(frame);
    }

    public void inputYUVData(Frame frame) {
        this.videoEncoder.inputYUVData(frame);
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.recordController.setVideoFormat(mediaFormat, !this.audioInitialized);
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.recordController.setAudioFormat(mediaFormat);
    }

    public abstract void setLogs(boolean var1);

    public abstract void setCheckServerAlive(boolean var1);
}

