/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.view;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.ManagerRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.rtplibrary.view.Filter;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.TakePhotoCallback;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

@RequiresApi(api=18)
public class OffScreenGlThread
implements GlInterface,
Runnable,
SurfaceTexture.OnFrameAvailableListener {
    private final Context context;
    private Thread thread = null;
    private boolean frameAvailable = false;
    private boolean running = true;
    private boolean initialized = false;
    private final SurfaceManager surfaceManagerPhoto = new SurfaceManager();
    private final SurfaceManager surfaceManager = new SurfaceManager();
    private final SurfaceManager surfaceManagerEncoder = new SurfaceManager();
    private ManagerRender managerRender = null;
    private final Semaphore semaphore = new Semaphore(0);
    private final BlockingQueue<Filter> filterQueue = new LinkedBlockingQueue<Filter>();
    private final Object sync = new Object();
    private int encoderWidth;
    private int encoderHeight;
    private boolean loadAA = false;
    private int streamRotation;
    private boolean muteVideo = false;
    protected boolean isPreviewHorizontalFlip = false;
    protected boolean isPreviewVerticalFlip = false;
    private boolean isStreamHorizontalFlip = false;
    private boolean isStreamVerticalFlip = false;
    private boolean AAEnabled = false;
    private final FpsLimiter fpsLimiter = new FpsLimiter();
    private TakePhotoCallback takePhotoCallback;
    private boolean forceRender = false;

    public OffScreenGlThread(Context context) {
        this.context = context;
    }

    @Override
    public void init() {
        if (!this.initialized) {
            this.managerRender = new ManagerRender();
        }
        this.managerRender.setCameraFlip(false, false);
        this.initialized = true;
    }

    @Override
    public void setForceRender(boolean forceRender) {
        this.forceRender = forceRender;
    }

    @Override
    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    @Override
    public void muteVideo() {
        this.muteVideo = true;
    }

    @Override
    public void unMuteVideo() {
        this.muteVideo = false;
    }

    @Override
    public boolean isVideoMuted() {
        return this.muteVideo;
    }

    @Override
    public void setFps(int fps) {
        this.fpsLimiter.setFPS(fps);
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.managerRender.getSurfaceTexture();
    }

    @Override
    public Surface getSurface() {
        return this.managerRender.getSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaCodecSurface(Surface surface) {
        Object object = this.sync;
        synchronized (object) {
            if (this.surfaceManager.isReady()) {
                this.surfaceManagerPhoto.release();
                this.surfaceManagerEncoder.release();
                this.surfaceManagerEncoder.eglSetup(surface, this.surfaceManager);
                this.surfaceManagerPhoto.eglSetup(this.encoderWidth, this.encoderHeight, this.surfaceManagerEncoder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaCodecSurface() {
        Object object = this.sync;
        synchronized (object) {
            this.surfaceManagerPhoto.release();
            this.surfaceManagerEncoder.release();
            this.surfaceManagerPhoto.eglSetup(this.encoderWidth, this.encoderHeight, this.surfaceManager);
        }
    }

    @Override
    public void takePhoto(TakePhotoCallback takePhotoCallback) {
        this.takePhotoCallback = takePhotoCallback;
    }

    @Override
    public void setFilter(int filterPosition, BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(filterPosition, baseFilterRender));
    }

    @Override
    public void setFilter(BaseFilterRender baseFilterRender) {
        this.setFilter(0, baseFilterRender);
    }

    @Override
    public void enableAA(boolean AAEnabled) {
        this.AAEnabled = AAEnabled;
        this.loadAA = true;
    }

    @Override
    public void setRotation(int rotation) {
        this.managerRender.setCameraRotation(rotation);
    }

    @Override
    public void setStreamRotation(int rotation) {
        this.streamRotation = rotation;
    }

    @Override
    public void setIsStreamHorizontalFlip(boolean flip) {
        this.isStreamHorizontalFlip = flip;
    }

    @Override
    public void setIsStreamVerticalFlip(boolean flip) {
        this.isStreamVerticalFlip = flip;
    }

    @Override
    public void setIsPreviewHorizontalFlip(boolean flip) {
        this.isPreviewHorizontalFlip = flip;
    }

    @Override
    public void setIsPreviewVerticalFlip(boolean flip) {
        this.isPreviewVerticalFlip = flip;
    }

    @Override
    public boolean isAAEnabled() {
        return this.managerRender != null && this.managerRender.isAAEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.sync;
        synchronized (object) {
            this.thread = new Thread(this);
            this.running = true;
            this.thread.start();
            this.semaphore.acquireUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            if (this.thread != null) {
                this.thread.interrupt();
                try {
                    this.thread.join(100L);
                }
                catch (InterruptedException e) {
                    this.thread.interrupt();
                }
                this.thread = null;
            }
            this.surfaceManagerPhoto.release();
            this.surfaceManagerEncoder.release();
            this.surfaceManager.release();
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.surfaceManager.release();
        this.surfaceManager.eglSetup();
        this.surfaceManager.makeCurrent();
        this.managerRender.initGl(this.context, this.encoderWidth, this.encoderHeight, this.encoderWidth, this.encoderHeight);
        this.managerRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.surfaceManagerPhoto.release();
        this.surfaceManagerPhoto.eglSetup(this.encoderWidth, this.encoderHeight, this.surfaceManager);
        this.semaphore.release();
        try {
            while (this.running) {
                if (!this.frameAvailable && !this.forceRender) continue;
                this.frameAvailable = false;
                this.surfaceManager.makeCurrent();
                this.managerRender.updateFrame();
                this.managerRender.drawOffScreen();
                this.managerRender.drawScreen(this.encoderWidth, this.encoderHeight, false, 0, 0, true, this.isPreviewVerticalFlip, this.isPreviewHorizontalFlip);
                this.surfaceManager.swapBuffer();
                Object object = this.sync;
                synchronized (object) {
                    if (this.surfaceManagerEncoder.isReady() && !this.fpsLimiter.limitFPS()) {
                        int w = this.muteVideo ? 0 : this.encoderWidth;
                        int h = this.muteVideo ? 0 : this.encoderHeight;
                        this.surfaceManagerEncoder.makeCurrent();
                        this.managerRender.drawScreen(w, h, false, 0, this.streamRotation, false, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
                        this.surfaceManagerEncoder.swapBuffer();
                    }
                    if (this.takePhotoCallback != null && this.surfaceManagerPhoto.isReady()) {
                        this.surfaceManagerPhoto.makeCurrent();
                        this.managerRender.drawScreen(this.encoderWidth, this.encoderHeight, false, 0, this.streamRotation, false, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
                        this.takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight));
                        this.takePhotoCallback = null;
                        this.surfaceManagerPhoto.swapBuffer();
                    }
                }
                if (!this.filterQueue.isEmpty()) {
                    Filter filter = this.filterQueue.take();
                    this.managerRender.setFilter(filter.getPosition(), filter.getBaseFilterRender());
                    continue;
                }
                if (!this.loadAA) continue;
                this.managerRender.enableAA(this.AAEnabled);
                this.loadAA = false;
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.managerRender.release();
            this.surfaceManager.release();
            this.surfaceManagerPhoto.release();
            this.surfaceManagerEncoder.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        Object object = this.sync;
        synchronized (object) {
            this.frameAvailable = true;
            this.sync.notifyAll();
        }
    }
}

