/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtmp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.rtmp.flv.video.ProfileIop;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtplibrary.base.DisplayBase;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class RtmpDisplay
extends DisplayBase {
    private final RtmpClient rtmpClient;

    public RtmpDisplay(Context context, boolean useOpengl, ConnectCheckerRtmp connectChecker) {
        super(context, useOpengl);
        this.rtmpClient = new RtmpClient(connectChecker);
    }

    public void setProfileIop(ProfileIop profileIop) {
        this.rtmpClient.setProfileIop(profileIop);
    }

    @Override
    public void resizeCache(int newSize) throws RuntimeException {
        this.rtmpClient.resizeCache(newSize);
    }

    @Override
    public int getCacheSize() {
        return this.rtmpClient.getCacheSize();
    }

    @Override
    public long getSentAudioFrames() {
        return this.rtmpClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.rtmpClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.rtmpClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.rtmpClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtmpClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtmpClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtmpClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtmpClient.resetDroppedVideoFrames();
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.rtmpClient.setAuthorization(user, password);
    }

    public void forceAkamaiTs(boolean enabled) {
        this.rtmpClient.forceAkamaiTs(enabled);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            this.rtmpClient.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            this.rtmpClient.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        this.rtmpClient.setFps(this.videoEncoder.getFps());
        this.rtmpClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtmpClient.disconnect();
    }

    @Override
    public void setReTries(int reTries) {
        this.rtmpClient.setReTries(reTries);
    }

    @Override
    protected boolean shouldRetry(String reason) {
        return this.rtmpClient.shouldRetry(reason);
    }

    @Override
    public void reConnect(long delay, @Nullable String backupUrl) {
        this.rtmpClient.reConnect(delay, backupUrl);
    }

    @Override
    public boolean hasCongestion() {
        return this.rtmpClient.hasCongestion();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.rtmpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendVideo(h264Buffer, info);
    }

    @Override
    public void setLogs(boolean enable) {
        this.rtmpClient.setLogs(enable);
    }
}

