/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.multiple;

import android.media.MediaCodec;
import androidx.annotation.Nullable;
import com.pedro.rtmp.flv.video.ProfileIop;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtplibrary.base.OnlyAudioBase;
import com.pedro.rtplibrary.multiple.RtpType;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.nio.ByteBuffer;

public class MultiRtpOnlyAudio
extends OnlyAudioBase {
    private final RtmpClient[] rtmpClients;
    private final RtspClient[] rtspClients;

    public MultiRtpOnlyAudio(ConnectCheckerRtmp[] connectCheckerRtmpList, ConnectCheckerRtsp[] connectCheckerRtspList) {
        int rtmpSize = connectCheckerRtmpList != null ? connectCheckerRtmpList.length : 0;
        this.rtmpClients = new RtmpClient[rtmpSize];
        for (int i = 0; i < this.rtmpClients.length; ++i) {
            this.rtmpClients[i] = new RtmpClient(connectCheckerRtmpList[i]);
            this.rtmpClients[i].setOnlyAudio(true);
        }
        int rtspSize = connectCheckerRtspList != null ? connectCheckerRtspList.length : 0;
        this.rtspClients = new RtspClient[rtspSize];
        for (int i = 0; i < this.rtspClients.length; ++i) {
            this.rtspClients[i] = new RtspClient(connectCheckerRtspList[i]);
            this.rtspClients[i].setOnlyAudio(true);
        }
    }

    public boolean isStreaming(RtpType rtpType, int index) {
        if (rtpType == RtpType.RTMP) {
            return this.rtmpClients[index].isStreaming();
        }
        return this.rtspClients[index].isStreaming();
    }

    public void setProfileIop(ProfileIop profileIop, int index) {
        this.rtmpClients[index].setProfileIop(profileIop);
    }

    public void resizeCache(RtpType rtpType, int index, int newSize) {
        if (rtpType == RtpType.RTMP) {
            this.rtmpClients[index].resizeCache(newSize);
        } else {
            this.rtspClients[index].resizeCache(newSize);
        }
    }

    @Override
    public void resizeCache(int newSize) throws RuntimeException {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.resizeCache(newSize);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.resizeCache(newSize);
        }
    }

    public int getCacheSize(RtpType rtpType, int index) {
        if (rtpType == RtpType.RTMP) {
            return this.rtmpClients[index].getCacheSize();
        }
        return this.rtspClients[index].getCacheSize();
    }

    @Override
    public int getCacheSize() {
        return 0;
    }

    @Override
    public long getSentAudioFrames() {
        long number = 0L;
        for (RtmpClient rtmpClient : this.rtmpClients) {
            number += rtmpClient.getSentAudioFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            number += rtmpClient.getSentAudioFrames();
        }
        return number;
    }

    @Override
    public long getSentVideoFrames() {
        long number = 0L;
        for (RtmpClient rtmpClient : this.rtmpClients) {
            number += rtmpClient.getSentVideoFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            number += rtmpClient.getSentVideoFrames();
        }
        return number;
    }

    @Override
    public long getDroppedAudioFrames() {
        long number = 0L;
        for (RtmpClient rtmpClient : this.rtmpClients) {
            number += rtmpClient.getDroppedAudioFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            number += rtmpClient.getDroppedAudioFrames();
        }
        return number;
    }

    @Override
    public long getDroppedVideoFrames() {
        long number = 0L;
        for (RtmpClient rtmpClient : this.rtmpClients) {
            number += rtmpClient.getDroppedVideoFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            number += rtmpClient.getDroppedVideoFrames();
        }
        return number;
    }

    @Override
    public void resetSentAudioFrames() {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.resetSentAudioFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.resetSentAudioFrames();
        }
    }

    @Override
    public void resetSentVideoFrames() {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.resetSentVideoFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.resetSentVideoFrames();
        }
    }

    @Override
    public void resetDroppedAudioFrames() {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.resetDroppedAudioFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.resetDroppedAudioFrames();
        }
    }

    @Override
    public void resetDroppedVideoFrames() {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.resetDroppedVideoFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.resetDroppedVideoFrames();
        }
    }

    public void setAuthorization(RtpType rtpType, int index, String user, String password) {
        if (rtpType == RtpType.RTMP) {
            this.rtmpClients[index].setAuthorization(user, password);
        } else {
            this.rtspClients[index].setAuthorization(user, password);
        }
    }

    @Override
    public void setAuthorization(String user, String password) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setAuthorization(user, password);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setAuthorization(user, password);
        }
    }

    public void forceAkamaiTs(boolean enabled) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.forceAkamaiTs(enabled);
        }
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setAudioInfo(sampleRate, isStereo);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setAudioInfo(sampleRate, isStereo);
        }
    }

    public void startStream(RtpType rtpType, int index, String url) {
        boolean shouldStarEncoder = true;
        for (RtmpClient rtmpClient : this.rtmpClients) {
            if (!rtmpClient.isStreaming()) continue;
            shouldStarEncoder = false;
            break;
        }
        if (shouldStarEncoder) {
            for (RtmpClient rtmpClient : this.rtspClients) {
                if (!rtmpClient.isStreaming()) continue;
                shouldStarEncoder = false;
                break;
            }
        }
        if (shouldStarEncoder) {
            super.startStream("");
        }
        if (rtpType == RtpType.RTMP) {
            this.rtmpClients[index].connect(url);
        } else {
            this.rtspClients[index].connect(url);
        }
    }

    @Override
    protected void startStreamRtp(String url) {
    }

    public void stopStream(RtpType rtpType, int index) {
        boolean shouldStopEncoder = true;
        if (rtpType == RtpType.RTMP) {
            this.rtmpClients[index].disconnect();
        } else {
            this.rtspClients[index].disconnect();
        }
        for (RtmpClient rtmpClient : this.rtmpClients) {
            if (!rtmpClient.isStreaming()) continue;
            shouldStopEncoder = false;
            break;
        }
        if (shouldStopEncoder) {
            for (RtmpClient rtmpClient : this.rtspClients) {
                if (!rtmpClient.isStreaming()) continue;
                shouldStopEncoder = false;
                break;
            }
        }
        if (shouldStopEncoder) {
            super.stopStream();
        }
    }

    @Override
    protected void stopStreamRtp() {
    }

    @Override
    public void setReTries(int reTries) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setReTries(reTries);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setReTries(reTries);
        }
    }

    public boolean reTry(RtpType rtpType, int index, long delay, String reason, @Nullable String backupUrl) {
        boolean result;
        if (rtpType == RtpType.RTMP) {
            result = this.rtmpClients[index].shouldRetry(reason);
            if (result) {
                this.rtmpClients[index].reConnect(delay, backupUrl);
            }
        } else {
            result = this.rtspClients[index].shouldRetry(reason);
            if (result) {
                this.rtmpClients[index].reConnect(delay, backupUrl);
            }
        }
        return result;
    }

    @Override
    protected boolean shouldRetry(String reason) {
        return false;
    }

    @Override
    protected void reConnect(long delay, @Nullable String backupUrl) {
    }

    public boolean hasCongestion(RtpType rtpType, int index) {
        if (rtpType == RtpType.RTMP) {
            return this.rtmpClients[index].hasCongestion();
        }
        return this.rtspClients[index].hasCongestion();
    }

    @Override
    public boolean hasCongestion() {
        return false;
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.sendAudio(aacBuffer.duplicate(), info);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.sendAudio(aacBuffer.duplicate(), info);
        }
    }

    @Override
    public void setLogs(boolean enable) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setLogs(enable);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setLogs(enable);
        }
    }
}

