/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.view;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.rtplibrary.view.Filter;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.TakePhotoCallback;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

@RequiresApi(api=18)
public abstract class OpenGlViewBase
extends SurfaceView
implements GlInterface,
Runnable,
SurfaceTexture.OnFrameAvailableListener,
SurfaceHolder.Callback {
    public static final String TAG = "OpenGlViewBase";
    protected Thread thread = null;
    protected boolean frameAvailable = false;
    protected boolean running = false;
    protected boolean initialized = false;
    protected SurfaceManager surfaceManagerPhoto = null;
    protected SurfaceManager surfaceManager = null;
    protected SurfaceManager surfaceManagerEncoder = null;
    protected FpsLimiter fpsLimiter = new FpsLimiter();
    protected final Semaphore semaphore = new Semaphore(0);
    protected final BlockingQueue<Filter> filterQueue = new LinkedBlockingQueue<Filter>();
    protected final Object sync = new Object();
    protected int previewWidth;
    protected int previewHeight;
    protected int encoderWidth;
    protected int encoderHeight;
    protected TakePhotoCallback takePhotoCallback;
    protected int streamRotation;
    protected boolean muteVideo = false;
    protected boolean isStreamHorizontalFlip = false;
    protected boolean isStreamVerticalFlip = false;
    protected boolean forceRender = false;

    public OpenGlViewBase(Context context) {
        super(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public OpenGlViewBase(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    @Override
    public void setForceRender(boolean forceRender) {
        this.forceRender = forceRender;
    }

    @Override
    public void setStreamRotation(int streamRotation) {
        this.streamRotation = streamRotation;
    }

    @Override
    public void setIsStreamHorizontalFlip(boolean flip) {
        this.isStreamHorizontalFlip = flip;
    }

    @Override
    public void setIsStreamVerticalFlip(boolean flip) {
        this.isStreamVerticalFlip = flip;
    }

    @Override
    public void muteVideo() {
        this.muteVideo = true;
    }

    @Override
    public void unMuteVideo() {
        this.muteVideo = false;
    }

    @Override
    public boolean isVideoMuted() {
        return this.muteVideo;
    }

    @Override
    public abstract void init();

    @Override
    public abstract SurfaceTexture getSurfaceTexture();

    @Override
    public abstract Surface getSurface();

    @Override
    public void setFps(int fps) {
        this.fpsLimiter.setFPS(fps);
    }

    @Override
    public void takePhoto(TakePhotoCallback takePhotoCallback) {
        this.takePhotoCallback = takePhotoCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaCodecSurface(Surface surface) {
        Object object = this.sync;
        synchronized (object) {
            if (this.surfaceManagerPhoto != null) {
                this.surfaceManagerPhoto.release();
                this.surfaceManagerPhoto = null;
            }
            if (this.surfaceManager != null) {
                this.surfaceManagerEncoder = new SurfaceManager(surface, this.surfaceManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaCodecSurface() {
        Object object = this.sync;
        synchronized (object) {
            if (this.surfaceManagerEncoder != null) {
                this.surfaceManagerEncoder.release();
                this.surfaceManagerEncoder = null;
            }
            if (this.surfaceManagerPhoto == null && this.surfaceManager != null) {
                this.surfaceManagerPhoto = new SurfaceManager(this.encoderWidth, this.encoderHeight, this.surfaceManager);
            }
        }
    }

    @Override
    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.sync;
        synchronized (object) {
            Log.i((String)TAG, (String)"Thread started.");
            this.thread = new Thread((Runnable)this, "glThread");
            this.running = true;
            this.thread.start();
            this.semaphore.acquireUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            if (this.thread != null) {
                this.thread.interrupt();
                try {
                    this.thread.join(100L);
                }
                catch (InterruptedException e) {
                    this.thread.interrupt();
                }
                this.thread = null;
            }
            this.running = false;
        }
    }

    protected void releaseSurfaceManager() {
        if (this.surfaceManager != null) {
            this.surfaceManager.release();
            this.surfaceManager = null;
        }
        if (this.surfaceManagerPhoto != null) {
            this.surfaceManagerPhoto.release();
            this.surfaceManagerPhoto = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        Object object = this.sync;
        synchronized (object) {
            this.frameAvailable = true;
            this.sync.notifyAll();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.stop();
    }
}

