/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.video.Camera2ApiManager;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.util.FpsListener;
import com.pedro.rtplibrary.util.RecordController;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OffScreenGlThread;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=21)
public abstract class Camera2Base
implements GetAacData,
GetVideoData,
GetMicrophoneData {
    protected Context context;
    private Camera2ApiManager cameraManager;
    protected VideoEncoder videoEncoder;
    private MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private boolean streaming = false;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private GlInterface glInterface;
    private boolean videoEnabled = false;
    private boolean onPreview = false;
    private boolean isBackground = false;
    protected RecordController recordController;
    private int previewWidth;
    private int previewHeight;
    private FpsListener fpsListener = new FpsListener();

    @Deprecated
    public Camera2Base(SurfaceView surfaceView) {
        this.surfaceView = surfaceView;
        this.context = surfaceView.getContext();
        this.init(this.context);
    }

    @Deprecated
    public Camera2Base(TextureView textureView) {
        this.textureView = textureView;
        this.context = textureView.getContext();
        this.init(this.context);
    }

    public Camera2Base(OpenGlView openGlView) {
        this.context = openGlView.getContext();
        this.glInterface = openGlView;
        this.glInterface.init();
        this.init(this.context);
    }

    public Camera2Base(LightOpenGlView lightOpenGlView) {
        this.context = lightOpenGlView.getContext();
        this.glInterface = lightOpenGlView;
        this.glInterface.init();
        this.init(this.context);
    }

    public Camera2Base(Context context, boolean useOpengl) {
        this.context = context;
        if (useOpengl) {
            this.glInterface = new OffScreenGlThread(context);
            this.glInterface.init();
        }
        this.isBackground = true;
        this.init(context);
    }

    private void init(Context context) {
        this.cameraManager = new Camera2ApiManager(context);
        this.videoEncoder = new VideoEncoder((GetVideoData)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.recordController = new RecordController();
    }

    public void setCameraCallbacks(CameraCallbacks callbacks) {
        this.cameraManager.setCameraCallbacks(callbacks);
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.microphoneManager.setCustomAudioEffect(customAudioEffect);
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public void enableFaceDetection(Camera2ApiManager.FaceDetectorCallback faceDetectorCallback) {
        this.cameraManager.enableFaceDetection(faceDetectorCallback);
    }

    public void disableFaceDetection() {
        this.cameraManager.disableFaceDetection();
    }

    public boolean isFaceDetectionEnabled() {
        return this.cameraManager.isFaceDetectionEnabled();
    }

    public boolean isFrontCamera() {
        return this.cameraManager.isFrontCamera();
    }

    public void enableLantern() throws Exception {
        this.cameraManager.enableLantern();
    }

    public void disableLantern() {
        this.cameraManager.disableLantern();
    }

    public boolean isLanternEnabled() {
        return this.cameraManager.isLanternEnabled();
    }

    public boolean isLanternSupported() {
        return this.cameraManager.isLanternSupported();
    }

    public void enableAutoFocus() {
        this.cameraManager.enableAutoFocus();
    }

    public void disableAutoFocus() {
        this.cameraManager.disableAutoFocus();
    }

    public boolean isAutoFocusEnabled() {
        return this.cameraManager.isAutoFocusEnabled();
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation, int avcProfile, int avcProfileLevel) {
        if (this.onPreview && (this.glInterface == null || width != this.previewWidth || height != this.previewHeight)) {
            this.stopPreview();
            this.onPreview = true;
        }
        boolean result = this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, FormatVideoEncoder.SURFACE, avcProfile, avcProfileLevel);
        this.prepareCameraManager();
        return result;
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, iFrameInterval, rotation, -1, -1);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, 2, rotation);
    }

    public boolean prepareVideo(int width, int height, int bitrate) {
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(width, height, 30, bitrate, 2, rotation);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.microphoneManager.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        this.prepareAudioRtp(isStereo, sampleRate);
        return this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo, this.microphoneManager.getMaxInputSize());
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo) {
        return this.prepareAudio(bitrate, sampleRate, isStereo, false, false);
    }

    public boolean prepareVideo() {
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(1280, 720, 30, 1228800, rotation);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.resetVideoEncoder();
        }
    }

    public void startRecord(@NonNull String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(fd, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.resetVideoEncoder();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    public void replaceView(Context context) {
        this.isBackground = true;
        this.replaceGlInterface(new OffScreenGlThread(context));
    }

    public void replaceView(OpenGlView openGlView) {
        this.isBackground = false;
        this.replaceGlInterface(openGlView);
    }

    public void replaceView(LightOpenGlView lightOpenGlView) {
        this.isBackground = false;
        this.replaceGlInterface(lightOpenGlView);
    }

    private void replaceGlInterface(GlInterface glInterface) {
        if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
            if (this.isStreaming() || this.isRecording() || this.isOnPreview()) {
                this.cameraManager.closeCamera();
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
                this.glInterface = glInterface;
                this.glInterface.init();
                boolean isPortrait = CameraHelper.isPortrait((Context)this.context);
                if (isPortrait) {
                    this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
                } else {
                    this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
                }
                this.glInterface.setRotation(this.videoEncoder.getRotation() == 0 ? 270 : this.videoEncoder.getRotation() - 90);
                this.glInterface.start();
                if (this.isStreaming() || this.isRecording()) {
                    this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
                }
                this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
                this.cameraManager.openLastCamera();
            } else {
                this.glInterface = glInterface;
                this.glInterface.init();
            }
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height, int rotation) {
        if (!(this.isStreaming() || this.onPreview || this.isBackground)) {
            this.previewWidth = width;
            this.previewHeight = height;
            if (this.surfaceView != null) {
                this.cameraManager.prepareCamera(this.surfaceView.getHolder().getSurface());
            } else if (this.textureView != null) {
                this.cameraManager.prepareCamera(new Surface(this.textureView.getSurfaceTexture()));
            } else if (this.glInterface != null) {
                boolean isPortrait = CameraHelper.isPortrait((Context)this.context);
                if (isPortrait) {
                    this.glInterface.setEncoderSize(height, width);
                } else {
                    this.glInterface.setEncoderSize(width, height);
                }
                this.glInterface.setRotation(rotation == 0 ? 270 : rotation - 90);
                this.glInterface.start();
                this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), width, height);
            }
            this.cameraManager.openCameraFacing(cameraFacing);
            this.onPreview = true;
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height) {
        this.startPreview(cameraFacing, width, height, CameraHelper.getCameraOrientation((Context)this.context));
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int rotation) {
        this.startPreview(cameraFacing, this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), rotation);
    }

    public void startPreview(CameraHelper.Facing cameraFacing) {
        this.startPreview(cameraFacing, this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), CameraHelper.getCameraOrientation((Context)this.context));
    }

    public void startPreview() {
        this.startPreview(CameraHelper.Facing.BACK);
    }

    public void stopPreview() {
        if (!this.isStreaming() && !this.isRecording() && this.onPreview && !this.isBackground) {
            if (this.glInterface != null) {
                this.glInterface.stop();
            }
            this.cameraManager.closeCamera();
            this.onPreview = false;
            this.previewWidth = 0;
            this.previewHeight = 0;
        }
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else {
            this.resetVideoEncoder();
        }
        this.startStreamRtp(url);
        this.onPreview = true;
    }

    private void startEncoders() {
        this.videoEncoder.start();
        this.audioEncoder.start();
        this.prepareGlView();
        this.microphoneManager.start();
        if (this.glInterface == null && !this.cameraManager.isRunning() && this.videoEncoder.getWidth() != this.previewWidth || this.videoEncoder.getHeight() != this.previewHeight) {
            if (this.onPreview) {
                this.cameraManager.openLastCamera();
            } else {
                this.cameraManager.openCameraBack();
            }
        }
        this.onPreview = true;
    }

    private void resetVideoEncoder() {
        if (this.glInterface != null) {
            this.glInterface.removeMediaCodecSurface();
        }
        this.videoEncoder.reset();
        if (this.glInterface != null) {
            this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        } else {
            this.cameraManager.closeCamera();
            this.cameraManager.prepareCamera(this.videoEncoder.getInputSurface());
            this.cameraManager.openLastCamera();
        }
    }

    private void prepareGlView() {
        if (this.glInterface != null && this.videoEnabled) {
            if (this.glInterface instanceof OffScreenGlThread) {
                this.glInterface = new OffScreenGlThread(this.context);
                this.glInterface.init();
            }
            this.glInterface.setFps(this.videoEncoder.getFps());
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            int rotation = this.videoEncoder.getRotation();
            this.glInterface.setRotation(rotation == 0 ? 270 : rotation - 90);
            if (!this.cameraManager.isRunning() && this.videoEncoder.getWidth() != this.previewWidth || this.videoEncoder.getHeight() != this.previewHeight) {
                this.glInterface.start();
            }
            if (this.videoEncoder.getInputSurface() != null) {
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
            this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recordController.isRecording()) {
            this.onPreview = !this.isBackground;
            this.microphoneManager.stop();
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                if (this.glInterface instanceof OffScreenGlThread) {
                    this.glInterface.stop();
                    this.cameraManager.closeCamera();
                }
            } else if (this.isBackground) {
                this.cameraManager.closeCamera();
            } else {
                this.cameraManager.stopRepeatingEncoder();
            }
            this.videoEncoder.stop();
            this.audioEncoder.stop();
            this.recordController.resetFormats();
        }
    }

    public boolean reTry(long delay, String reason) {
        boolean result = this.shouldRetry(reason);
        if (result) {
            this.reTry(delay);
        }
        return result;
    }

    @Deprecated
    public void reTry(long delay) {
        this.resetVideoEncoder();
        this.reConnect(delay);
    }

    @Deprecated
    public abstract boolean shouldRetry(String var1);

    public abstract void setReTries(int var1);

    protected abstract void reConnect(long var1);

    public abstract void resizeCache(int var1) throws RuntimeException;

    public abstract int getCacheSize();

    public abstract long getSentAudioFrames();

    public abstract long getSentVideoFrames();

    public abstract long getDroppedAudioFrames();

    public abstract long getDroppedVideoFrames();

    public abstract void resetSentAudioFrames();

    public abstract void resetSentVideoFrames();

    public abstract void resetDroppedAudioFrames();

    public abstract void resetDroppedVideoFrames();

    public List<Size> getResolutionsBack() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsBack());
    }

    public List<Size> getResolutionsFront() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsFront());
    }

    public CameraCharacteristics getCameraCharacteristics() {
        return this.cameraManager.getCameraCharacteristics();
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public float getMaxZoom() {
        return this.cameraManager.getMaxZoom();
    }

    public float getZoom() {
        return this.cameraManager.getZoom().floatValue();
    }

    public void setZoom(float level) {
        this.cameraManager.setZoom(level);
    }

    public void setZoom(MotionEvent event) {
        this.cameraManager.setZoom(event);
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    public void switchCamera() throws CameraOpenException {
        if (this.isStreaming() || this.onPreview) {
            this.cameraManager.switchCamera();
        }
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    private void prepareCameraManager() {
        if (this.textureView != null) {
            this.cameraManager.prepareCamera(this.textureView, this.videoEncoder.getInputSurface());
        } else if (this.surfaceView != null) {
            this.cameraManager.prepareCamera(this.surfaceView, this.videoEncoder.getInputSurface());
        } else if (this.glInterface == null) {
            this.cameraManager.prepareCamera(this.videoEncoder.getInputSurface());
        }
        this.videoEnabled = true;
    }

    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void setLimitFPSOnFly(int fps) {
        this.videoEncoder.setFps(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    public boolean isOnPreview() {
        return this.onPreview;
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.recordController.recordAudio(aacBuffer, info);
        if (this.streaming) {
            this.getAacDataRtp(aacBuffer, info);
        }
    }

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    public void onSpsPps(ByteBuffer sps, ByteBuffer pps) {
        if (this.streaming) {
            this.onSpsPpsVpsRtp(sps, pps, null);
        }
    }

    public void onSpsPpsVps(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        if (this.streaming) {
            this.onSpsPpsVpsRtp(sps, pps, vps);
        }
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getVideoData(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.fpsListener.calculateFps();
        this.recordController.recordVideo(h264Buffer, info);
        if (this.streaming) {
            this.getH264DataRtp(h264Buffer, info);
        }
    }

    public void inputPCMData(Frame frame) {
        this.audioEncoder.inputPCMData(frame);
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.recordController.setVideoFormat(mediaFormat);
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.recordController.setAudioFormat(mediaFormat);
    }

    public abstract void setLogs(boolean var1);
}

