/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.view;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.ManagerRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.rtplibrary.view.Filter;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.TakePhotoCallback;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

@RequiresApi(api=18)
public class OffScreenGlThread
implements GlInterface,
Runnable,
SurfaceTexture.OnFrameAvailableListener {
    private final Context context;
    private Thread thread = null;
    private boolean frameAvailable = false;
    private boolean running = true;
    private boolean initialized = false;
    private SurfaceManager surfaceManager = null;
    private SurfaceManager surfaceManagerEncoder = null;
    private ManagerRender textureManager = null;
    private final Semaphore semaphore = new Semaphore(0);
    private final BlockingQueue<Filter> filterQueue = new LinkedBlockingQueue<Filter>();
    private final Object sync = new Object();
    private int encoderWidth;
    private int encoderHeight;
    private boolean loadAA = false;
    private int streamRotation;
    private boolean AAEnabled = false;
    private int fps = 30;
    private FpsLimiter fpsLimiter = new FpsLimiter();
    private TakePhotoCallback takePhotoCallback;

    public OffScreenGlThread(Context context) {
        this.context = context;
    }

    @Override
    public void init() {
        if (!this.initialized) {
            this.textureManager = new ManagerRender();
        }
        this.textureManager.setCameraFlip(false, false);
        this.initialized = true;
    }

    @Override
    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    @Override
    public void setFps(int fps) {
        this.fpsLimiter.setFPS(fps);
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.textureManager.getSurfaceTexture();
    }

    @Override
    public Surface getSurface() {
        return this.textureManager.getSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaCodecSurface(Surface surface) {
        Object object = this.sync;
        synchronized (object) {
            this.surfaceManagerEncoder = new SurfaceManager(surface, this.surfaceManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaCodecSurface() {
        Object object = this.sync;
        synchronized (object) {
            if (this.surfaceManagerEncoder != null) {
                this.surfaceManagerEncoder.release();
                this.surfaceManagerEncoder = null;
            }
        }
    }

    @Override
    public void takePhoto(TakePhotoCallback takePhotoCallback) {
        this.takePhotoCallback = takePhotoCallback;
    }

    @Override
    public void setFilter(int filterPosition, BaseFilterRender baseFilterRender) {
        this.filterQueue.add(new Filter(filterPosition, baseFilterRender));
    }

    @Override
    public void setFilter(BaseFilterRender baseFilterRender) {
        this.setFilter(0, baseFilterRender);
    }

    @Override
    public void enableAA(boolean AAEnabled) {
        this.AAEnabled = AAEnabled;
        this.loadAA = true;
    }

    @Override
    public void setRotation(int rotation) {
        this.textureManager.setCameraRotation(rotation);
    }

    @Override
    public void setStreamRotation(int rotation) {
        this.streamRotation = rotation;
    }

    @Override
    public boolean isAAEnabled() {
        return this.textureManager != null && this.textureManager.isAAEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.sync;
        synchronized (object) {
            this.thread = new Thread(this);
            this.running = true;
            this.thread.start();
            this.semaphore.acquireUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            if (this.thread != null) {
                this.thread.interrupt();
                try {
                    this.thread.join(100L);
                }
                catch (InterruptedException e) {
                    this.thread.interrupt();
                }
                this.thread = null;
            }
            this.running = false;
        }
    }

    private void releaseSurfaceManager() {
        if (this.surfaceManager != null) {
            this.surfaceManager.release();
            this.surfaceManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.releaseSurfaceManager();
        this.surfaceManager = new SurfaceManager();
        this.surfaceManager.makeCurrent();
        this.textureManager.initGl(this.context, this.encoderWidth, this.encoderHeight, this.encoderWidth, this.encoderHeight);
        this.textureManager.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.semaphore.release();
        try {
            while (this.running) {
                if (!this.frameAvailable) continue;
                this.frameAvailable = false;
                this.surfaceManager.makeCurrent();
                this.textureManager.updateFrame();
                this.textureManager.drawOffScreen();
                this.textureManager.drawScreen(this.encoderWidth, this.encoderHeight, false, 0, 0, true);
                this.surfaceManager.swapBuffer();
                Object object = this.sync;
                synchronized (object) {
                    if (this.surfaceManagerEncoder != null && !this.fpsLimiter.limitFPS()) {
                        this.surfaceManagerEncoder.makeCurrent();
                        this.textureManager.drawScreen(this.encoderWidth, this.encoderHeight, false, 0, this.streamRotation, false);
                        this.surfaceManagerEncoder.swapBuffer();
                    }
                    if (this.takePhotoCallback != null) {
                        this.takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight, (int)this.encoderWidth, (int)this.encoderHeight));
                        this.takePhotoCallback = null;
                    }
                }
                if (!this.filterQueue.isEmpty()) {
                    Filter filter = this.filterQueue.take();
                    this.textureManager.setFilter(filter.getPosition(), filter.getBaseFilterRender());
                    continue;
                }
                if (!this.loadAA) continue;
                this.textureManager.enableAA(this.AAEnabled);
                this.loadAA = false;
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.textureManager.release();
            this.releaseSurfaceManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        Object object = this.sync;
        synchronized (object) {
            this.frameAvailable = true;
            this.sync.notifyAll();
        }
    }
}

