/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioDecoder;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.LoopFileInterface;
import com.pedro.encoder.input.decoder.VideoDecoder;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.util.FpsListener;
import com.pedro.rtplibrary.util.RecordController;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OffScreenGlThread;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public abstract class FromFileBase
implements GetVideoData,
GetAacData,
GetMicrophoneData,
LoopFileInterface {
    private static final String TAG = "FromFileBase";
    private Context context;
    protected VideoEncoder videoEncoder;
    private AudioEncoder audioEncoder;
    private GlInterface glInterface;
    private boolean streaming = false;
    private boolean videoEnabled = true;
    private RecordController recordController;
    private FpsListener fpsListener = new FpsListener();
    private VideoDecoder videoDecoder;
    private AudioDecoder audioDecoder;
    private VideoDecoderInterface videoDecoderInterface;
    private AudioDecoderInterface audioDecoderInterface;
    private String videoPath;
    private String audioPath;
    private final Object sync = new Object();
    private AudioTrack audioTrackPlayer;

    public FromFileBase(VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    public FromFileBase(Context context, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.context = context;
        this.glInterface = new OffScreenGlThread(context);
        this.glInterface.init();
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    public FromFileBase(OpenGlView openGlView, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.context = openGlView.getContext();
        this.glInterface = openGlView;
        this.glInterface.init();
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    public FromFileBase(LightOpenGlView lightOpenGlView, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.context = lightOpenGlView.getContext();
        this.glInterface = lightOpenGlView;
        this.glInterface.init();
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    private void init(VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.videoDecoderInterface = videoDecoderInterface;
        this.audioDecoderInterface = audioDecoderInterface;
        this.videoEncoder = new VideoEncoder((GetVideoData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.recordController = new RecordController();
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(String filePath, int bitRate, int rotation) throws IOException {
        this.videoPath = filePath;
        this.videoDecoder = new VideoDecoder(this.videoDecoderInterface, (LoopFileInterface)this);
        if (!this.videoDecoder.initExtractor(filePath)) {
            return false;
        }
        boolean hardwareRotation = this.glInterface == null;
        return this.videoEncoder.prepareVideoEncoder(this.videoDecoder.getWidth(), this.videoDecoder.getHeight(), 30, bitRate, rotation, hardwareRotation, 2, FormatVideoEncoder.SURFACE);
    }

    public boolean prepareVideo(String filePath) throws IOException {
        return this.prepareVideo(filePath, 1228800, 0);
    }

    public boolean prepareAudio(String filePath, int bitRate) throws IOException {
        this.audioPath = filePath;
        this.audioDecoder = new AudioDecoder((GetMicrophoneData)this, this.audioDecoderInterface, (LoopFileInterface)this);
        if (!this.audioDecoder.initExtractor(filePath)) {
            return false;
        }
        boolean result = this.audioEncoder.prepareAudioEncoder(bitRate, this.audioDecoder.getSampleRate(), this.audioDecoder.isStereo(), 0);
        this.prepareAudioRtp(this.audioDecoder.isStereo(), this.audioDecoder.getSampleRate());
        this.audioDecoder.prepareAudio();
        if (this.glInterface != null && !(this.glInterface instanceof OffScreenGlThread)) {
            int channel = this.audioDecoder.isStereo() ? 12 : 4;
            int buffSize = AudioTrack.getMinBufferSize((int)this.audioDecoder.getSampleRate(), (int)channel, (int)2);
            this.audioTrackPlayer = new AudioTrack(3, this.audioDecoder.getSampleRate(), channel, 2, buffSize, 1);
        }
        return result;
    }

    public boolean prepareAudio(String filePath) throws IOException {
        return this.prepareAudio(filePath, 65536);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    public void startRecord(String path, RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.resetVideoEncoder();
        }
    }

    public void startRecord(String path) throws IOException {
        this.startRecord(path, null);
    }

    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else {
            this.resetVideoEncoder();
        }
        this.startStreamRtp(url);
    }

    private void startEncoders() {
        this.videoEncoder.start();
        if (this.audioTrackPlayer != null) {
            this.audioTrackPlayer.play();
        }
        this.audioEncoder.start();
        this.prepareGlView();
        this.videoDecoder.start();
        this.audioDecoder.start();
    }

    private void prepareGlView() {
        if (this.glInterface != null) {
            if (this.glInterface instanceof OffScreenGlThread) {
                this.glInterface = new OffScreenGlThread(this.context);
                this.glInterface.init();
            }
            this.glInterface.setFps(this.videoEncoder.getFps());
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.glInterface.setRotation(0);
            this.glInterface.start();
            if (this.videoEncoder.getInputSurface() != null) {
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
            this.videoDecoder.prepareVideo(this.glInterface.getSurface());
        } else {
            this.videoDecoder.prepareVideo(this.videoEncoder.getInputSurface());
        }
    }

    private void resetVideoEncoder() {
        try {
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
            }
            double time = this.videoDecoder.getTime();
            this.videoDecoder.stop();
            this.videoDecoder = new VideoDecoder(this.videoDecoderInterface, (LoopFileInterface)this);
            if (!this.videoDecoder.initExtractor(this.videoPath)) {
                throw new IOException("fail to reset video file");
            }
            this.videoEncoder.reset();
            this.prepareGlView();
            this.videoDecoder.start();
            this.videoDecoder.moveTo(time);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error", (Throwable)e);
        }
    }

    protected abstract void stopStreamRtp();

    public boolean reTry(long delay, String reason) {
        boolean result = this.shouldRetry(reason);
        if (result) {
            this.reTry(delay);
        }
        return result;
    }

    @Deprecated
    public void reTry(long delay) {
        this.resetVideoEncoder();
        this.reConnect(delay);
    }

    @Deprecated
    public abstract boolean shouldRetry(String var1);

    public abstract void setReTries(int var1);

    protected abstract void reConnect(long var1);

    public abstract void resizeCache(int var1) throws RuntimeException;

    public abstract int getCacheSize();

    public abstract long getSentAudioFrames();

    public abstract long getSentVideoFrames();

    public abstract long getDroppedAudioFrames();

    public abstract long getDroppedVideoFrames();

    public abstract void resetSentAudioFrames();

    public abstract void resetSentVideoFrames();

    public abstract void resetDroppedAudioFrames();

    public abstract void resetDroppedVideoFrames();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recordController.isRecording()) {
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
            }
            if (this.videoDecoder != null) {
                this.videoDecoder.stop();
            }
            if (this.audioDecoder != null) {
                this.audioDecoder.stop();
            }
            if (this.audioTrackPlayer != null && this.audioTrackPlayer.getPlayState() == 3) {
                this.audioTrackPlayer.stop();
            }
            this.audioTrackPlayer = null;
            this.videoEncoder.stop();
            this.audioEncoder.stop();
            this.recordController.resetFormats();
        }
    }

    public void setLoopMode(boolean loopMode) {
        this.videoDecoder.setLoopMode(loopMode);
        this.audioDecoder.setLoopMode(loopMode);
    }

    public void reSyncFile() {
        if (this.isStreaming()) {
            this.audioDecoder.moveTo(this.videoDecoder.getTime());
        }
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public void setVideoBitrateOnFly(int bitrate) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.videoEncoder.setVideoBitrateOnFly(bitrate);
        }
    }

    public void setLimitFPSOnFly(int fps) {
        this.videoEncoder.setFps(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    public double getVideoTime() {
        return this.videoDecoder.getTime();
    }

    public double getAudioTime() {
        return this.videoDecoder.getTime();
    }

    public double getVideoDuration() {
        return this.videoDecoder.getDuration();
    }

    public double getAudioDuration() {
        return this.audioDecoder.getDuration();
    }

    public void moveTo(double time) {
        this.videoDecoder.moveTo(time);
        this.audioDecoder.moveTo(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReset(boolean isVideo) {
        Object object = this.sync;
        synchronized (object) {
            try {
                if (isVideo) {
                    if (this.glInterface != null) {
                        this.glInterface.removeMediaCodecSurface();
                        this.glInterface.stop();
                    }
                    this.videoDecoder.stop();
                    this.videoDecoder = new VideoDecoder(this.videoDecoderInterface, (LoopFileInterface)this);
                    if (!this.videoDecoder.initExtractor(this.videoPath)) {
                        throw new IOException("fail to reset video file");
                    }
                    this.prepareGlView();
                    this.videoDecoder.start();
                } else {
                    this.audioDecoder.stop();
                    this.audioDecoder = new AudioDecoder((GetMicrophoneData)this, this.audioDecoderInterface, (LoopFileInterface)this);
                    if (!this.audioDecoder.initExtractor(this.audioPath)) {
                        throw new IOException("fail to reset audio file");
                    }
                    this.audioDecoder.prepareAudio();
                    this.audioDecoder.start();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error", (Throwable)e);
                if (isVideo) {
                    this.videoDecoderInterface.onVideoDecoderFinished();
                }
                this.audioDecoderInterface.onAudioDecoderFinished();
            }
        }
    }

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    public void onSpsPps(ByteBuffer sps, ByteBuffer pps) {
        if (this.streaming) {
            this.onSpsPpsVpsRtp(sps, pps, null);
        }
    }

    public void onSpsPpsVps(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        if (this.streaming) {
            this.onSpsPpsVpsRtp(sps, pps, vps);
        }
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getVideoData(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.fpsListener.calculateFps();
        this.recordController.recordVideo(h264Buffer, info);
        if (this.streaming) {
            this.getH264DataRtp(h264Buffer, info);
        }
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.recordController.setVideoFormat(mediaFormat);
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.recordController.recordAudio(aacBuffer, info);
        if (this.streaming) {
            this.getAacDataRtp(aacBuffer, info);
        }
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.recordController.setAudioFormat(mediaFormat);
    }

    public void inputPCMData(Frame frame) {
        if (this.audioTrackPlayer != null) {
            this.audioTrackPlayer.write(frame.getBuffer(), frame.getOffset(), frame.getSize());
        }
        this.audioEncoder.inputPCMData(frame);
    }
}

