/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtsp;

import android.content.Context;
import android.media.MediaCodec;
import android.support.annotation.RequiresApi;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.rtplibrary.base.FromFileBase;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OpenGlView;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.rtsp.rtsp.VideoCodec;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public class RtspFromFile
extends FromFileBase {
    private RtspClient rtspClient;

    public RtspFromFile(ConnectCheckerRtsp connectCheckerRtsp, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
    }

    public RtspFromFile(Context context, ConnectCheckerRtsp connectCheckerRtsp, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(context, videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
    }

    public RtspFromFile(OpenGlView openGlView, ConnectCheckerRtsp connectCheckerRtsp, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(openGlView, videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
    }

    public RtspFromFile(LightOpenGlView lightOpenGlView, ConnectCheckerRtsp connectCheckerRtsp, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(lightOpenGlView, videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
    }

    public void setProtocol(Protocol protocol) {
        this.rtspClient.setProtocol(protocol);
    }

    @Override
    public void resizeCache(int newSize) throws RuntimeException {
        this.rtspClient.resizeCache(newSize);
    }

    @Override
    public int getCacheSize() {
        return this.rtspClient.getCacheSize();
    }

    @Override
    public long getSentAudioFrames() {
        return this.rtspClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.rtspClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.rtspClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.rtspClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtspClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtspClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtspClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtspClient.resetDroppedVideoFrames();
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.videoEncoder.setType(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.rtspClient.setAuthorization(user, password);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtspClient.setIsStereo(isStereo);
        this.rtspClient.setSampleRate(sampleRate);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtspClient.setUrl(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        ByteBuffer newSps = sps.duplicate();
        ByteBuffer newPps = pps.duplicate();
        ByteBuffer newVps = vps != null ? vps.duplicate() : null;
        this.rtspClient.setSPSandPPS(newSps, newPps, newVps);
        this.rtspClient.connect();
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendAudio(aacBuffer, info);
    }
}

