/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioDecoder;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoder;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetH264Data;
import com.pedro.encoder.video.VideoEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public abstract class FromFileBase
implements GetH264Data,
GetAacData,
GetMicrophoneData {
    protected VideoEncoder videoEncoder;
    protected AudioEncoder audioEncoder;
    private boolean streaming;
    private boolean videoEnabled = true;
    private MediaMuxer mediaMuxer;
    private int videoTrack = -1;
    private int audioTrack = -1;
    private boolean recording = false;
    private boolean canRecord = false;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;
    private VideoDecoder videoDecoder;
    private AudioDecoder audioDecoder;
    private VideoDecoderInterface videoDecoderInterface;
    private AudioDecoderInterface audioDecoderInterface;

    public FromFileBase(VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.videoDecoderInterface = videoDecoderInterface;
        this.audioDecoderInterface = audioDecoderInterface;
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(String filePath, int bitRate) throws IOException {
        this.videoDecoder = new VideoDecoder(this.videoDecoderInterface);
        if (!this.videoDecoder.initExtractor(filePath)) {
            return false;
        }
        boolean result = this.videoEncoder.prepareVideoEncoder(this.videoDecoder.getWidth(), this.videoDecoder.getHeight(), 30, bitRate, 0, true, 2, FormatVideoEncoder.SURFACE);
        this.videoDecoder.prepareVideo(this.videoEncoder.getInputSurface());
        return result;
    }

    public boolean prepareAudio(String filePath, int bitRate) throws IOException {
        this.audioDecoder = new AudioDecoder((GetMicrophoneData)this, this.audioDecoderInterface);
        if (!this.audioDecoder.initExtractor(filePath)) {
            return false;
        }
        boolean result = this.audioEncoder.prepareAudioEncoder(bitRate, this.audioDecoder.getSampleRate(), this.audioDecoder.isStereo());
        this.audioDecoder.prepareAudio();
        return result;
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    public void startRecord(String path) throws IOException {
        if (!this.streaming) {
            throw new IOException("Need be called while stream");
        }
        this.mediaMuxer = new MediaMuxer(path, 0);
        this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
        this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
        this.mediaMuxer.start();
        this.recording = true;
    }

    public void stopRecord() {
        this.recording = false;
        if (this.mediaMuxer != null) {
            if (this.canRecord) {
                this.mediaMuxer.stop();
                this.mediaMuxer.release();
                this.canRecord = false;
            }
            this.mediaMuxer = null;
        }
        this.videoTrack = -1;
        this.audioTrack = -1;
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.startStreamRtp(url);
        this.videoEncoder.start();
        this.audioEncoder.start();
        this.videoDecoder.start();
        this.audioDecoder.start();
        this.streaming = true;
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        this.stopStreamRtp();
        this.videoDecoder.stop();
        this.audioDecoder.stop();
        this.videoEncoder.stop();
        this.audioEncoder.stop();
        this.streaming = false;
    }

    public void setLoopMode(boolean loopMode) {
        this.videoDecoder.setLoopMode(loopMode);
        this.audioDecoder.setLoopMode(loopMode);
    }

    public void disableVideo() {
        this.videoEncoder.startSendBlackImage();
        this.videoEnabled = false;
    }

    public void enableVideo() {
        this.videoEncoder.stopSendBlackImage();
        this.videoEnabled = true;
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public void setVideoBitrateOnFly(int bitrate) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.videoEncoder.setVideoBitrateOnFly(bitrate);
        }
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recording;
    }

    protected abstract void onSPSandPPSRtp(ByteBuffer var1, ByteBuffer var2);

    public void onSPSandPPS(ByteBuffer sps, ByteBuffer pps) {
        this.onSPSandPPSRtp(sps, pps);
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getH264Data(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        if (this.recording) {
            if (info.flags == 1) {
                this.canRecord = true;
            }
            if (this.canRecord) {
                this.mediaMuxer.writeSampleData(this.videoTrack, h264Buffer, info);
            }
        }
        this.getH264DataRtp(h264Buffer, info);
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.videoFormat = mediaFormat;
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        if (this.recording && this.canRecord) {
            this.mediaMuxer.writeSampleData(this.audioTrack, aacBuffer, info);
        }
        this.getAacDataRtp(aacBuffer, info);
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.audioFormat = mediaFormat;
    }

    public void inputPCMData(byte[] buffer, int size) {
        this.audioEncoder.inputPCMData(buffer, size);
    }
}

