/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.content.Intent;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.view.SurfaceView;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetH264Data;
import com.pedro.encoder.video.VideoEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public abstract class DisplayBase
implements GetAacData,
GetH264Data,
GetMicrophoneData {
    protected Context context;
    private MediaProjection mediaProjection;
    private MediaProjectionManager mediaProjectionManager;
    protected VideoEncoder videoEncoder;
    protected MicrophoneManager microphoneManager;
    protected AudioEncoder audioEncoder;
    private boolean streaming;
    protected SurfaceView surfaceView;
    private boolean videoEnabled = true;
    private MediaMuxer mediaMuxer;
    private int videoTrack = -1;
    private int audioTrack = -1;
    private boolean recording = false;
    private boolean canRecord = false;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;
    private int dpi = 320;

    public DisplayBase(Context context) {
        this.context = context;
        this.mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        this.surfaceView = null;
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation, int dpi) {
        this.dpi = dpi;
        boolean result = this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, true, 2, FormatVideoEncoder.SURFACE);
        return result;
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.microphoneManager.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        this.prepareAudioRtp(isStereo, sampleRate);
        return this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo);
    }

    public boolean prepareVideo() {
        return this.videoEncoder.prepareVideoEncoder(640, 480, 30, 1228800, 0, true, 2, FormatVideoEncoder.SURFACE);
    }

    public boolean prepareAudio() {
        this.microphoneManager.createMicrophone();
        return this.audioEncoder.prepareAudioEncoder();
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    public void startRecord(String path) throws IOException {
        if (!this.streaming) {
            throw new IOException("Need be called while stream");
        }
        this.mediaMuxer = new MediaMuxer(path, 0);
        this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
        this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
        this.mediaMuxer.start();
        this.recording = true;
    }

    public void stopRecord() {
        this.recording = false;
        if (this.mediaMuxer != null) {
            if (this.canRecord) {
                this.mediaMuxer.stop();
                this.mediaMuxer.release();
                this.canRecord = false;
            }
            this.mediaMuxer = null;
        }
        this.videoTrack = -1;
        this.audioTrack = -1;
    }

    protected abstract void startStreamRtp(String var1);

    public Intent sendIntent() {
        return this.mediaProjectionManager.createScreenCaptureIntent();
    }

    public void startStream(String url, int resultCode, Intent data) {
        this.videoEncoder.start();
        this.audioEncoder.start();
        this.mediaProjection = this.mediaProjectionManager.getMediaProjection(resultCode, data);
        this.mediaProjection.createVirtualDisplay("Stream Display", this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.dpi, 0, this.videoEncoder.getInputSurface(), null, null);
        this.microphoneManager.start();
        this.streaming = true;
        this.startStreamRtp(url);
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        this.microphoneManager.stop();
        if (this.mediaProjection != null) {
            this.mediaProjection.stop();
        }
        this.stopStreamRtp();
        this.videoEncoder.stop();
        this.audioEncoder.stop();
        this.streaming = false;
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public void disableVideo() {
        this.videoEncoder.startSendBlackImage();
        this.videoEnabled = false;
    }

    public void enableVideo() {
        this.videoEncoder.stopSendBlackImage();
        this.videoEnabled = true;
    }

    public void setVideoBitrateOnFly(int bitrate) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.videoEncoder.setVideoBitrateOnFly(bitrate);
        }
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recording;
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        if (this.recording && this.canRecord) {
            this.mediaMuxer.writeSampleData(this.audioTrack, aacBuffer, info);
        }
        this.getAacDataRtp(aacBuffer, info);
    }

    protected abstract void onSPSandPPSRtp(ByteBuffer var1, ByteBuffer var2);

    public void onSPSandPPS(ByteBuffer sps, ByteBuffer pps) {
        this.onSPSandPPSRtp(sps, pps);
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getH264Data(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        if (this.recording) {
            if (info.flags == 1) {
                this.canRecord = true;
            }
            if (this.canRecord) {
                this.mediaMuxer.writeSampleData(this.videoTrack, h264Buffer, info);
            }
        }
        this.getH264DataRtp(h264Buffer, info);
    }

    public void inputPCMData(byte[] buffer, int size) {
        this.audioEncoder.inputPCMData(buffer, size);
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.videoFormat = mediaFormat;
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.audioFormat = mediaFormat;
    }
}

