/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtmp;

import android.content.Context;
import android.media.MediaCodec;
import android.support.annotation.RequiresApi;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.rtplibrary.base.Camera2Base;
import com.pedro.rtplibrary.view.OpenGlView;
import java.nio.ByteBuffer;
import net.ossrs.rtmp.ConnectCheckerRtmp;
import net.ossrs.rtmp.SrsFlvMuxer;

@RequiresApi(api=21)
public class RtmpCamera2
extends Camera2Base {
    private SrsFlvMuxer srsFlvMuxer;

    public RtmpCamera2(SurfaceView surfaceView, ConnectCheckerRtmp connectChecker) {
        super(surfaceView, surfaceView.getContext());
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    public RtmpCamera2(TextureView textureView, ConnectCheckerRtmp connectChecker) {
        super(textureView, textureView.getContext());
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    public RtmpCamera2(OpenGlView openGlView, ConnectCheckerRtmp connectChecker) {
        super(openGlView, openGlView.getContext());
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    public RtmpCamera2(Context context, ConnectCheckerRtmp connectChecker) {
        super(context);
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    public void setProfileIop(byte profileIop) {
        this.srsFlvMuxer.setProfileIop(profileIop);
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.srsFlvMuxer.setAuthorization(user, password);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.srsFlvMuxer.setIsStereo(isStereo);
        this.srsFlvMuxer.setSampleRate(sampleRate);
    }

    @Override
    protected void startStreamRtp(String url) {
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            this.srsFlvMuxer.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            this.srsFlvMuxer.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        this.srsFlvMuxer.start(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.srsFlvMuxer.stop();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.srsFlvMuxer.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSPSandPPSRtp(ByteBuffer sps, ByteBuffer pps) {
        this.srsFlvMuxer.setSpsPPs(sps, pps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.srsFlvMuxer.sendVideo(h264Buffer, info);
    }
}

