/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.graphics.PointF;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.video.Camera2ApiManager;
import com.pedro.encoder.input.video.Camera2Facing;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.utils.gl.GifStreamObject;
import com.pedro.encoder.utils.gl.ImageStreamObject;
import com.pedro.encoder.utils.gl.TextStreamObject;
import com.pedro.encoder.utils.gl.TranslateTo;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetH264Data;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.view.LightOpengGlView;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=21)
public abstract class Camera2Base
implements GetAacData,
GetH264Data,
GetMicrophoneData {
    protected Context context;
    protected Camera2ApiManager cameraManager;
    protected VideoEncoder videoEncoder;
    protected MicrophoneManager microphoneManager;
    protected AudioEncoder audioEncoder;
    private boolean streaming;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private OpenGlView openGlView;
    private LightOpengGlView lightOpengGlView;
    private boolean videoEnabled = false;
    private MediaMuxer mediaMuxer;
    private int videoTrack = -1;
    private int audioTrack = -1;
    private boolean recording = false;
    private boolean canRecord = false;
    private boolean onPreview = false;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;

    public Camera2Base(SurfaceView surfaceView, Context context) {
        this.surfaceView = surfaceView;
        this.context = context;
        this.cameraManager = new Camera2ApiManager(context);
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    public Camera2Base(TextureView textureView, Context context) {
        this.textureView = textureView;
        this.context = context;
        this.cameraManager = new Camera2ApiManager(context);
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    public Camera2Base(OpenGlView openGlView, Context context) {
        this.openGlView = openGlView;
        this.context = context;
        openGlView.init();
        this.cameraManager = new Camera2ApiManager(context);
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    public Camera2Base(LightOpengGlView lightOpengGlView, Context context) {
        this.lightOpengGlView = lightOpengGlView;
        this.context = context;
        lightOpengGlView.init();
        this.cameraManager = new Camera2ApiManager(context);
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    public Camera2Base(Context context) {
        this.context = context;
        this.textureView = null;
        this.cameraManager = new Camera2ApiManager(context);
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(int width, int height, int fps, int bitrate, boolean hardwareRotation, int iFrameInterval, int rotation) {
        if (this.onPreview) {
            this.stopPreview();
            this.onPreview = true;
        }
        boolean result = this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, hardwareRotation, iFrameInterval, FormatVideoEncoder.SURFACE);
        this.prepareCameraManager();
        return result;
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, boolean hardwareRotation, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, hardwareRotation, 2, rotation);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.microphoneManager.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        this.prepareAudioRtp(isStereo, sampleRate);
        return this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo);
    }

    public boolean prepareVideo() {
        if (this.onPreview) {
            this.stopPreview();
            this.onPreview = true;
        }
        boolean isHardwareRotation = true;
        if (this.openGlView != null || this.lightOpengGlView != null) {
            isHardwareRotation = false;
        }
        int orientation = 0;
        if (this.context.getResources().getConfiguration().orientation == 1) {
            orientation = 90;
        }
        boolean result = this.videoEncoder.prepareVideoEncoder(640, 480, 30, 1228800, orientation, isHardwareRotation, 2, FormatVideoEncoder.SURFACE);
        this.prepareCameraManager();
        return result;
    }

    public boolean prepareAudio() {
        this.microphoneManager.createMicrophone();
        return this.audioEncoder.prepareAudioEncoder();
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    public void startRecord(String path) throws IOException {
        if (this.streaming) {
            this.mediaMuxer = new MediaMuxer(path, 0);
            if (this.videoFormat != null) {
                this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
            }
            if (this.audioFormat != null) {
                this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
            }
        } else {
            throw new IOException("Need be called while stream");
        }
        this.mediaMuxer.start();
        this.recording = true;
    }

    public void stopRecord() {
        this.recording = false;
        this.canRecord = false;
        if (this.mediaMuxer != null) {
            this.mediaMuxer.stop();
            this.mediaMuxer.release();
            this.mediaMuxer = null;
        }
        this.videoTrack = -1;
        this.audioTrack = -1;
    }

    public void startPreview(@Camera2Facing int cameraFacing) {
        if (!this.isStreaming() && !this.onPreview) {
            if (this.surfaceView != null) {
                this.cameraManager.prepareCamera(this.surfaceView.getHolder().getSurface());
            } else if (this.textureView != null) {
                this.cameraManager.prepareCamera(new Surface(this.textureView.getSurfaceTexture()));
            } else if (this.openGlView != null) {
                boolean isCamera2Lanscape = true;
                if (this.context.getResources().getConfiguration().orientation == 1) {
                    isCamera2Lanscape = false;
                }
                this.openGlView.startGLThread(isCamera2Lanscape);
                this.cameraManager.prepareCamera(this.openGlView.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            } else if (this.lightOpengGlView != null) {
                boolean isCamera2Lanscape = true;
                if (this.context.getResources().getConfiguration().orientation == 1) {
                    isCamera2Lanscape = false;
                }
                this.lightOpengGlView.startGLThread(isCamera2Lanscape);
                this.cameraManager.prepareCamera(this.lightOpengGlView.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.cameraManager.openCameraFacing(cameraFacing);
            this.onPreview = true;
        }
    }

    public void startPreview() {
        this.startPreview(1);
    }

    public void stopPreview() {
        if (!this.isStreaming() && this.onPreview) {
            if (this.openGlView != null) {
                this.openGlView.stopGlThread();
            } else if (this.lightOpengGlView != null) {
                this.lightOpengGlView.stopGlThread();
            }
            this.cameraManager.closeCamera(false);
            this.onPreview = false;
        }
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        if (this.openGlView != null && this.videoEnabled) {
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.openGlView.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
                this.openGlView.startGLThread(false);
            } else {
                this.openGlView.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
                this.openGlView.startGLThread(true);
            }
            this.openGlView.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            this.cameraManager.prepareCamera(this.openGlView.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        } else if (this.lightOpengGlView != null && this.videoEnabled) {
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.lightOpengGlView.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
                this.lightOpengGlView.startGLThread(false);
            } else {
                this.lightOpengGlView.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
                this.lightOpengGlView.startGLThread(true);
            }
            this.lightOpengGlView.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            this.cameraManager.prepareCamera(this.lightOpengGlView.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        this.videoEncoder.start();
        this.audioEncoder.start();
        if (this.onPreview) {
            this.cameraManager.openLastCamera();
        } else {
            this.cameraManager.openCameraBack();
        }
        this.microphoneManager.start();
        this.streaming = true;
        this.startStreamRtp(url);
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        this.cameraManager.closeCamera(true);
        this.microphoneManager.stop();
        this.stopStreamRtp();
        this.videoEncoder.stop();
        this.audioEncoder.stop();
        if (this.openGlView != null) {
            this.openGlView.removeMediaCodecSurface();
        } else if (this.lightOpengGlView != null) {
            this.lightOpengGlView.removeMediaCodecSurface();
        }
        this.streaming = false;
    }

    public List<Size> getResolutionsBack() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsBack());
    }

    public List<Size> getResolutionsFront() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsFront());
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public void disableVideo() {
        this.videoEncoder.startSendBlackImage();
        this.videoEnabled = false;
    }

    public void enableVideo() {
        this.videoEncoder.stopSendBlackImage();
        this.videoEnabled = true;
    }

    public void switchCamera() throws CameraOpenException {
        if (this.isStreaming() || this.onPreview) {
            this.cameraManager.switchCamera();
        }
    }

    public void setFilter(BaseFilterRender baseFilterRender) {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a gif");
        }
        this.openGlView.setFilter(baseFilterRender);
    }

    public void setGifStreamObject(GifStreamObject gifStreamObject) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a gif");
        }
        this.openGlView.setGif(gifStreamObject);
    }

    public void setImageStreamObject(ImageStreamObject imageStreamObject) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a image");
        }
        this.openGlView.setImage(imageStreamObject);
    }

    public void setTextStreamObject(TextStreamObject textStreamObject) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a text");
        }
        this.openGlView.setText(textStreamObject);
    }

    public void clearStreamObject() throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a text");
        }
        this.openGlView.clear();
    }

    public void setAlphaStreamObject(float alpha) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set an alpha");
        }
        this.openGlView.setStreamObjectAlpha(alpha);
    }

    public void setSizeStreamObject(float sizeX, float sizeY) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a size");
        }
        this.openGlView.setStreamObjectSize(sizeX, sizeY);
    }

    public void setPositionStreamObject(float x, float y) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a position");
        }
        this.openGlView.setStreamObjectPosition(x, y);
    }

    public void setPositionStreamObject(TranslateTo translateTo) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a position");
        }
        this.openGlView.setStreamObjectPosition(translateTo);
    }

    public PointF getSizeStreamObject() throws RuntimeException {
        if (this.openGlView != null) {
            return this.openGlView.getScale();
        }
        throw new RuntimeException("You must use OpenGlView in the constructor to get position");
    }

    public PointF getPositionStreamObject() throws RuntimeException {
        if (this.openGlView != null) {
            return this.openGlView.getPosition();
        }
        throw new RuntimeException("You must use OpenGlView in the constructor to get scale");
    }

    public void setVideoBitrateOnFly(int bitrate) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.videoEncoder.setVideoBitrateOnFly(bitrate);
        }
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isOnPreview() {
        return this.onPreview;
    }

    private void prepareCameraManager() {
        if (this.textureView != null) {
            this.cameraManager.prepareCamera(this.textureView, this.videoEncoder.getInputSurface());
        } else if (this.surfaceView != null) {
            this.cameraManager.prepareCamera(this.surfaceView, this.videoEncoder.getInputSurface());
        } else if (this.openGlView == null && this.lightOpengGlView == null) {
            this.cameraManager.prepareCamera(this.videoEncoder.getInputSurface());
        }
        this.videoEnabled = true;
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        if (this.recording && this.audioTrack != -1 && this.canRecord) {
            this.mediaMuxer.writeSampleData(this.audioTrack, aacBuffer, info);
        }
        this.getAacDataRtp(aacBuffer, info);
    }

    protected abstract void onSPSandPPSRtp(ByteBuffer var1, ByteBuffer var2);

    public void onSPSandPPS(ByteBuffer sps, ByteBuffer pps) {
        this.onSPSandPPSRtp(sps, pps);
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getH264Data(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        if (this.recording && this.videoTrack != -1) {
            if (info.flags == 1) {
                this.canRecord = true;
            }
            if (this.canRecord) {
                this.mediaMuxer.writeSampleData(this.videoTrack, h264Buffer, info);
            }
        }
        this.getH264DataRtp(h264Buffer, info);
    }

    public void inputPCMData(byte[] buffer, int size) {
        this.audioEncoder.inputPCMData(buffer, size);
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.videoFormat = mediaFormat;
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.audioFormat = mediaFormat;
    }
}

