/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.graphics.PointF;
import android.hardware.Camera;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.video.Camera1ApiManager;
import com.pedro.encoder.input.video.Camera1Facing;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.EffectManager;
import com.pedro.encoder.input.video.Frame;
import com.pedro.encoder.input.video.GetCameraData;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.utils.gl.GifStreamObject;
import com.pedro.encoder.utils.gl.ImageStreamObject;
import com.pedro.encoder.utils.gl.TextStreamObject;
import com.pedro.encoder.utils.gl.TranslateTo;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetH264Data;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.view.LightOpengGlView;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class Camera1Base
implements GetAacData,
GetCameraData,
GetH264Data,
GetMicrophoneData {
    private static final String TAG = "Camera1Base";
    private Context context;
    protected Camera1ApiManager cameraManager;
    protected VideoEncoder videoEncoder;
    protected MicrophoneManager microphoneManager;
    protected AudioEncoder audioEncoder;
    private OpenGlView openGlView;
    private LightOpengGlView lightOpengGlView;
    private boolean streaming;
    private boolean videoEnabled = true;
    private MediaMuxer mediaMuxer;
    private int videoTrack = -1;
    private int audioTrack = -1;
    private boolean recording = false;
    private boolean canRecord = false;
    private boolean onPreview = false;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;

    public Camera1Base(SurfaceView surfaceView) {
        this.cameraManager = new Camera1ApiManager(surfaceView, (GetCameraData)this);
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    public Camera1Base(TextureView textureView) {
        this.cameraManager = new Camera1ApiManager(textureView, (GetCameraData)this);
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    @RequiresApi(api=18)
    public Camera1Base(OpenGlView openGlView) {
        this.context = openGlView.getContext();
        this.openGlView = openGlView;
        this.openGlView.init();
        this.cameraManager = new Camera1ApiManager(openGlView.getSurfaceTexture(), openGlView.getContext());
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    @RequiresApi(api=18)
    public Camera1Base(LightOpengGlView lightOpengGlView) {
        this.context = lightOpengGlView.getContext();
        this.lightOpengGlView = lightOpengGlView;
        this.lightOpengGlView.init();
        this.cameraManager = new Camera1ApiManager(lightOpengGlView.getSurfaceTexture(), lightOpengGlView.getContext());
        this.videoEncoder = new VideoEncoder((GetH264Data)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.streaming = false;
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(int width, int height, int fps, int bitrate, boolean hardwareRotation, int iFrameInterval, int rotation) {
        if (this.onPreview) {
            this.stopPreview();
            this.onPreview = true;
        }
        int imageFormat = 17;
        if (this.openGlView == null && this.lightOpengGlView == null) {
            this.cameraManager.prepareCamera(width, height, fps, imageFormat);
            return this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, hardwareRotation, iFrameInterval, FormatVideoEncoder.YUV420Dynamical);
        }
        return this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, hardwareRotation, iFrameInterval, FormatVideoEncoder.SURFACE);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, boolean hardwareRotation, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, hardwareRotation, 2, rotation);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.microphoneManager.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        this.prepareAudioRtp(isStereo, sampleRate);
        return this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo);
    }

    public boolean prepareVideo() {
        if (this.onPreview) {
            this.stopPreview();
            this.onPreview = true;
        }
        if (this.openGlView == null && this.lightOpengGlView == null) {
            this.cameraManager.prepareCamera();
            return this.videoEncoder.prepareVideoEncoder();
        }
        int orientation = 0;
        if (this.context.getResources().getConfiguration().orientation == 1) {
            orientation = 90;
        }
        return this.videoEncoder.prepareVideoEncoder(640, 480, 30, 1228800, orientation, false, 2, FormatVideoEncoder.SURFACE);
    }

    public boolean prepareAudio() {
        this.microphoneManager.createMicrophone();
        return this.audioEncoder.prepareAudioEncoder();
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    @RequiresApi(api=18)
    public void startRecord(String path) throws IOException {
        if (this.streaming) {
            this.mediaMuxer = new MediaMuxer(path, 0);
            if (this.videoFormat != null) {
                this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
            }
            if (this.audioFormat != null) {
                this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
            }
        } else {
            throw new IOException("Need be called while stream");
        }
        this.mediaMuxer.start();
        this.recording = true;
    }

    @RequiresApi(api=18)
    public void stopRecord() {
        this.recording = false;
        this.canRecord = false;
        if (this.mediaMuxer != null) {
            this.mediaMuxer.stop();
            this.mediaMuxer.release();
            this.mediaMuxer = null;
        }
        this.videoTrack = -1;
        this.audioTrack = -1;
    }

    public void startPreview(@Camera1Facing int cameraFacing, int width, int height) {
        if (!this.isStreaming() && !this.onPreview) {
            if (this.openGlView != null && Build.VERSION.SDK_INT >= 18) {
                this.openGlView.setEncoderSize(width, height);
                this.openGlView.startGLThread(false);
                this.cameraManager.setSurfaceTexture(this.openGlView.getSurfaceTexture());
            } else if (this.lightOpengGlView != null && Build.VERSION.SDK_INT >= 18) {
                this.lightOpengGlView.setEncoderSize(width, height);
                this.lightOpengGlView.startGLThread(false);
                this.cameraManager.setSurfaceTexture(this.lightOpengGlView.getSurfaceTexture());
            }
            this.cameraManager.prepareCamera();
            if (width == 0 || height == 0) {
                this.cameraManager.start(cameraFacing);
            } else {
                this.cameraManager.start(cameraFacing, width, height);
            }
            this.onPreview = true;
        } else {
            Log.e((String)TAG, (String)"Streaming or preview started, ignored");
        }
    }

    public void startPreview(@Camera1Facing int cameraFacing) {
        this.startPreview(cameraFacing, 0, 0);
    }

    public void startPreview(int width, int height) {
        this.startPreview(0, width, height);
    }

    public void startPreview() {
        this.startPreview(0);
    }

    public void stopPreview() {
        if (!this.isStreaming() && this.onPreview) {
            if (this.openGlView != null && Build.VERSION.SDK_INT >= 18) {
                this.openGlView.stopGlThread();
            } else if (this.lightOpengGlView != null && Build.VERSION.SDK_INT >= 18) {
                this.lightOpengGlView.stopGlThread();
            }
            this.cameraManager.stop();
            this.onPreview = false;
        } else {
            Log.e((String)TAG, (String)"Streaming or preview stopped, ignored");
        }
    }

    public void setPreviewOrientation(int orientation) {
        this.cameraManager.setPreviewOrientation(orientation);
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        if (this.openGlView != null && Build.VERSION.SDK_INT >= 18) {
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.openGlView.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.openGlView.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.openGlView.startGLThread(false);
            this.openGlView.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            this.cameraManager.setSurfaceTexture(this.openGlView.getSurfaceTexture());
            this.cameraManager.prepareCamera(this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getFps(), 17);
        } else if (this.lightOpengGlView != null && Build.VERSION.SDK_INT >= 18) {
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.lightOpengGlView.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.lightOpengGlView.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.lightOpengGlView.startGLThread(false);
            this.lightOpengGlView.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            this.cameraManager.setSurfaceTexture(this.lightOpengGlView.getSurfaceTexture());
            this.cameraManager.prepareCamera(this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getFps(), 17);
        }
        this.startStreamRtp(url);
        this.videoEncoder.start();
        this.audioEncoder.start();
        this.cameraManager.start();
        this.microphoneManager.start();
        this.streaming = true;
        this.onPreview = true;
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        this.microphoneManager.stop();
        this.stopStreamRtp();
        this.videoEncoder.stop();
        this.audioEncoder.stop();
        if (this.openGlView != null && Build.VERSION.SDK_INT >= 18) {
            this.openGlView.removeMediaCodecSurface();
        } else if (this.lightOpengGlView != null && Build.VERSION.SDK_INT >= 18) {
            this.lightOpengGlView.removeMediaCodecSurface();
        }
        this.streaming = false;
    }

    public List<Camera.Size> getResolutionsBack() {
        return this.cameraManager.getPreviewSizeBack();
    }

    public List<Camera.Size> getResolutionsFront() {
        return this.cameraManager.getPreviewSizeFront();
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public void disableVideo() {
        this.videoEncoder.startSendBlackImage();
        this.videoEnabled = false;
    }

    public void enableVideo() {
        this.videoEncoder.stopSendBlackImage();
        this.videoEnabled = true;
    }

    public void switchCamera() throws CameraOpenException {
        if (this.isStreaming() || this.onPreview) {
            this.cameraManager.switchCamera();
        }
    }

    @RequiresApi(api=18)
    public void setFilter(BaseFilterRender baseFilterRender) {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a gif");
        }
        this.openGlView.setFilter(baseFilterRender);
    }

    @RequiresApi(api=18)
    public void setGifStreamObject(GifStreamObject gifStreamObject) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a gif");
        }
        this.openGlView.setGif(gifStreamObject);
    }

    @RequiresApi(api=18)
    public void setImageStreamObject(ImageStreamObject imageStreamObject) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set an image");
        }
        this.openGlView.setImage(imageStreamObject);
    }

    @RequiresApi(api=18)
    public void setTextStreamObject(TextStreamObject textStreamObject) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a text");
        }
        this.openGlView.setText(textStreamObject);
    }

    @RequiresApi(api=18)
    public void clearStreamObject() throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a text");
        }
        this.openGlView.clear();
    }

    @RequiresApi(api=18)
    public void setAlphaStreamObject(float alpha) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set an alpha");
        }
        this.openGlView.setStreamObjectAlpha(alpha);
    }

    @RequiresApi(api=18)
    public void setSizeStreamObject(float sizeX, float sizeY) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a size");
        }
        this.openGlView.setStreamObjectSize(sizeX, sizeY);
    }

    @RequiresApi(api=18)
    public void setPositionStreamObject(float x, float y) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a position");
        }
        this.openGlView.setStreamObjectPosition(x, y);
    }

    @RequiresApi(api=18)
    public void setPositionStreamObject(TranslateTo translateTo) throws RuntimeException {
        if (this.openGlView == null) {
            throw new RuntimeException("You must use OpenGlView in the constructor to set a position");
        }
        this.openGlView.setStreamObjectPosition(translateTo);
    }

    @RequiresApi(api=18)
    public PointF getSizeStreamObject() throws RuntimeException {
        if (this.openGlView != null) {
            return this.openGlView.getScale();
        }
        throw new RuntimeException("You must use OpenGlView in the constructor to get position");
    }

    @RequiresApi(api=18)
    public PointF getPositionStreamObject() throws RuntimeException {
        if (this.openGlView != null) {
            return this.openGlView.getPosition();
        }
        throw new RuntimeException("You must use OpenGlView in the constructor to get scale");
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isOnPreview() {
        return this.onPreview;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setEffect(EffectManager effect) {
        if (this.isStreaming()) {
            this.cameraManager.setEffect(effect);
        }
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        if (Build.VERSION.SDK_INT >= 18 && this.recording && this.audioTrack != -1 && this.canRecord) {
            this.mediaMuxer.writeSampleData(this.audioTrack, aacBuffer, info);
        }
        this.getAacDataRtp(aacBuffer, info);
    }

    protected abstract void onSPSandPPSRtp(ByteBuffer var1, ByteBuffer var2);

    public void onSPSandPPS(ByteBuffer sps, ByteBuffer pps) {
        this.onSPSandPPSRtp(sps, pps);
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getH264Data(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        if (Build.VERSION.SDK_INT >= 18 && this.recording && this.videoTrack != -1) {
            if (info.flags == 1) {
                this.canRecord = true;
            }
            if (this.canRecord) {
                this.mediaMuxer.writeSampleData(this.videoTrack, h264Buffer, info);
            }
        }
        this.getH264DataRtp(h264Buffer, info);
    }

    public void inputPCMData(byte[] buffer, int size) {
        this.audioEncoder.inputPCMData(buffer, size);
    }

    public void inputYUVData(Frame frame) {
        this.videoEncoder.inputYUVData(frame);
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.videoFormat = mediaFormat;
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.audioFormat = mediaFormat;
    }
}

