/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.amf.v0;

import com.pedro.common.ExtensionsKt;
import com.pedro.rtmp.amf.v0.AmfData;
import com.pedro.rtmp.amf.v0.AmfType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/pedro/rtmp/amf/v0/AmfStrictArray;", "Lcom/pedro/rtmp/amf/v0/AmfData;", "items", "", "<init>", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "bodySize", "", "readBody", "", "input", "Ljava/io/InputStream;", "writeBody", "output", "Ljava/io/OutputStream;", "getType", "Lcom/pedro/rtmp/amf/v0/AmfType;", "getSize", "toString", "", "rtmp_release"})
@SourceDebugExtension(value={"SMAP\nAmfStrictArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmfStrictArray.kt\ncom/pedro/rtmp/amf/v0/AmfStrictArray\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n1869#2,2:75\n1869#2,2:77\n37#3:79\n36#3,3:80\n*S KotlinDebug\n*F\n+ 1 AmfStrictArray.kt\ncom/pedro/rtmp/amf/v0/AmfStrictArray\n*L\n36#1:75,2\n61#1:77,2\n72#1:79\n72#1:80,3\n*E\n"})
public final class AmfStrictArray
extends AmfData {
    @NotNull
    private final List<AmfData> items;
    private int bodySize;

    public AmfStrictArray(@NotNull List<AmfData> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.items = items;
        this.bodySize += 4;
        Iterable $this$forEach$iv = this.items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmfData it = (AmfData)element$iv;
            boolean bl = false;
            this.bodySize += it.getSize() + 1;
        }
    }

    public /* synthetic */ AmfStrictArray(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        this(list);
    }

    @NotNull
    public final List<AmfData> getItems() {
        return this.items;
    }

    @Override
    public void readBody(@NotNull InputStream input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.items.clear();
        this.bodySize = 0;
        int length = ExtensionsKt.readUInt32((InputStream)input);
        this.bodySize += 4;
        for (int i = 0; i < length; ++i) {
            AmfData amfData = AmfData.Companion.getAmfData(input);
            this.bodySize += amfData.getSize() + 1;
            this.items.add(amfData);
        }
    }

    @Override
    public void writeBody(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ExtensionsKt.writeUInt32((OutputStream)output, (int)this.items.size());
        Iterable $this$forEach$iv = this.items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmfData it = (AmfData)element$iv;
            boolean bl = false;
            it.writeHeader(output);
            it.writeBody(output);
        }
    }

    @Override
    @NotNull
    public AmfType getType() {
        return AmfType.STRICT_ARRAY;
    }

    @Override
    public int getSize() {
        return this.bodySize;
    }

    @NotNull
    public String toString() {
        Collection $this$toTypedArray$iv = this.items;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String string = Arrays.toString(thisCollection$iv.toArray(new AmfData[0]));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "AmfStrictArray items: " + string;
    }

    public AmfStrictArray() {
        this(null, 1, null);
    }
}

