/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.audio.config;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\u0003H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/pedro/rtmp/flv/audio/config/AudioSpecificConfig;", "", "type", "", "sampleRate", "channels", "(III)V", "AUDIO_SAMPLING_RATES", "", "size", "getSize", "()I", "getFrequency", "write", "", "buffer", "", "offset", "writeAdts", "writeConfig", "rtmp_release"})
public final class AudioSpecificConfig {
    private final int type;
    private final int sampleRate;
    private final int channels;
    @NotNull
    private final int[] AUDIO_SAMPLING_RATES;
    private final int size;

    public AudioSpecificConfig(int type, int sampleRate, int channels) {
        this.type = type;
        this.sampleRate = sampleRate;
        this.channels = channels;
        int[] nArray = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
        this.AUDIO_SAMPLING_RATES = nArray;
        this.size = 9;
    }

    public final int getSize() {
        return this.size;
    }

    public final void write(@NotNull byte[] buffer, int offset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.writeConfig(buffer, offset);
        this.writeAdts(buffer, offset + 2);
    }

    private final void writeConfig(byte[] buffer, int offset) {
        int frequency = this.getFrequency();
        buffer[offset] = (byte)(this.type << 3 | frequency >> 1);
        buffer[offset + 1] = (byte)((frequency << 7 & 0x80) + (this.channels << 3 & 0x78));
    }

    private final void writeAdts(byte[] buffer, int offset) {
        int frequency = this.getFrequency();
        buffer[offset] = -1;
        buffer[offset + 1] = -7;
        buffer[offset + 2] = (byte)(this.type - 1 << 6 | frequency << 2 | this.channels >> 2);
        buffer[offset + 3] = (byte)((this.channels & 3) << 6 | buffer.length >> 11);
        buffer[offset + 4] = (byte)((buffer.length & 0x7FF) >> 3);
        buffer[offset + 5] = (byte)((byte)((buffer.length & 7) << 5) + 31);
        buffer[offset + 6] = -4;
    }

    private final int getFrequency() {
        int frequency = ArraysKt.indexOf((int[])this.AUDIO_SAMPLING_RATES, (int)this.sampleRate);
        if (frequency == -1) {
            frequency = 4;
        }
        return frequency;
    }
}

