/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp.message;

import com.pedro.rtmp.rtmp.chunk.ChunkType;
import com.pedro.rtmp.rtmp.message.Abort;
import com.pedro.rtmp.rtmp.message.Acknowledgement;
import com.pedro.rtmp.rtmp.message.Aggregate;
import com.pedro.rtmp.rtmp.message.Audio;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.MessageType;
import com.pedro.rtmp.rtmp.message.RtmpHeader;
import com.pedro.rtmp.rtmp.message.SetChunkSize;
import com.pedro.rtmp.rtmp.message.SetPeerBandwidth;
import com.pedro.rtmp.rtmp.message.Video;
import com.pedro.rtmp.rtmp.message.WindowAcknowledgementSize;
import com.pedro.rtmp.rtmp.message.command.CommandAmf0;
import com.pedro.rtmp.rtmp.message.command.CommandAmf3;
import com.pedro.rtmp.rtmp.message.control.UserControl;
import com.pedro.rtmp.rtmp.message.data.DataAmf0;
import com.pedro.rtmp.rtmp.message.data.DataAmf3;
import com.pedro.rtmp.rtmp.message.shared.SharedObjectAmf0;
import com.pedro.rtmp.rtmp.message.shared.SharedObjectAmf3;
import com.pedro.rtmp.utils.CommandSessionHistory;
import com.pedro.rtmp.utils.RtmpConfig;
import com.pedro.rtmp.utils.UtilsKt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H&J\b\u0010\u0016\u001a\u00020\u0017H&J\b\u0010\u0018\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\u001bH&R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/pedro/rtmp/rtmp/message/RtmpMessage;", "", "basicHeader", "Lcom/pedro/rtmp/rtmp/message/BasicHeader;", "<init>", "(Lcom/pedro/rtmp/rtmp/message/BasicHeader;)V", "header", "Lcom/pedro/rtmp/rtmp/message/RtmpHeader;", "getHeader", "()Lcom/pedro/rtmp/rtmp/message/RtmpHeader;", "header$delegate", "Lkotlin/Lazy;", "updateHeader", "", "rtmpHeader", "writeHeader", "output", "Ljava/io/OutputStream;", "writeBody", "readBody", "input", "Ljava/io/InputStream;", "storeBody", "", "getType", "Lcom/pedro/rtmp/rtmp/message/MessageType;", "getSize", "", "Companion", "rtmp_release"})
public abstract class RtmpMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy header$delegate;
    @NotNull
    private static final String TAG = "RtmpMessage";

    public RtmpMessage(@NotNull BasicHeader basicHeader) {
        Intrinsics.checkNotNullParameter((Object)basicHeader, (String)"basicHeader");
        this.header$delegate = LazyKt.lazy(() -> RtmpMessage.header_delegate$lambda$1(basicHeader, this));
    }

    @NotNull
    public final RtmpHeader getHeader() {
        Lazy lazy = this.header$delegate;
        return (RtmpHeader)lazy.getValue();
    }

    public final void updateHeader(@NotNull RtmpHeader rtmpHeader) {
        Intrinsics.checkNotNullParameter((Object)rtmpHeader, (String)"rtmpHeader");
        this.getHeader().setBasicHeader(rtmpHeader.getBasicHeader());
        this.getHeader().setMessageType(rtmpHeader.getMessageType());
        this.getHeader().setMessageLength(rtmpHeader.getMessageLength());
        this.getHeader().setMessageStreamId(rtmpHeader.getMessageStreamId());
        this.getHeader().setTimeStamp(rtmpHeader.getTimeStamp());
    }

    public final void writeHeader(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.getHeader().writeHeader(output);
    }

    public final void writeBody(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        int chunkSize = RtmpConfig.INSTANCE.getWriteChunkSize();
        byte[] bytes = this.storeBody();
        int pos = 0;
        int length = this.getSize();
        while (length > chunkSize) {
            output.write(bytes, pos, chunkSize);
            length -= chunkSize;
            pos += chunkSize;
            this.getHeader().writeHeader(new BasicHeader(ChunkType.TYPE_3, this.getHeader().getBasicHeader().getChunkStreamId()), output);
        }
        output.write(bytes, pos, length);
    }

    public abstract void readBody(@NotNull InputStream var1);

    @NotNull
    public abstract byte[] storeBody();

    @NotNull
    public abstract MessageType getType();

    public abstract int getSize();

    private static final RtmpHeader header_delegate$lambda$1(BasicHeader $basicHeader, RtmpMessage this$0) {
        RtmpHeader rtmpHeader;
        Intrinsics.checkNotNullParameter((Object)$basicHeader, (String)"$basicHeader");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RtmpHeader $this$header_delegate_u24lambda_u241_u24lambda_u240 = rtmpHeader = new RtmpHeader($basicHeader);
        boolean bl = false;
        $this$header_delegate_u24lambda_u241_u24lambda_u240.setMessageType(this$0.getType());
        $this$header_delegate_u24lambda_u241_u24lambda_u240.setMessageLength(this$0.getSize());
        return rtmpHeader;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ(\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/pedro/rtmp/rtmp/message/RtmpMessage$Companion;", "", "<init>", "()V", "TAG", "", "getRtmpMessage", "Lcom/pedro/rtmp/rtmp/message/RtmpMessage;", "input", "Ljava/io/InputStream;", "chunkSize", "", "commandSessionHistory", "Lcom/pedro/rtmp/utils/CommandSessionHistory;", "getMarkType", "Lcom/pedro/rtmp/rtmp/message/MessageType;", "type", "getInputWithoutChunks", "header", "Lcom/pedro/rtmp/rtmp/message/RtmpHeader;", "rtmp_release"})
    @SourceDebugExtension(value={"SMAP\nRtmpMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtmpMessage.kt\ncom/pedro/rtmp/rtmp/message/RtmpMessage$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RtmpMessage getRtmpMessage(@NotNull InputStream input, int chunkSize, @NotNull CommandSessionHistory commandSessionHistory) throws IOException {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)commandSessionHistory, (String)"commandSessionHistory");
            RtmpHeader header = RtmpHeader.Companion.readHeader$default(RtmpHeader.Companion, input, commandSessionHistory, 0, 4, null);
            MessageType messageType = header.getMessageType();
            RtmpMessage rtmpMessage = switch (messageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
                case 1 -> new SetChunkSize(0, 1, null);
                case 2 -> new Abort(0, 1, null);
                case 3 -> new Acknowledgement(0, 1, null);
                case 4 -> new UserControl(null, null, 3, null);
                case 5 -> new WindowAcknowledgementSize(0, 0, 3, null);
                case 6 -> new SetPeerBandwidth(0, null, 3, null);
                case 7 -> new Audio(null, 0, 3, null);
                case 8 -> new Video(null, 0, 3, null);
                case 9 -> new DataAmf3(null, 0, 0, null, 15, null);
                case 10 -> new SharedObjectAmf3();
                case 11 -> new CommandAmf3(null, 0, 0, 0, null, 31, null);
                case 12 -> new DataAmf0(null, 0, 0, null, 15, null);
                case 13 -> new SharedObjectAmf0();
                case 14 -> new CommandAmf0(null, 0, 0, 0, null, 31, null);
                case 15 -> new Aggregate();
                default -> throw new IOException("Unimplemented message type: " + header.getMessageType());
            };
            rtmpMessage.updateHeader(header);
            InputStream bodyInput = header.getMessageLength() > chunkSize ? this.getInputWithoutChunks(input, header, chunkSize, commandSessionHistory) : input;
            rtmpMessage.readBody(bodyInput);
            return rtmpMessage;
        }

        @NotNull
        public final MessageType getMarkType(int type) {
            Object v0;
            block2: {
                Iterable iterable = (Iterable)MessageType.getEntries();
                for (Object t : iterable) {
                    MessageType it = (MessageType)((Object)t);
                    boolean bl = false;
                    if (!(it.getMark() == type)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            MessageType messageType = v0;
            if (messageType == null) {
                throw new IOException("Unknown rtmp message type: " + type);
            }
            return messageType;
        }

        private final InputStream getInputWithoutChunks(InputStream input, RtmpHeader header, int chunkSize, CommandSessionHistory commandSessionHistory) {
            byte[] chunk;
            ByteArrayOutputStream packetStore = new ByteArrayOutputStream();
            for (int bytesRead = 0; bytesRead < header.getMessageLength(); bytesRead += chunk.length) {
                chunk = null;
                if (header.getMessageLength() - bytesRead < chunkSize) {
                    chunk = new byte[header.getMessageLength() - bytesRead];
                    UtilsKt.readUntil(input, chunk);
                } else {
                    chunk = new byte[chunkSize];
                    UtilsKt.readUntil(input, chunk);
                    RtmpHeader.Companion.readHeader(input, commandSessionHistory, header.getTimeStamp());
                }
                packetStore.write(chunk);
            }
            return new ByteArrayInputStream(packetStore.toByteArray());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MessageType.values().length];
                try {
                    nArray[MessageType.SET_CHUNK_SIZE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.ABORT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.ACKNOWLEDGEMENT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.USER_CONTROL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.WINDOW_ACKNOWLEDGEMENT_SIZE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.SET_PEER_BANDWIDTH.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.AUDIO.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.VIDEO.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.DATA_AMF3.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.SHARED_OBJECT_AMF3.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.COMMAND_AMF3.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.DATA_AMF0.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.SHARED_OBJECT_AMF0.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.COMMAND_AMF0.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.AGGREGATE.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

