/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.video;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.common.ExtensionsKt;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.video.FourCCPacketType;
import com.pedro.rtmp.flv.video.VideoDataType;
import com.pedro.rtmp.flv.video.VideoFormat;
import com.pedro.rtmp.flv.video.VideoNalType;
import com.pedro.rtmp.flv.video.VideoSpecificConfigHEVC;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f0\u0015J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u001a\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010\u001c\u001a\u00020\u0006J\u001e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0011J \u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/pedro/rtmp/flv/video/H265Packet;", "", "()V", "TAG", "", "configSend", "", "header", "", "naluSize", "", "pps", "sps", "vps", "createFlvVideoPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "callback", "Lkotlin/Function1;", "Lcom/pedro/rtmp/flv/FlvPacket;", "getHeaderSize", "getStartCodeSize", "removeHeader", "size", "reset", "resetInfo", "sendVideoInfo", "writeNaluSize", "buffer", "offset", "rtmp_release"})
public final class H265Packet {
    @NotNull
    private final String TAG;
    @NotNull
    private final byte[] header = new byte[8];
    private final int naluSize;
    private boolean configSend;
    @Nullable
    private byte[] sps;
    @Nullable
    private byte[] pps;
    @Nullable
    private byte[] vps;

    public H265Packet() {
        this.TAG = "H265Packet";
        this.naluSize = 4;
    }

    public final void sendVideoInfo(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @NotNull ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Intrinsics.checkNotNullParameter((Object)vps, (String)"vps");
        ByteBuffer mSps = H265Packet.removeHeader$default(this, sps, 0, 2, null);
        ByteBuffer mPps = H265Packet.removeHeader$default(this, pps, 0, 2, null);
        ByteBuffer mVps = H265Packet.removeHeader$default(this, vps, 0, 2, null);
        byte[] spsBytes = new byte[mSps.remaining()];
        byte[] ppsBytes = new byte[mPps.remaining()];
        byte[] vpsBytes = new byte[mVps.remaining()];
        mSps.get(spsBytes, 0, spsBytes.length);
        mPps.get(ppsBytes, 0, ppsBytes.length);
        mVps.get(vpsBytes, 0, vpsBytes.length);
        this.sps = spsBytes;
        this.pps = ppsBytes;
        this.vps = vpsBytes;
    }

    public final void createFlvVideoPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo info, @NotNull Function1<? super FlvPacket, Unit> callback) {
        int headerSize;
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)byteBuffer, (MediaCodec.BufferInfo)info);
        long ts = info.presentationTimeUs / (long)1000;
        int codec = VideoFormat.HEVC.getValue();
        this.header[1] = (byte)(codec >> 24);
        this.header[2] = (byte)(codec >> 16);
        this.header[3] = (byte)(codec >> 8);
        this.header[4] = (byte)codec;
        int cts = 0;
        int ctsLength = 3;
        this.header[5] = (byte)(cts >> 16);
        this.header[6] = (byte)(cts >> 8);
        this.header[7] = (byte)cts;
        byte[] buffer = null;
        if (!this.configSend) {
            this.header[0] = (byte)(0x80 | VideoDataType.KEYFRAME.getValue() << 4 | FourCCPacketType.SEQUENCE_START.getValue());
            byte[] sps = this.sps;
            byte[] pps = this.pps;
            byte[] vps = this.vps;
            if (sps == null || pps == null || vps == null) {
                Log.e((String)this.TAG, (String)"waiting for a valid sps and pps");
                return;
            }
            VideoSpecificConfigHEVC config = new VideoSpecificConfigHEVC(sps, pps, vps);
            buffer = new byte[config.getSize() + this.header.length - ctsLength];
            config.write(buffer, this.header.length - ctsLength);
            System.arraycopy(this.header, 0, buffer, 0, this.header.length - ctsLength);
            callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.VIDEO));
            this.configSend = true;
        }
        if ((headerSize = this.getHeaderSize(fixedBuffer)) == 0) {
            return;
        }
        fixedBuffer.rewind();
        ByteBuffer validBuffer = this.removeHeader(fixedBuffer, headerSize);
        int size = validBuffer.remaining();
        buffer = new byte[this.header.length + size + this.naluSize];
        int type = validBuffer.get(0) >> 1;
        int nalType = VideoDataType.INTER_FRAME.getValue();
        if (type == VideoNalType.IDR_N_LP.getValue() || type == VideoNalType.IDR_W_DLP.getValue() || ExtensionsKt.isKeyframe((MediaCodec.BufferInfo)info)) {
            nalType = VideoDataType.KEYFRAME.getValue();
        } else if (type == VideoNalType.HEVC_VPS.getValue() || type == VideoNalType.HEVC_SPS.getValue() || type == VideoNalType.HEVC_PPS.getValue()) {
            return;
        }
        this.header[0] = (byte)(0x80 | nalType << 4 | FourCCPacketType.CODED_FRAMES.getValue());
        this.writeNaluSize(buffer, this.header.length, size);
        validBuffer.get(buffer, this.header.length + this.naluSize, size);
        System.arraycopy(this.header, 0, buffer, 0, this.header.length);
        callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.VIDEO));
    }

    private final void writeNaluSize(byte[] buffer, int offset, int size) {
        buffer[offset] = (byte)(size >>> 24);
        buffer[offset + 1] = (byte)(size >>> 16);
        buffer[offset + 2] = (byte)(size >>> 8);
        buffer[offset + 3] = (byte)size;
    }

    private final ByteBuffer removeHeader(ByteBuffer byteBuffer, int size) {
        int position = size == -1 ? this.getStartCodeSize(byteBuffer) : size;
        byteBuffer.position(position);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"slice(...)");
        return byteBuffer2;
    }

    static /* synthetic */ ByteBuffer removeHeader$default(H265Packet h265Packet, ByteBuffer byteBuffer, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return h265Packet.removeHeader(byteBuffer, n);
    }

    private final int getHeaderSize(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < 4) {
            return 0;
        }
        byte[] sps = this.sps;
        byte[] pps = this.pps;
        byte[] vps = this.vps;
        if (sps != null && pps != null && vps != null) {
            int startCodeSize = this.getStartCodeSize(byteBuffer);
            if (startCodeSize == 0) {
                return 0;
            }
            int n = 0;
            byte[] byArray = new byte[startCodeSize];
            while (n < startCodeSize) {
                int n2 = n++;
                byArray[n2] = 0;
            }
            byte[] startCode = byArray;
            startCode[startCodeSize - 1] = 1;
            byte[] avcHeader = ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])startCode, (byte[])vps), (byte[])startCode), (byte[])sps), (byte[])startCode), (byte[])pps), (byte[])startCode);
            if (byteBuffer.remaining() < avcHeader.length) {
                return startCodeSize;
            }
            byte[] possibleAvcHeader = new byte[avcHeader.length];
            byteBuffer.get(possibleAvcHeader, 0, possibleAvcHeader.length);
            return Arrays.equals(avcHeader, possibleAvcHeader) ? avcHeader.length : startCodeSize;
        }
        return 0;
    }

    private final int getStartCodeSize(ByteBuffer byteBuffer) {
        int startCodeSize = 0;
        if (byteBuffer.get(0) == 0 && byteBuffer.get(1) == 0 && byteBuffer.get(2) == 0 && byteBuffer.get(3) == 1) {
            startCodeSize = 4;
        } else if (byteBuffer.get(0) == 0 && byteBuffer.get(1) == 0 && byteBuffer.get(2) == 1) {
            startCodeSize = 3;
        }
        return startCodeSize;
    }

    public final void reset(boolean resetInfo) {
        if (resetInfo) {
            this.sps = null;
            this.pps = null;
            this.vps = null;
        }
        this.configSend = false;
    }

    public static /* synthetic */ void reset$default(H265Packet h265Packet, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        h265Packet.reset(bl);
    }
}

