/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.audio.AacPacket;
import com.pedro.rtmp.flv.audio.AudioPacketCallback;
import com.pedro.rtmp.flv.video.H264Packet;
import com.pedro.rtmp.flv.video.ProfileIop;
import com.pedro.rtmp.flv.video.VideoPacketCallback;
import com.pedro.rtmp.rtmp.CommandsManager;
import com.pedro.rtmp.utils.BitrateManager;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtmp.utils.socket.RtmpSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 J2\u00020\u00012\u00020\u0002:\u0001JB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020\u000bJ\u0006\u0010)\u001a\u00020\u001aJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0016H\u0016J\u0010\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0016H\u0016J\u0006\u0010.\u001a\u00020+J\u0006\u0010/\u001a\u00020+J\u0006\u00100\u001a\u00020+J\u0006\u00101\u001a\u00020+J\u000e\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020&J\u0016\u00104\u001a\u00020+2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J\u0016\u00109\u001a\u00020+2\u0006\u0010:\u001a\u0002062\u0006\u00107\u001a\u000208J\u0016\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020&2\u0006\u0010=\u001a\u00020\u001aJ\u000e\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020\u001aJ\u000e\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020BJ \u0010C\u001a\u00020+2\u0006\u0010D\u001a\u0002062\u0006\u0010E\u001a\u0002062\b\u0010F\u001a\u0004\u0018\u000106J\u0006\u0010G\u001a\u00020+J\u0010\u0010H\u001a\u00020+2\b\b\u0002\u0010I\u001a\u00020\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/pedro/rtmp/rtmp/RtmpSender;", "Lcom/pedro/rtmp/flv/audio/AudioPacketCallback;", "Lcom/pedro/rtmp/flv/video/VideoPacketCallback;", "connectCheckerRtmp", "Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;", "commandsManager", "Lcom/pedro/rtmp/rtmp/CommandsManager;", "(Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;Lcom/pedro/rtmp/rtmp/CommandsManager;)V", "aacPacket", "Lcom/pedro/rtmp/flv/audio/AacPacket;", "audioFramesSent", "", "bitrateManager", "Lcom/pedro/rtmp/utils/BitrateManager;", "<set-?>", "droppedAudioFrames", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "flvPacketBlockingQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/rtmp/flv/FlvPacket;", "h264Packet", "Lcom/pedro/rtmp/flv/video/H264Packet;", "isEnableLogs", "", "running", "socket", "Lcom/pedro/rtmp/utils/socket/RtmpSocket;", "getSocket", "()Lcom/pedro/rtmp/utils/socket/RtmpSocket;", "setSocket", "(Lcom/pedro/rtmp/utils/socket/RtmpSocket;)V", "thread", "Ljava/util/concurrent/ExecutorService;", "videoFramesSent", "getCacheSize", "", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "onAudioFrameCreated", "", "flvPacket", "onVideoFrameCreated", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudioFrame", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideoFrame", "h264Buffer", "setAudioInfo", "sampleRate", "isStereo", "setLogs", "enable", "setProfileIop", "profileIop", "Lcom/pedro/rtmp/flv/video/ProfileIop;", "setVideoInfo", "sps", "pps", "vps", "start", "stop", "clear", "Companion", "rtmp_release"})
public final class RtmpSender
implements AudioPacketCallback,
VideoPacketCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectCheckerRtmp connectCheckerRtmp;
    @NotNull
    private final CommandsManager commandsManager;
    @NotNull
    private AacPacket aacPacket;
    @NotNull
    private H264Packet h264Packet;
    private volatile boolean running;
    @NotNull
    private volatile BlockingQueue<FlvPacket> flvPacketBlockingQueue;
    @Nullable
    private ExecutorService thread;
    private long audioFramesSent;
    private long videoFramesSent;
    @Nullable
    private RtmpSocket socket;
    private long droppedAudioFrames;
    private long droppedVideoFrames;
    @NotNull
    private final BitrateManager bitrateManager;
    private boolean isEnableLogs;
    @NotNull
    private static final String TAG = "RtmpSender";

    public RtmpSender(@NotNull ConnectCheckerRtmp connectCheckerRtmp, @NotNull CommandsManager commandsManager) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtmp, (String)"connectCheckerRtmp");
        Intrinsics.checkNotNullParameter((Object)commandsManager, (String)"commandsManager");
        this.connectCheckerRtmp = connectCheckerRtmp;
        this.commandsManager = commandsManager;
        this.aacPacket = new AacPacket(this);
        this.h264Packet = new H264Packet(this);
        this.flvPacketBlockingQueue = new LinkedBlockingQueue(60);
        this.bitrateManager = new BitrateManager(this.connectCheckerRtmp);
        this.isEnableLogs = true;
    }

    @Nullable
    public final RtmpSocket getSocket() {
        return this.socket;
    }

    public final void setSocket(@Nullable RtmpSocket rtmpSocket) {
        this.socket = rtmpSocket;
    }

    public final long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    public final long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.h264Packet.sendVideoInfo(sps, pps);
    }

    public final void setProfileIop(@NotNull ProfileIop profileIop) {
        Intrinsics.checkNotNullParameter((Object)((Object)profileIop), (String)"profileIop");
        this.h264Packet.setProfileIop(profileIop);
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        AacPacket.sendAudioInfo$default(this.aacPacket, sampleRate, isStereo, null, 4, null);
    }

    public final void sendVideoFrame(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running) {
            this.h264Packet.createFlvVideoPacket(h264Buffer, info);
        }
    }

    public final void sendAudioFrame(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running) {
            this.aacPacket.createFlvAudioPacket(aacBuffer, info);
        }
    }

    @Override
    public void onVideoFrameCreated(@NotNull FlvPacket flvPacket) {
        Intrinsics.checkNotNullParameter((Object)flvPacket, (String)"flvPacket");
        try {
            this.flvPacketBlockingQueue.add(flvPacket);
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)"Video frame discarded");
            long l = this.droppedVideoFrames;
            this.droppedVideoFrames = l + 1L;
        }
    }

    @Override
    public void onAudioFrameCreated(@NotNull FlvPacket flvPacket) {
        Intrinsics.checkNotNullParameter((Object)flvPacket, (String)"flvPacket");
        try {
            this.flvPacketBlockingQueue.add(flvPacket);
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)"Audio frame discarded");
            long l = this.droppedAudioFrames;
            this.droppedAudioFrames = l + 1L;
        }
    }

    public final void start() {
        block0: {
            this.thread = Executors.newSingleThreadExecutor();
            this.running = true;
            ExecutorService executorService = this.thread;
            if (executorService == null) break block0;
            executorService.execute(() -> RtmpSender.start$lambda-2(this));
        }
    }

    public final void stop(boolean clear) {
        this.running = false;
        ExecutorService executorService = this.thread;
        if (executorService != null) {
            executorService.shutdownNow();
        }
        try {
            ExecutorService executorService2;
            ExecutorService executorService3 = executorService2 = this.thread;
            if (executorService3 != null) {
                executorService3.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
        this.flvPacketBlockingQueue.clear();
        this.aacPacket.reset();
        this.h264Packet.reset(clear);
        this.resetSentAudioFrames();
        this.resetSentVideoFrames();
        this.resetDroppedAudioFrames();
        this.resetDroppedVideoFrames();
    }

    public static /* synthetic */ void stop$default(RtmpSender rtmpSender, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        rtmpSender.stop(bl);
    }

    public final boolean hasCongestion() {
        float remaining;
        float capacity;
        float size = this.flvPacketBlockingQueue.size();
        return size >= (capacity = size + (remaining = (float)this.flvPacketBlockingQueue.remainingCapacity())) * 0.2f;
    }

    public final void resizeCache(int newSize) {
        if (newSize < this.flvPacketBlockingQueue.size() - this.flvPacketBlockingQueue.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        BlockingQueue tempQueue = new LinkedBlockingQueue(newSize);
        this.flvPacketBlockingQueue.drainTo(tempQueue);
        this.flvPacketBlockingQueue = tempQueue;
    }

    public final int getCacheSize() {
        return this.flvPacketBlockingQueue.size();
    }

    public final long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public final long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public final void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public final void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public final void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public final void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }

    public final void setLogs(boolean enable) {
        this.isEnableLogs = enable;
    }

    private static final void start$lambda-2(RtmpSender this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        while (!Thread.interrupted() && this$0.running) {
            try {
                RtmpSocket socket;
                long l;
                FlvPacket flvPacket = this$0.flvPacketBlockingQueue.poll(1L, TimeUnit.SECONDS);
                if (flvPacket == null) {
                    Log.i((String)TAG, (String)"Skipping iteration, frame null");
                    continue;
                }
                int size = 0;
                if (flvPacket.getType() == FlvType.VIDEO) {
                    l = this$0.videoFramesSent;
                    this$0.videoFramesSent = l + 1L;
                    if (this$0.socket != null) {
                        boolean bl = false;
                        size = this$0.commandsManager.sendVideoPacket(flvPacket, socket);
                        if (this$0.isEnableLogs) {
                            Log.i((String)TAG, (String)("wrote Video packet, size " + size));
                        }
                    }
                } else {
                    l = this$0.audioFramesSent;
                    this$0.audioFramesSent = l + 1L;
                    if (this$0.socket != null) {
                        boolean bl = false;
                        size = this$0.commandsManager.sendAudioPacket(flvPacket, socket);
                        if (this$0.isEnableLogs) {
                            Log.i((String)TAG, (String)("wrote Audio packet, size " + size));
                        }
                    }
                }
                this$0.bitrateManager.calculateBitrate((long)size * 8L);
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedException) && this$0.running) {
                    this$0.connectCheckerRtmp.onConnectionFailedRtmp("Error send packet, " + e.getMessage());
                    Log.e((String)TAG, (String)"send error: ", (Throwable)e);
                }
                return;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pedro/rtmp/rtmp/RtmpSender$Companion;", "", "()V", "TAG", "", "rtmp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

