/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.util.Log;
import com.pedro.rtmp.utils.UtilsKt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pedro/rtmp/rtmp/Handshake;", "", "()V", "TAG", "", "handshakeSize", "", "protocolVersion", "timestampC1", "readS0", "", "input", "Ljava/io/InputStream;", "readS1", "readS2", "c1", "sendHandshake", "", "output", "Ljava/io/OutputStream;", "writeC0", "", "writeC1", "writeC2", "s1", "rtmp_release"})
public final class Handshake {
    @NotNull
    private final String TAG;
    private final int protocolVersion;
    private final int handshakeSize;
    private int timestampC1;

    public Handshake() {
        this.TAG = "Handshake";
        this.protocolVersion = 3;
        this.handshakeSize = 1536;
    }

    public final boolean sendHandshake(@NotNull InputStream input, @NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.writeC0(output);
        byte[] c1 = this.writeC1(output);
        output.flush();
        this.readS0(input);
        byte[] s1 = this.readS1(input);
        this.writeC2(output, s1);
        output.flush();
        this.readS2(input, c1);
        return true;
    }

    private final void writeC0(OutputStream output) throws IOException {
        Log.i((String)this.TAG, (String)"writing C0");
        output.write(this.protocolVersion);
        Log.i((String)this.TAG, (String)"C0 write successful");
    }

    private final byte[] writeC1(OutputStream output) throws IOException {
        Log.i((String)this.TAG, (String)"writing C1");
        byte[] c1 = new byte[this.handshakeSize];
        this.timestampC1 = (int)(System.currentTimeMillis() / (long)1000);
        Log.i((String)this.TAG, (String)("writing time " + this.timestampC1 + " to c1"));
        byte[] timestampData = new byte[]{(byte)(this.timestampC1 >>> 24), (byte)(this.timestampC1 >>> 16), (byte)(this.timestampC1 >>> 8), (byte)this.timestampC1};
        System.arraycopy(timestampData, 0, c1, 0, timestampData.length);
        Log.i((String)this.TAG, (String)"writing zero to c1");
        byte[] byArray = new byte[]{0, 0, 0, 0};
        byte[] zeroData = byArray;
        System.arraycopy(zeroData, 0, c1, timestampData.length, zeroData.length);
        Log.i((String)this.TAG, (String)"writing random to c1");
        Random.Default random = Random.Default;
        byte[] randomData = new byte[this.handshakeSize - 8];
        int n = 0;
        int n2 = randomData.length + -1;
        if (n <= n2) {
            do {
                byte uInt8;
                int i = n++;
                randomData[i] = uInt8 = (byte)random.nextInt();
            } while (n <= n2);
        }
        System.arraycopy(randomData, 0, c1, 8, randomData.length);
        output.write(c1);
        Log.i((String)this.TAG, (String)"C1 write successful");
        return c1;
    }

    private final void writeC2(OutputStream output, byte[] s1) throws IOException {
        Log.i((String)this.TAG, (String)"writing C2");
        output.write(s1);
        Log.i((String)this.TAG, (String)"C2 write successful");
    }

    private final byte[] readS0(InputStream input) throws IOException {
        Log.i((String)this.TAG, (String)"reading S0");
        int response = input.read();
        if (response == this.protocolVersion || response == 72) {
            Log.i((String)this.TAG, (String)"read S0 successful");
            byte[] byArray = new byte[]{(byte)response};
            return byArray;
        }
        throw new IOException(this.TAG + " error, unexpected " + response + " S0 received");
    }

    private final byte[] readS1(InputStream input) throws IOException {
        Log.i((String)this.TAG, (String)"reading S1");
        byte[] s1 = new byte[this.handshakeSize];
        UtilsKt.readUntil(input, s1);
        Log.i((String)this.TAG, (String)"read S1 successful");
        return s1;
    }

    private final byte[] readS2(InputStream input, byte[] c1) throws IOException {
        Log.i((String)this.TAG, (String)"reading S2");
        byte[] s2 = new byte[this.handshakeSize];
        UtilsKt.readUntil(input, s2);
        if (!Arrays.equals(s2, c1)) {
            Log.e((String)this.TAG, (String)"S2 content is different that C1");
        }
        Log.i((String)this.TAG, (String)"read S2 successful");
        return s2;
    }
}

