/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.util.Log;
import com.pedro.rtmp.amf.v0.AmfEcmaArray;
import com.pedro.rtmp.amf.v0.AmfNull;
import com.pedro.rtmp.amf.v0.AmfObject;
import com.pedro.rtmp.amf.v0.AmfString;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.rtmp.chunk.ChunkStreamId;
import com.pedro.rtmp.rtmp.chunk.ChunkType;
import com.pedro.rtmp.rtmp.message.Audio;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.RtmpMessage;
import com.pedro.rtmp.rtmp.message.SetChunkSize;
import com.pedro.rtmp.rtmp.message.Video;
import com.pedro.rtmp.rtmp.message.WindowAcknowledgementSize;
import com.pedro.rtmp.rtmp.message.command.CommandAmf0;
import com.pedro.rtmp.rtmp.message.control.Event;
import com.pedro.rtmp.rtmp.message.control.Type;
import com.pedro.rtmp.rtmp.message.control.UserControl;
import com.pedro.rtmp.rtmp.message.data.DataAmf0;
import com.pedro.rtmp.utils.CommandSessionHistory;
import com.pedro.rtmp.utils.RtmpConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JJ\b\u0010K\u001a\u00020\u0014H\u0002J\u000e\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0006\u0010P\u001a\u00020HJ\u0016\u0010Q\u001a\u00020\u00142\u0006\u0010R\u001a\u00020S2\u0006\u0010I\u001a\u00020JJ\u000e\u0010T\u001a\u00020H2\u0006\u0010I\u001a\u00020JJ\u000e\u0010U\u001a\u00020H2\u0006\u0010I\u001a\u00020JJ\u0016\u0010V\u001a\u00020H2\u0006\u0010W\u001a\u00020\u00042\u0006\u0010I\u001a\u00020JJ\u000e\u0010X\u001a\u00020H2\u0006\u0010I\u001a\u00020JJ\u0016\u0010Y\u001a\u00020H2\u0006\u0010Z\u001a\u00020[2\u0006\u0010I\u001a\u00020JJ\u000e\u0010\\\u001a\u00020H2\u0006\u0010I\u001a\u00020JJ\u0016\u0010]\u001a\u00020\u00142\u0006\u0010R\u001a\u00020S2\u0006\u0010I\u001a\u00020JJ\u000e\u0010^\u001a\u00020H2\u0006\u0010I\u001a\u00020JJ\u0016\u0010_\u001a\u00020H2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0006J\u001a\u0010`\u001a\u00020H2\b\u0010@\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004J\u000e\u0010a\u001a\u00020H2\u0006\u0010\u0015\u001a\u00020\u0014J\u0016\u0010b\u001a\u00020H2\u0006\u0010F\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\nR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\b\"\u0004\b\u001d\u0010\nR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\r\"\u0004\b \u0010\u000fR\u001a\u0010!\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u000e\u0010)\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010#\"\u0004\b6\u0010%R\u001a\u00107\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\r\"\u0004\b9\u0010\u000fR\u001a\u0010:\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\r\"\u0004\b<\u0010\u000fR\u001a\u0010=\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010#\"\u0004\b?\u0010%R\u001c\u0010@\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\r\"\u0004\bB\u0010\u000fR\u001a\u0010C\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\b\"\u0004\bE\u0010\nR\u000e\u0010F\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/pedro/rtmp/rtmp/CommandsManager;", "", "()V", "TAG", "", "akamaiTs", "", "getAkamaiTs", "()Z", "setAkamaiTs", "(Z)V", "appName", "getAppName", "()Ljava/lang/String;", "setAppName", "(Ljava/lang/String;)V", "audioDisabled", "getAudioDisabled", "setAudioDisabled", "commandId", "", "fps", "height", "host", "getHost", "setHost", "isStereo", "onAuth", "getOnAuth", "setOnAuth", "password", "getPassword", "setPassword", "port", "getPort", "()I", "setPort", "(I)V", "readChunkSize", "getReadChunkSize", "setReadChunkSize", "sampleRate", "sessionHistory", "Lcom/pedro/rtmp/utils/CommandSessionHistory;", "getSessionHistory", "()Lcom/pedro/rtmp/utils/CommandSessionHistory;", "startTs", "", "getStartTs", "()J", "setStartTs", "(J)V", "streamId", "getStreamId", "setStreamId", "streamName", "getStreamName", "setStreamName", "tcUrl", "getTcUrl", "setTcUrl", "timestamp", "getTimestamp", "setTimestamp", "user", "getUser", "setUser", "videoDisabled", "getVideoDisabled", "setVideoDisabled", "width", "createStream", "", "output", "Ljava/io/OutputStream;", "getCurrentTimestamp", "readMessageResponse", "Lcom/pedro/rtmp/rtmp/message/RtmpMessage;", "input", "Ljava/io/InputStream;", "reset", "sendAudioPacket", "flvPacket", "Lcom/pedro/rtmp/flv/FlvPacket;", "sendChunkSize", "sendClose", "sendConnect", "auth", "sendMetadata", "sendPong", "event", "Lcom/pedro/rtmp/rtmp/message/control/Event;", "sendPublish", "sendVideoPacket", "sendWindowAcknowledgementSize", "setAudioInfo", "setAuth", "setFps", "setVideoResolution", "rtmp_release"})
public final class CommandsManager {
    @NotNull
    private final String TAG;
    @NotNull
    private final CommandSessionHistory sessionHistory = new CommandSessionHistory(null, null, 3, null);
    private int timestamp;
    private int commandId;
    private int streamId;
    @NotNull
    private String host = "";
    private int port = 1935;
    @NotNull
    private String appName = "";
    @NotNull
    private String streamName = "";
    @NotNull
    private String tcUrl = "";
    @Nullable
    private String user;
    @Nullable
    private String password;
    private boolean onAuth;
    private boolean akamaiTs;
    private long startTs;
    private int readChunkSize = 128;
    private boolean audioDisabled;
    private boolean videoDisabled;
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int sampleRate = 44100;
    private boolean isStereo = true;

    public CommandsManager() {
        this.TAG = "CommandsManager";
    }

    @NotNull
    public final CommandSessionHistory getSessionHistory() {
        return this.sessionHistory;
    }

    public final int getTimestamp() {
        return this.timestamp;
    }

    public final void setTimestamp(int n) {
        this.timestamp = n;
    }

    public final int getStreamId() {
        return this.streamId;
    }

    public final void setStreamId(int n) {
        this.streamId = n;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getAppName() {
        return this.appName;
    }

    public final void setAppName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.appName = string;
    }

    @NotNull
    public final String getStreamName() {
        return this.streamName;
    }

    public final void setStreamName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.streamName = string;
    }

    @NotNull
    public final String getTcUrl() {
        return this.tcUrl;
    }

    public final void setTcUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.tcUrl = string;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    public final void setUser(@Nullable String string) {
        this.user = string;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(@Nullable String string) {
        this.password = string;
    }

    public final boolean getOnAuth() {
        return this.onAuth;
    }

    public final void setOnAuth(boolean bl) {
        this.onAuth = bl;
    }

    public final boolean getAkamaiTs() {
        return this.akamaiTs;
    }

    public final void setAkamaiTs(boolean bl) {
        this.akamaiTs = bl;
    }

    public final long getStartTs() {
        return this.startTs;
    }

    public final void setStartTs(long l) {
        this.startTs = l;
    }

    public final int getReadChunkSize() {
        return this.readChunkSize;
    }

    public final void setReadChunkSize(int n) {
        this.readChunkSize = n;
    }

    public final boolean getAudioDisabled() {
        return this.audioDisabled;
    }

    public final void setAudioDisabled(boolean bl) {
        this.audioDisabled = bl;
    }

    public final boolean getVideoDisabled() {
        return this.videoDisabled;
    }

    public final void setVideoDisabled(boolean bl) {
        this.videoDisabled = bl;
    }

    public final void setVideoResolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public final void setFps(int fps) {
        this.fps = fps;
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.sampleRate = sampleRate;
        this.isStereo = isStereo;
    }

    public final void setAuth(@Nullable String user, @Nullable String password) {
        this.user = user;
        this.password = password;
    }

    private final int getCurrentTimestamp() {
        return (int)(System.currentTimeMillis() / (long)1000 - (long)this.timestamp);
    }

    public final void sendChunkSize(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (RtmpConfig.INSTANCE.getWriteChunkSize() != 128) {
            SetChunkSize chunkSize = new SetChunkSize(RtmpConfig.INSTANCE.getWriteChunkSize());
            chunkSize.getHeader().setTimeStamp(this.getCurrentTimestamp());
            chunkSize.getHeader().setMessageStreamId(this.streamId);
            chunkSize.writeHeader(output);
            chunkSize.writeBody(output);
            output.flush();
            Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"send ", (Object)chunkSize));
        } else {
            Log.i((String)this.TAG, (String)"using default write chunk size 128");
        }
    }

    public final void sendConnect(@NotNull String auth, @NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        CommandsManager commandsManager = this;
        ++commandsManager.commandId;
        CommandAmf0 connect = new CommandAmf0("connect", commandsManager.commandId, this.getCurrentTimestamp(), this.streamId, new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_CONNECTION.getMark()));
        AmfObject connectInfo = new AmfObject(null, 1, null);
        connectInfo.setProperty("app", Intrinsics.stringPlus((String)this.appName, (Object)auth));
        connectInfo.setProperty("flashVer", "FMLE/3.0 (compatible; Lavf57.56.101)");
        connectInfo.setProperty("swfUrl", "");
        connectInfo.setProperty("tcUrl", Intrinsics.stringPlus((String)this.tcUrl, (Object)auth));
        connectInfo.setProperty("fpad", false);
        connectInfo.setProperty("capabilities", 239.0);
        if (this.audioDisabled) {
            connectInfo.setProperty("audioCodecs", 3191.0);
        }
        if (this.videoDisabled) {
            connectInfo.setProperty("videoCodecs", 252.0);
            connectInfo.setProperty("videoFunction", 1.0);
        }
        connectInfo.setProperty("pageUrl", "");
        connectInfo.setProperty("objectEncoding", 0.0);
        connect.addData(connectInfo);
        connect.writeHeader(output);
        connect.writeBody(output);
        output.flush();
        this.sessionHistory.setPacket(this.commandId, "connect");
        Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"send ", (Object)connect));
    }

    public final void createStream(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        CommandsManager commandsManager = this;
        ++commandsManager.commandId;
        CommandAmf0 releaseStream = new CommandAmf0("releaseStream", commandsManager.commandId, this.getCurrentTimestamp(), this.streamId, new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        releaseStream.addData(new AmfNull());
        releaseStream.addData(new AmfString(this.streamName));
        releaseStream.writeHeader(output);
        releaseStream.writeBody(output);
        this.sessionHistory.setPacket(this.commandId, "releaseStream");
        Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"send ", (Object)releaseStream));
        CommandsManager commandsManager2 = this;
        ++commandsManager2.commandId;
        CommandAmf0 fcPublish = new CommandAmf0("FCPublish", commandsManager2.commandId, this.getCurrentTimestamp(), this.streamId, new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        fcPublish.addData(new AmfNull());
        fcPublish.addData(new AmfString(this.streamName));
        fcPublish.writeHeader(output);
        fcPublish.writeBody(output);
        this.sessionHistory.setPacket(this.commandId, "FCPublish");
        Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"send ", (Object)fcPublish));
        CommandsManager commandsManager3 = this;
        ++commandsManager3.commandId;
        CommandAmf0 createStream = new CommandAmf0("createStream", commandsManager3.commandId, this.getCurrentTimestamp(), this.streamId, new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_CONNECTION.getMark()));
        createStream.addData(new AmfNull());
        createStream.writeHeader(output);
        createStream.writeBody(output);
        output.flush();
        this.sessionHistory.setPacket(this.commandId, "createStream");
        Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"send ", (Object)createStream));
    }

    @NotNull
    public final RtmpMessage readMessageResponse(@NotNull InputStream input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        RtmpMessage message = RtmpMessage.Companion.getRtmpMessage(input, this.readChunkSize, this.sessionHistory);
        this.sessionHistory.setReadHeader(message.getHeader());
        Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"read ", (Object)message));
        return message;
    }

    public final void sendMetadata(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "@setDataFrame";
        DataAmf0 metadata = new DataAmf0(name, this.getCurrentTimestamp(), this.streamId, null, 8, null);
        metadata.addData(new AmfString("onMetaData"));
        AmfEcmaArray amfEcmaArray = new AmfEcmaArray(null, 1, null);
        amfEcmaArray.setProperty("duration", 0.0);
        if (this.videoDisabled) {
            amfEcmaArray.setProperty("width", this.width);
            amfEcmaArray.setProperty("height", this.height);
            amfEcmaArray.setProperty("videocodecid", 7.0);
            amfEcmaArray.setProperty("framerate", this.fps);
            amfEcmaArray.setProperty("videodatarate", 0.0);
        }
        if (this.audioDisabled) {
            amfEcmaArray.setProperty("audiocodecid", 10.0);
            amfEcmaArray.setProperty("audiosamplerate", this.sampleRate);
            amfEcmaArray.setProperty("audiosamplesize", 16.0);
            amfEcmaArray.setProperty("audiodatarate", 0.0);
        }
        amfEcmaArray.setProperty("stereo", this.isStereo);
        amfEcmaArray.setProperty("filesize", 0.0);
        metadata.addData(amfEcmaArray);
        metadata.writeHeader(output);
        metadata.writeBody(output);
        output.flush();
        Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"send ", (Object)metadata));
    }

    public final void sendPublish(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "publish";
        CommandsManager commandsManager = this;
        ++commandsManager.commandId;
        CommandAmf0 publish = new CommandAmf0(name, commandsManager.commandId, this.getCurrentTimestamp(), this.streamId, new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        publish.addData(new AmfNull());
        publish.addData(new AmfString(this.streamName));
        publish.addData(new AmfString("live"));
        publish.writeHeader(output);
        publish.writeBody(output);
        output.flush();
        this.sessionHistory.setPacket(this.commandId, name);
        Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"send ", (Object)publish));
    }

    public final void sendWindowAcknowledgementSize(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        WindowAcknowledgementSize windowAcknowledgementSize = new WindowAcknowledgementSize(RtmpConfig.INSTANCE.getAcknowledgementWindowSize(), this.getCurrentTimestamp());
        windowAcknowledgementSize.writeHeader(output);
        windowAcknowledgementSize.writeBody(output);
        output.flush();
    }

    public final void sendPong(@NotNull Event event, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        UserControl pong = new UserControl(Type.PONG_REPLY, event);
        pong.writeHeader(output);
        pong.writeBody(output);
        output.flush();
        Log.i((String)this.TAG, (String)"send pong");
    }

    public final void sendClose(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "closeStream";
        CommandsManager commandsManager = this;
        ++commandsManager.commandId;
        CommandAmf0 closeStream = new CommandAmf0(name, commandsManager.commandId, this.getCurrentTimestamp(), this.streamId, new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        closeStream.addData(new AmfNull());
        closeStream.writeHeader(output);
        closeStream.writeBody(output);
        output.flush();
        this.sessionHistory.setPacket(this.commandId, name);
        Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"send ", (Object)closeStream));
    }

    public final int sendVideoPacket(@NotNull FlvPacket flvPacket, @NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)flvPacket, (String)"flvPacket");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this.akamaiTs) {
            flvPacket.setTimeStamp((System.nanoTime() / (long)1000 - this.startTs) / (long)1000);
        }
        Video video = new Video(flvPacket, this.streamId);
        video.writeHeader(output);
        video.writeBody(output);
        output.flush();
        return video.getHeader().getPacketLength();
    }

    public final int sendAudioPacket(@NotNull FlvPacket flvPacket, @NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)flvPacket, (String)"flvPacket");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this.akamaiTs) {
            flvPacket.setTimeStamp((System.nanoTime() / (long)1000 - this.startTs) / (long)1000);
        }
        Audio audio = new Audio(flvPacket, this.streamId);
        audio.writeHeader(output);
        audio.writeBody(output);
        output.flush();
        return audio.getHeader().getPacketLength();
    }

    public final void reset() {
        this.startTs = 0L;
        this.timestamp = 0;
        this.streamId = 0;
        this.commandId = 0;
        this.sessionHistory.reset();
    }
}

