/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.packets;

import com.github.faucamp.simplertmp.Util;
import com.github.faucamp.simplertmp.io.ChunkStreamInfo;
import com.github.faucamp.simplertmp.packets.RtmpHeader;
import com.github.faucamp.simplertmp.packets.RtmpPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class UserControl
extends RtmpPacket {
    private Type type;
    private int[] eventData;

    public UserControl(RtmpHeader header) {
        super(header);
    }

    public UserControl(ChunkStreamInfo channelInfo) {
        super(new RtmpHeader(channelInfo.canReusePrevHeaderTx(RtmpHeader.MessageType.USER_CONTROL_MESSAGE) ? RtmpHeader.ChunkType.TYPE_2_RELATIVE_TIMESTAMP_ONLY : RtmpHeader.ChunkType.TYPE_0_FULL, 2, RtmpHeader.MessageType.USER_CONTROL_MESSAGE));
    }

    public UserControl(UserControl replyToPing, ChunkStreamInfo channelInfo) {
        this(Type.PONG_REPLY, channelInfo);
        this.eventData = replyToPing.eventData;
    }

    public UserControl(Type type, ChunkStreamInfo channelInfo) {
        this(channelInfo);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getFirstEventData() {
        return this.eventData[0];
    }

    public int[] getEventData() {
        return this.eventData;
    }

    public void setEventData(int eventData) {
        if (this.type == Type.SET_BUFFER_LENGTH) {
            throw new IllegalStateException("SET_BUFFER_LENGTH requires two event data values; use setEventData(int, int) instead");
        }
        this.eventData = new int[]{eventData};
    }

    public void setEventData(int streamId, int bufferLength) {
        if (this.type != Type.SET_BUFFER_LENGTH) {
            throw new IllegalStateException("User control type " + (Object)((Object)this.type) + " requires only one event data value; use setEventData(int) instead");
        }
        this.eventData = new int[]{streamId, bufferLength};
    }

    @Override
    public void readBody(InputStream in) throws IOException {
        this.type = Type.valueOf(Util.readUnsignedInt16(in));
        int bytesRead = 2;
        if (this.type == Type.SET_BUFFER_LENGTH) {
            this.setEventData(Util.readUnsignedInt32(in), Util.readUnsignedInt32(in));
            bytesRead += 8;
        } else {
            this.setEventData(Util.readUnsignedInt32(in));
            bytesRead += 4;
        }
        assert (this.header.getPacketLength() == bytesRead);
    }

    @Override
    protected void writeBody(OutputStream out) throws IOException {
        Util.writeUnsignedInt16(out, this.type.getIntValue());
        Util.writeUnsignedInt32(out, this.eventData[0]);
        if (this.type == Type.SET_BUFFER_LENGTH) {
            Util.writeUnsignedInt32(out, this.eventData[1]);
        }
    }

    @Override
    protected byte[] array() {
        return null;
    }

    @Override
    protected int size() {
        return 0;
    }

    public String toString() {
        return "RTMP User Control (type: " + (Object)((Object)this.type) + ", event data: " + this.eventData + ")";
    }

    public static enum Type {
        STREAM_BEGIN(0),
        STREAM_EOF(1),
        STREAM_DRY(2),
        SET_BUFFER_LENGTH(3),
        STREAM_IS_RECORDED(4),
        PING_REQUEST(6),
        PONG_REPLY(7),
        BUFFER_EMPTY(31),
        BUFFER_READY(32);

        private int intValue;
        private static final Map<Integer, Type> quickLookupMap;

        private Type(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static Type valueOf(int intValue) {
            return quickLookupMap.get(intValue);
        }

        static {
            quickLookupMap = new HashMap<Integer, Type>();
            for (Type type : Type.values()) {
                quickLookupMap.put(type.getIntValue(), type);
            }
        }
    }
}

