/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.io;

import com.github.faucamp.simplertmp.Util;
import com.github.faucamp.simplertmp.packets.RtmpHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkStreamInfo {
    public static final byte RTMP_CID_PROTOCOL_CONTROL = 2;
    public static final byte RTMP_CID_OVER_CONNECTION = 3;
    public static final byte RTMP_CID_OVER_CONNECTION2 = 4;
    public static final byte RTMP_CID_OVER_STREAM = 5;
    public static final byte RTMP_CID_VIDEO = 6;
    public static final byte RTMP_CID_AUDIO = 7;
    private RtmpHeader prevHeaderRx;
    private RtmpHeader prevHeaderTx;
    private static long sessionBeginTimestamp;
    private long realLastTimestamp = System.nanoTime() / 1000000L;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(131072);

    public RtmpHeader prevHeaderRx() {
        return this.prevHeaderRx;
    }

    public void setPrevHeaderRx(RtmpHeader previousHeader) {
        this.prevHeaderRx = previousHeader;
    }

    public RtmpHeader getPrevHeaderTx() {
        return this.prevHeaderTx;
    }

    public boolean canReusePrevHeaderTx(RtmpHeader.MessageType forMessageType) {
        return this.prevHeaderTx != null && this.prevHeaderTx.getMessageType() == forMessageType;
    }

    public void setPrevHeaderTx(RtmpHeader prevHeaderTx) {
        this.prevHeaderTx = prevHeaderTx;
    }

    public static void markSessionTimestampTx() {
        sessionBeginTimestamp = System.nanoTime() / 1000000L;
    }

    public long markAbsoluteTimestampTx() {
        return System.nanoTime() / 1000000L - sessionBeginTimestamp;
    }

    public long markDeltaTimestampTx() {
        long currentTimestamp = System.nanoTime() / 1000000L;
        long diffTimestamp = currentTimestamp - this.realLastTimestamp;
        this.realLastTimestamp = currentTimestamp;
        return diffTimestamp;
    }

    public boolean storePacketChunk(InputStream in, int chunkSize) throws IOException {
        int remainingBytes = this.prevHeaderRx.getPacketLength() - this.baos.size();
        byte[] chunk = new byte[Math.min(remainingBytes, chunkSize)];
        Util.readBytesUntilFull(in, chunk);
        this.baos.write(chunk);
        return this.baos.size() == this.prevHeaderRx.getPacketLength();
    }

    public ByteArrayInputStream getStoredPacketInputStream() {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.baos.toByteArray());
        this.baos.reset();
        return bis;
    }

    public void clearStoredChunks() {
        this.baos.reset();
    }
}

