/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.amf;

import com.github.faucamp.simplertmp.Util;
import com.github.faucamp.simplertmp.amf.AmfData;
import com.github.faucamp.simplertmp.amf.AmfDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class AmfArray
implements AmfData {
    private List<AmfData> items;
    private int size = -1;

    @Override
    public void writeTo(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void readFrom(InputStream in) throws IOException {
        int length = Util.readUnsignedInt32(in);
        this.size = 5;
        this.items = new ArrayList<AmfData>(length);
        for (int i = 0; i < length; ++i) {
            AmfData dataItem = AmfDecoder.readFrom(in);
            this.size += dataItem.getSize();
            this.items.add(dataItem);
        }
    }

    @Override
    public int getSize() {
        if (this.size == -1) {
            this.size = 5;
            if (this.items != null) {
                for (AmfData dataItem : this.items) {
                    this.size += dataItem.getSize();
                }
            }
        }
        return this.size;
    }

    public int getLength() {
        return this.items != null ? this.items.size() : 0;
    }

    public List<AmfData> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<AmfData>();
        }
        return this.items;
    }

    public void addItem(AmfData dataItem) {
        this.getItems().add(this);
    }
}

