/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.audio;

import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import com.pedro.encoder.audio.DataTaken;
import com.pedro.encoder.input.audio.GetMicrophoneData;

public class MicrophoneManager {
    private final String TAG = "MicrophoneManager";
    private AudioRecord audioRecord;
    private GetMicrophoneData getMicrophoneData;
    private byte[] pcmBuffer = new byte[4096];
    private byte[] pcmBufferMuted = new byte[11];
    private boolean running = false;
    private int sampleRate = 44100;
    private int audioFormat = 2;
    private int channel = 12;
    private boolean muted = false;

    public MicrophoneManager(GetMicrophoneData getMicrophoneData) {
        this.getMicrophoneData = getMicrophoneData;
    }

    public void createMicrophone() {
        this.createMicrophone(this.sampleRate, true);
        Log.i((String)"MicrophoneManager", (String)"Microphone created, 44100hz, Stereo");
    }

    public void createMicrophone(int sampleRate, boolean isStereo) {
        this.sampleRate = sampleRate;
        if (!isStereo) {
            this.channel = 16;
        }
        this.audioRecord = new AudioRecord(0, sampleRate, this.channel, this.audioFormat, this.getPcmBufferSize() * 4);
        String chl = isStereo ? "Stereo" : "Mono";
        Log.i((String)"MicrophoneManager", (String)("Microphone created, " + sampleRate + "hz, " + chl));
    }

    public void start() {
        this.init();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)-16);
                while (MicrophoneManager.this.running && !Thread.interrupted()) {
                    DataTaken dataTaken = MicrophoneManager.this.read();
                    if (dataTaken != null) {
                        MicrophoneManager.this.getMicrophoneData.inputPcmData(dataTaken.getPcmBuffer(), dataTaken.getSize());
                        continue;
                    }
                    MicrophoneManager.this.running = false;
                }
            }
        }).start();
    }

    private void init() {
        if (this.audioRecord != null) {
            this.audioRecord.startRecording();
            this.running = true;
            Log.i((String)"MicrophoneManager", (String)"Microphone started");
        } else {
            Log.e((String)"MicrophoneManager", (String)"Error starting, microphone was stopped or not created, use createMicrophone() before start()");
        }
    }

    public void mute() {
        this.muted = true;
    }

    public void unMute() {
        this.muted = false;
    }

    public boolean isMuted() {
        return this.muted;
    }

    private DataTaken read() {
        int size = this.muted ? this.audioRecord.read(this.pcmBufferMuted, 0, this.pcmBufferMuted.length) : this.audioRecord.read(this.pcmBuffer, 0, this.pcmBuffer.length);
        if (size <= 0) {
            return null;
        }
        return new DataTaken(this.pcmBuffer, size);
    }

    public void stop() {
        this.running = false;
        if (this.audioRecord != null) {
            this.audioRecord.setRecordPositionUpdateListener(null);
            this.audioRecord.stop();
            this.audioRecord.release();
            this.audioRecord = null;
        }
        Log.i((String)"MicrophoneManager", (String)"Microphone stopped");
    }

    private int getPcmBufferSize() {
        int pcmBufSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channel, (int)2) + 8191;
        return pcmBufSize - pcmBufSize % 8192;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getAudioFormat() {
        return this.audioFormat;
    }

    public int getChannel() {
        return this.channel;
    }

    public boolean isRunning() {
        return this.running;
    }
}

