/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.RequiresApi;
import com.pedro.common.TimeUtils;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0018H\u0014J\b\u0010\u001c\u001a\u00020\u0018H\u0014J\b\u0010\u001d\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lcom/pedro/encoder/input/gl/render/filters/NoiseFilterRender;", "Lcom/pedro/encoder/input/gl/render/filters/BaseFilterRender;", "<init>", "()V", "squareVertexDataFilter", "", "program", "", "aPositionHandle", "aTextureHandle", "uMVPMatrixHandle", "uSTMatrixHandle", "uSamplerHandle", "uTimeHandle", "uStrengthHandle", "startTime", "", "strength", "", "getStrength", "()F", "setStrength", "(F)V", "initGlFilter", "", "context", "Landroid/content/Context;", "drawFilter", "disableResources", "release", "encoder_release"})
@RequiresApi(api=18)
public final class NoiseFilterRender
extends BaseFilterRender {
    @NotNull
    private final float[] squareVertexDataFilter;
    private int program;
    private int aPositionHandle;
    private int aTextureHandle;
    private int uMVPMatrixHandle;
    private int uSTMatrixHandle;
    private int uSamplerHandle;
    private int uTimeHandle;
    private int uStrengthHandle;
    private final long startTime;
    private float strength;

    public NoiseFilterRender() {
        float[] fArray = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        this.squareVertexDataFilter = fArray;
        this.program = -1;
        this.aPositionHandle = -1;
        this.aTextureHandle = -1;
        this.uMVPMatrixHandle = -1;
        this.uSTMatrixHandle = -1;
        this.uSamplerHandle = -1;
        this.uTimeHandle = -1;
        this.uStrengthHandle = -1;
        this.startTime = TimeUtils.getCurrentTimeMillis();
        this.strength = 16.0f;
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    public final float getStrength() {
        return this.strength;
    }

    public final void setStrength(float f) {
        this.strength = f;
    }

    @Override
    protected void initGlFilter(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.noise_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uTimeHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uTime");
        this.uStrengthHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uStrength");
    }

    @Override
    protected void drawFilter() {
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        float time = (float)(TimeUtils.getCurrentTimeMillis() - this.startTime) / 1000.0f;
        GLES20.glUniform1f((int)this.uTimeHandle, (float)time);
        GLES20.glUniform1f((int)this.uStrengthHandle, (float)this.strength);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
    }

    @Override
    protected void disableResources() {
        int[] nArray = new int[]{this.aTextureHandle, this.aPositionHandle};
        GlUtil.disableResources(nArray);
    }

    @Override
    public void release() {
        GLES20.glDeleteProgram((int)this.program);
    }
}

